/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.mediator;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.SourceFactory;
import de.berlin.hu.ppi.wrapper.Protein;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import uk.ac.ebi.kraken.interfaces.common.Value;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxonomyId;
import uk.ac.ebi.kraken.interfaces.uniprot.SecondaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.geneid.GeneId;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.reactome.Reactome;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.refseq.RefSeq;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Field;
import uk.ac.ebi.kraken.uuw.services.remoting.EntryRetrievalService;
import uk.ac.ebi.kraken.uuw.services.remoting.RemoteDataAccessException;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtJAPI;

public class Test_old
implements PpiConstants {
    static EntryRetrievalService entryRetrievalService;
    static Connection con;
    static PreparedStatement selectProteinQuery;
    static PreparedStatement selectProteinByPrimaryUniprotIdQuery;
    static PreparedStatement selectUniprotIdQuery;
    static PreparedStatement insertProteinQuery;
    static PreparedStatement insertUniprotIdQuery;
    static PreparedStatement deleteUniprotIdQuery;
    static PreparedStatement selectInteractionQuery;
    static PreparedStatement insertInteractionQuery;
    static int deferedProteinCount;
    static int deferedInteractionCount;
    static PpiConstants.DB_ID db_source_id;
    static String[] wanted_species;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Please provide mysql username and password as params");
            System.exit(1);
        }
        try {
            String server = "localhost";
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            con = DriverManager.getConnection("jdbc:mysql://" + server + "/ppi?user=" + args[0] + "&password=" + args[1]);
            System.out.println("Connected to Database, preparing statements");
            selectUniprotIdQuery = con.prepareStatement("SELECT protein.protein_id, protein.sequence, protein.species FROM protein, uniprot_id WHERE uniprot_id = ? AND uniprot_id.protein_id = protein.protein_id");
            selectProteinQuery = con.prepareStatement("SELECT * FROM protein WHERE protein_id = ?");
            selectProteinByPrimaryUniprotIdQuery = con.prepareStatement("SELECT * FROM protein WHERE primary_uniprot_id = ?");
            insertProteinQuery = con.prepareStatement("INSERT INTO protein VALUES (NULL,?,?,?,?,?,?,?,NULL,NULL,?,?,NULL)");
            insertUniprotIdQuery = con.prepareStatement("INSERT INTO uniprot_id VALUES (?,?)");
            deleteUniprotIdQuery = con.prepareStatement("DELETE FROM uniprot_id WHERE uniprot_id = ?");
            selectInteractionQuery = con.prepareStatement("SELECT * FROM interaction WHERE protein_id_a = ? AND protein_id_b = ? AND db_source_id = ?");
            insertInteractionQuery = con.prepareStatement("INSERT INTO interaction VALUES(?,?,?,?,?,?,?,?,?)");
        }
        catch (Exception e) {
            System.out.println("Could not instantiate db-connection: " + e);
            System.exit(1);
        }
        wanted_species = new String[6];
        Test_old.wanted_species[0] = "4932";
        Test_old.wanted_species[1] = "6239";
        Test_old.wanted_species[2] = "7227";
        Test_old.wanted_species[3] = "9606";
        Test_old.wanted_species[4] = "10090";
        Test_old.wanted_species[5] = "10116";
        System.out.println("... Done. Starting loading of interactions");
        db_source_id = PpiConstants.DB_ID.INTACT;
        Test_old.loadInteractions(PpiConstants.DB_ID.INTACT);
        db_source_id = PpiConstants.DB_ID.MINT;
    }

    public static void loadInteractions(PpiConstants.DB_ID dbId) {
        Iterable<ProteinInteraction> source = SourceFactory.getInteractionSourceById(dbId);
        int limit = 0;
        for (ProteinInteraction interaction : source) {
            Test_old.processInteraction(interaction);
            if (--limit != 0) continue;
            break;
        }
    }

    public static void processInteraction(ProteinInteraction in_interaction) {
        int i;
        System.out.println("-----------------------------");
        Properties interaction = new Properties();
        Properties[] interactors = new Properties[in_interaction.getInteractors().size()];
        boolean all_proteins_fetched = true;
        int interactor_num = 0;
        System.out.println("Loading proteins ...");
        for (Protein prot : in_interaction.getInteractors()) {
            Map<String, String> ids = prot.getAllIds();
            String uid = ids.get("uniprotkb");
            if (uid != null || (uid = ids.get("uniprot")) != null) {
                System.out.println("processing uniprotid " + uid);
                Properties new_protein = Test_old.loadProtein(prot, uid);
                if (new_protein == null) {
                    all_proteins_fetched = false;
                    continue;
                }
                interactors[interactor_num++] = new_protein;
                continue;
            }
            all_proteins_fetched = false;
        }
        if (!all_proteins_fetched) {
            Test_old.deferInteraction(interaction, interactors, "Not all proteins could be loaded");
            return;
        }
        System.out.println("... Done");
        System.out.println("Performing checks on proteins ...");
        boolean all_checks_ok = true;
        if (!Test_old.checkProteins(interactors)) {
            all_checks_ok = false;
        }
        if (!all_checks_ok) {
            Test_old.ignoreInteraction(interaction, interactors, "Proteinchecks were not ok");
            return;
        }
        System.out.println("... Done");
        System.out.println("Inserting proteins into the db ...");
        boolean all_proteins_in_db = true;
        for (i = 0; i < interactors.length; ++i) {
            if (interactors[i].getProperty("protein_id") != null) continue;
            try {
                int protein_id = Test_old.insertProtein(interactors[i]);
                interactors[i].setProperty("protein_id", "" + protein_id);
                continue;
            }
            catch (SQLException e) {
                System.out.println("Couldn't insert protein into db: " + e);
                all_proteins_in_db = false;
                System.exit(1);
            }
        }
        if (!all_proteins_in_db) {
            Test_old.ignoreInteraction(interaction, interactors, "Not all proteins could be inserted into the db");
            return;
        }
        System.out.println("... Done");
        System.out.println("Inserting interaction(s) into the db ...");
        try {
            for (i = 0; i < interactors.length; ++i) {
                for (int j = i + 1; j < interactors.length; ++j) {
                    selectInteractionQuery.setInt(1, Integer.parseInt(interactors[i].getProperty("protein_id")));
                    selectInteractionQuery.setInt(2, Integer.parseInt(interactors[j].getProperty("protein_id")));
                    selectInteractionQuery.setInt(3, db_source_id.ordinal());
                    ResultSet rs = selectInteractionQuery.executeQuery();
                    if (rs.next()) continue;
                    System.out.println("+++ Inserting new interaction!");
                    Test_old.insertInteraction(interaction, interactors[i], interactors[j]);
                }
            }
        }
        catch (SQLException e) {
            System.out.println("Couldn't insert interaction into db: " + e);
            System.exit(1);
        }
        System.out.println("DONE!");
    }

    public static void insertInteraction(Properties interaction, Properties interactor_a, Properties interactor_b) throws SQLException {
        insertInteractionQuery.setInt(1, Integer.parseInt(interactor_a.getProperty("protein_id")));
        insertInteractionQuery.setInt(2, Integer.parseInt(interactor_b.getProperty("protein_id")));
        insertInteractionQuery.setInt(3, db_source_id.ordinal());
        insertInteractionQuery.setString(4, interaction.getProperty("detection_method"));
        insertInteractionQuery.setString(5, interaction.getProperty("interaction_type"));
        insertInteractionQuery.setString(6, interaction.getProperty("predicted"));
        insertInteractionQuery.setString(7, interaction.getProperty("complex_ppi"));
        insertInteractionQuery.setString(8, interaction.getProperty("disease_ppi"));
        insertInteractionQuery.setString(9, interaction.getProperty("demerged"));
    }

    public static boolean checkProteins(Properties[] interactors) {
        int i;
        if (interactors.length < 2) {
            return false;
        }
        String species = interactors[0].getProperty("species");
        boolean ok = false;
        for (i = 0; i < wanted_species.length; ++i) {
            if (species.compareTo(wanted_species[i]) != 0) continue;
            ok = true;
            break;
        }
        if (!ok) {
            System.out.println("species is not wanted: " + species);
            return false;
        }
        ok = true;
        for (i = 0; i < interactors.length; ++i) {
            if (interactors[i].getProperty("sequence") == null) {
                ok = false;
                System.out.println("protein has no sequence");
            } else if (interactors[i].getProperty("species").compareTo(species) != 0) {
                ok = false;
                System.out.println("species mismatch");
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    public static Properties loadProtein(Protein protein, String uniprotid) {
        try {
            selectUniprotIdQuery.setString(1, uniprotid);
            ResultSet rs = selectUniprotIdQuery.executeQuery();
            if (rs.next()) {
                Properties known_protein = new Properties();
                System.out.println("... already in DB");
                known_protein.setProperty("protein_id", rs.getString("protein_id"));
                known_protein.setProperty("sequence", rs.getString("sequence"));
                known_protein.setProperty("species", rs.getString("species"));
                return known_protein;
            }
            rs.close();
            Properties ProteinProperties = Test_old.retrieveUniprotEntry(uniprotid);
            System.out.println("... retrieving from UniProt");
            if (ProteinProperties == null) {
                System.out.println("Couldn't retrieve protein from UniProt!");
                return null;
            }
        }
        catch (SQLException e) {
            System.out.println(e);
            System.exit(1);
        }
        return null;
    }

    public static int insertProtein(Properties protein) throws SQLException {
        insertProteinQuery.setString(1, protein.getProperty("protein_name", ""));
        insertProteinQuery.setString(2, protein.getProperty("sequence"));
        insertProteinQuery.setString(3, protein.getProperty("species"));
        insertProteinQuery.setString(4, protein.getProperty("primary_uniprot_id"));
        insertProteinQuery.setString(5, protein.getProperty("gene_id"));
        insertProteinQuery.setString(6, protein.getProperty("ref_seq"));
        insertProteinQuery.setString(7, protein.getProperty("org_specific_id"));
        insertProteinQuery.setString(8, protein.getProperty("reactome"));
        insertProteinQuery.setString(9, protein.getProperty("ec_number"));
        int inserted = insertProteinQuery.executeUpdate();
        if (inserted != 1) {
            throw new SQLException("insertion of new Protein didn't return '1'");
        }
        selectProteinByPrimaryUniprotIdQuery.setString(1, protein.getProperty("primary_uniprot_id"));
        ResultSet rs = selectProteinByPrimaryUniprotIdQuery.executeQuery();
        if (!rs.next()) {
            throw new SQLException("couldn't find freshly inserted protein by primary uniprot id");
        }
        int protein_id = rs.getInt(1);
        rs.close();
        insertUniprotIdQuery.setString(1, protein.getProperty("primary_uniprot_id"));
        insertUniprotIdQuery.setInt(2, protein_id);
        if (insertUniprotIdQuery.executeUpdate() != 1) {
            throw new SQLException("insertion of primary_uniprot_id into uniprot_id for new protein failed");
        }
        String[] sec_accessions = protein.getProperty("secondary_uniprot_ids").split(";");
        for (int i = 0; i < sec_accessions.length; ++i) {
            if (sec_accessions[i] == "") continue;
            insertUniprotIdQuery.setString(1, sec_accessions[i]);
            insertUniprotIdQuery.setInt(2, protein_id);
            try {
                if (insertUniprotIdQuery.executeUpdate() == 1) continue;
                throw new SQLException("insertion of primary_uniprot_id into uniprot_id for new protein failed");
            }
            catch (SQLException e) {
                if (e.toString().matches(".*Duplicate entry '\\w+' for key 1")) {
                    System.out.println("Secondary key " + sec_accessions[i] + " found as duplicate. Removing from db");
                    deleteUniprotIdQuery.setString(1, sec_accessions[i]);
                    deleteUniprotIdQuery.executeUpdate();
                    throw e;
                }
                throw e;
            }
        }
        System.out.println("... inserted into DB with protein_id " + protein_id);
        return protein_id;
    }

    public static Properties retrieveUniprotEntry(String acc) {
        Properties protein;
        block11: {
            protein = new Properties();
            try {
                UniProtEntry entry = UniProtJAPI.factory.getEntryRetrievalService().getUniProtEntry(acc);
                if (entry != null) {
                    if (entry.getProteinDescription().hasRecommendedName()) {
                        for (Field f : entry.getProteinDescription().getRecommendedName().getFields()) {
                            if (f.getType().getValue() != "Full") continue;
                            protein.setProperty("protein_name", f.getValue());
                            break;
                        }
                    }
                    protein.setProperty("sequence", entry.getSequence().getValue());
                    Iterator<Value> i$ = entry.getNcbiTaxonomyIds().iterator();
                    if (i$.hasNext()) {
                        NcbiTaxonomyId ti = (NcbiTaxonomyId)i$.next();
                        protein.setProperty("species", ti.getValue());
                    }
                    protein.setProperty("primary_uniprot_id", entry.getPrimaryUniProtAccession().getValue());
                    String secacc = "";
                    for (SecondaryUniProtAccession sec : entry.getSecondaryUniProtAccessions()) {
                        secacc = secacc + sec.getValue() + ";";
                    }
                    protein.setProperty("secondary_uniprot_ids", secacc);
                    List idlist = entry.getDatabaseCrossReferences(DatabaseType.GENEID);
                    for (GeneId geneid : idlist) {
                        if (!geneid.hasGeneIdAccessionNumber()) continue;
                        protein.setProperty("gene_id", geneid.getGeneIdAccessionNumber().getValue());
                        break;
                    }
                    List seqlist = entry.getDatabaseCrossReferences(DatabaseType.REFSEQ);
                    for (RefSeq item : seqlist) {
                        if (!item.hasRefSeqAccessionNumber()) continue;
                        protein.setProperty("refseq", item.getRefSeqAccessionNumber().getValue());
                        break;
                    }
                    List rctlist = entry.getDatabaseCrossReferences(DatabaseType.REACTOME);
                    for (Reactome item : rctlist) {
                        if (!item.hasReactomeAccessionNumber()) continue;
                        protein.setProperty("reactome", item.getReactomeAccessionNumber().getValue());
                        break;
                    }
                    for (String ec : entry.getProteinDescription().getEcNumbers()) {
                        protein.setProperty("ec_number", ec);
                    }
                    break block11;
                }
                System.out.println("Entry is null for [" + acc + "]");
                return null;
            }
            catch (RemoteDataAccessException e) {
                System.err.println(e);
                System.exit(1);
            }
        }
        return protein;
    }

    public static void deferInteraction(Properties interaction, Properties[] interactors, String message) {
    }

    public static void ignoreInteraction(Properties interaction, Properties[] interactors, String message) {
    }

    static {
        con = null;
        deferedProteinCount = 0;
        deferedInteractionCount = 0;
    }
}

