/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.mediator;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.SourceFactory;
import de.berlin.hu.ppi.db.DbService;
import de.berlin.hu.ppi.mediator.InteractionLoader;
import de.berlin.hu.ppi.mediator.LoaderException;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SourceLoader
implements Runnable {
    Logger log;
    PpiConstants.DB_ID source_id;
    InteractionLoader interactionLoader;
    private DbService db_service;
    int source_total_interaction_count = -1;
    int source_current_interaction_number = -1;

    public SourceLoader(PpiConstants.DB_ID dbId) {
        this.source_id = dbId;
        this.db_service = DbService.getCurrentService();
        try {
            this.interactionLoader = new InteractionLoader(dbId, DbService.getCurrentService().getNewConnection());
        }
        catch (Exception e) {
            this.log.error("", e);
        }
        this.log = Logger.getLogger(SourceLoader.class);
    }

    public int load(int limit) {
        int failed_protein_count = 0;
        int loaded_protein_count = 0;
        int inserted_interaction_count = 0;
        this.source_current_interaction_number = 0;
        Iterable<ProteinInteraction> source = SourceFactory.getInteractionSourceById(this.source_id);
        for (ProteinInteraction interaction : source) {
            ++this.source_current_interaction_number;
            try {
                this.interactionLoader.load(interaction);
                inserted_interaction_count += this.interactionLoader.getInteractionCount();
            }
            catch (LoaderException e) {
                this.handleLoaderException(e);
            }
            if (this.interactionLoader.getFailedProteins() != null) {
                failed_protein_count += this.interactionLoader.getFailedProteins().size();
            }
            if (this.interactionLoader.getLoadedProteins() != null) {
                loaded_protein_count += this.interactionLoader.getLoadedProteins().size();
            }
            if (--limit != 0) continue;
            break;
        }
        this.log.info("proteins with no mapping found: " + this.interactionLoader.no_mapping_count);
        this.log.info("proteins failing to load: " + failed_protein_count);
        this.log.info("proteins loaded ok: " + loaded_protein_count);
        return inserted_interaction_count;
    }

    public int load() {
        return this.load(-1);
    }

    @Override
    public void run() {
        this.load();
    }

    public int getTotalInteractionCount() {
        if (this.source_total_interaction_count == -1) {
            this.source_total_interaction_count = 0;
            Iterator<ProteinInteraction> source = SourceFactory.getInteractionSourceById(this.source_id).iterator();
            if (source == null) {
                this.log.error("no source");
                return 0;
            }
            while (source.hasNext()) {
                source.next();
                ++this.source_total_interaction_count;
            }
        }
        return this.source_total_interaction_count;
    }

    public int getCurrentInteractionNumber() {
        return this.source_current_interaction_number;
    }

    public double getProgress() {
        if (this.source_total_interaction_count == -1 || this.source_current_interaction_number == -1) {
            return -1.0;
        }
        return (double)this.source_current_interaction_number / (double)this.source_total_interaction_count;
    }

    private void handleLoaderException(LoaderException e) {
        this.log.error(e);
    }
}

