/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.mediator;

import de.berlin.hu.ppi.wrapper.Protein;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntryType;
import uk.ac.ebi.kraken.uuw.services.remoting.EntryRetrievalService;
import uk.ac.ebi.kraken.uuw.services.remoting.UniProtJAPI;

public class ProteinResolver {
    Logger log = Logger.getLogger(ProteinResolver.class);
    Connection con;
    PreparedStatement mapStatement;
    PreparedStatement mapLikeStatement;
    EntryRetrievalService entryRetrievalService;

    public ProteinResolver(Connection con) {
        try {
            this.con = con;
            this.mapLikeStatement = con.prepareStatement("SELECT uniprot_id FROM lookup_mapping WHERE foreign_key like ? AND foreign_db = ?");
            this.mapStatement = con.prepareStatement("SELECT uniprot_id FROM lookup_mapping WHERE foreign_key = ? AND foreign_db = ?");
        }
        catch (Exception e) {
            this.log.error("", e);
        }
        this.entryRetrievalService = UniProtJAPI.factory.getEntryRetrievalService();
    }

    public String resolve(Protein protein) {
        String[] up_id;
        String[] upids = null;
        String id = protein.getIdValue("refseq");
        if (id != null) {
            if (!id.matches("\\.\\d$")) {
                id = id + ".%";
            }
            if ((up_id = this.getForKeyLike(id, "RefSeq")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
                return upids[0];
            }
        }
        if ((id = protein.getIdValue("dip")) != null && (up_id = this.getForKey(id, "DIP")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("entrez protein");
        if (id != null && (up_id = this.getForKey(id, "GeneID")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("protein gi");
        if (id != null && (up_id = this.getForKey(id, "GI")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("flybase");
        if (id != null && (up_id = this.getForKey(id, "FlyBase")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("wormbase");
        if (id != null && (up_id = this.getForKey(id, "WormBase")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("entrezgene");
        if (id != null && (up_id = this.getForKey(id, "GeneID")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("mgi");
        if (id != null && (up_id = this.getForKey(id = "MGI:" + id, "MGI")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("ensembl");
        if (id != null && (up_id = this.getForKey(id, "Ensembl")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("sgd");
        if (id != null && (up_id = this.getForKey(id, "SGD")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("hgnc");
        if (id != null && (up_id = this.getForKey(id = "HGNC:" + id, "HGNC")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("omim");
        if (id != null && (up_id = this.getForKey(id, "MIM")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("pdb");
        if (id != null && (up_id = this.getForKey(id, "PDB")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("ipi");
        if (id != null && (up_id = this.getForKey(id, "IPI")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("uniparc");
        if (id != null && (up_id = this.getForKey(id, "UniParc")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("genebank");
        if (id != null && (up_id = this.getForKey(id, "EMBL")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        id = protein.getIdValue("genbank_protein_gi");
        if (id != null && (up_id = this.getForKey(id, "GI")) != null && (upids = this.checkUpids(up_id, upids)).length == 1) {
            return upids[0];
        }
        if (upids != null) {
            String mykey = this.disambiguateKeys(upids);
            if (mykey == null) {
                this.log.info("disambiguation not successfull");
            } else {
                this.log.info("Resolved to " + mykey);
            }
            return mykey;
        }
        return null;
    }

    public String[] getForKey(String id, String db) {
        this.log.info("Mapping locally for " + db + " key " + id);
        try {
            this.mapStatement.setString(1, id);
            this.mapStatement.setString(2, db);
            ResultSet rs = this.mapStatement.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            if (count == 0) {
                this.log.info("No mapping found for " + db + " key " + id);
                return null;
            }
            String[] up_ids = new String[count];
            count = 0;
            rs.beforeFirst();
            while (rs.next()) {
                up_ids[count] = rs.getString(1);
                this.log.info("############################");
                this.log.info(up_ids[count]);
                ++count;
            }
            return up_ids;
        }
        catch (SQLException e) {
            this.log.error(e);
            return null;
        }
    }

    String[] getForKeyLike(String id, String db) {
        this.log.info("Mapping locally for " + db + " key like " + id);
        try {
            this.mapLikeStatement.setString(1, id);
            this.mapLikeStatement.setString(2, db);
            ResultSet rs = this.mapLikeStatement.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            if (count == 0) {
                this.log.info("No mapping found for " + db + " key " + id);
                return null;
            }
            String[] up_ids = new String[count];
            count = 0;
            rs.beforeFirst();
            while (rs.next()) {
                up_ids[count] = rs.getString(1);
                this.log.info("############################");
                this.log.info(up_ids[count]);
                ++count;
            }
            return up_ids;
        }
        catch (SQLException e) {
            this.log.error(e);
            return null;
        }
    }

    private String disambiguateKeys(String[] upids) {
        this.log.info("--- disambiguating");
        String outUniprotId = null;
        String lastType = "";
        boolean ambiguous = false;
        for (int i = 0; i < upids.length; ++i) {
            String type = this.getUniprotEntryType(upids[i]);
            this.log.info("---- " + upids[i] + " : " + type);
            if (type == null) continue;
            if (type.equals("swissprot")) {
                if (lastType.equals("swissprot")) {
                    return null;
                }
                lastType = "swissprot";
                outUniprotId = upids[i];
                continue;
            }
            if (!type.equals("trembl") || lastType.equals("swissprot")) continue;
            if (lastType.equals("trembl")) {
                ambiguous = true;
                continue;
            }
            lastType = "trembl";
            outUniprotId = upids[i];
        }
        if (lastType == "swissprot") {
            return outUniprotId;
        }
        if (lastType == "trembl" && !ambiguous) {
            return outUniprotId;
        }
        return null;
    }

    private String getUniprotEntryType(String upid) {
        try {
            UniProtEntry entry = this.entryRetrievalService.getUniProtEntry(upid);
            if (entry != null) {
                UniProtEntryType type = entry.getType();
                if (type == UniProtEntryType.SWISSPROT) {
                    return "swissprot";
                }
                if (type == UniProtEntryType.TREMBL) {
                    return "trembl";
                }
                if (type == UniProtEntryType.UNKNOWN) {
                    return "unknown";
                }
            } else {
                this.log.info("Entry is null for [" + upid + "]");
                return null;
            }
            this.log.info("unable to retrieve entry type!");
            System.exit(1);
        }
        catch (Exception e) {
            this.log.error(upid, e);
        }
        return null;
    }

    private String[] checkUpids(String[] new_upids, String[] old_upids) {
        if (old_upids == null) {
            return new_upids;
        }
        if (old_upids.length > new_upids.length) {
            return new_upids;
        }
        return old_upids;
    }
}

