/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.mediator;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.db.DbService;
import de.berlin.hu.ppi.mediator.InteractionChecker;
import de.berlin.hu.ppi.mediator.LoaderException;
import de.berlin.hu.ppi.mediator.ProteinLoader;
import de.berlin.hu.ppi.mediator.dbx.DBInteraction;
import de.berlin.hu.ppi.mediator.dbx.DBInteractionService;
import de.berlin.hu.ppi.mediator.dbx.DBProtein;
import de.berlin.hu.ppi.mediator.dbx.DBProteinService;
import de.berlin.hu.ppi.wrapper.Experiment;
import de.berlin.hu.ppi.wrapper.Protein;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class InteractionLoader {
    Logger log;
    ProteinLoader proteinLoader;
    DBInteractionService dbInteractionService;
    DbService db_service;
    PpiConstants.DB_ID source_id;
    private Connection connnection;
    Set<Protein> proteins_failing_to_load = null;
    Set<Protein> proteins_loaded = null;
    int inserted_interaction_count = 0;
    protected int no_mapping_count = 0;

    public InteractionLoader(PpiConstants.DB_ID source_id, Connection con) {
        this.connnection = con;
        this.source_id = source_id;
        this.proteinLoader = new ProteinLoader(con);
        this.dbInteractionService = new DBInteractionService(con, new DBProteinService(con));
        this.log = Logger.getLogger(InteractionLoader.class);
    }

    public boolean load(ProteinInteraction in_interaction) throws LoaderException {
        this.log.info("-----------------------------");
        this.proteins_failing_to_load = null;
        this.proteins_loaded = null;
        this.inserted_interaction_count = 0;
        Collection<Protein> in_interactors = in_interaction.getInteractors();
        if (in_interactors.size() < 2) {
            throw new LoaderException("Source interaction only contains 1 Protein. Won't handle");
        }
        DBProtein[][] interactors = new DBProtein[in_interactors.size()][];
        this.proteins_failing_to_load = new HashSet<Protein>();
        this.proteins_loaded = new HashSet<Protein>();
        this.log.info("Loading interaction with " + interactors.length + " interactors");
        Properties interaction_properties = new Properties();
        String experiments = "";
        for (Experiment exp : in_interaction.getExperiments()) {
            if (exp.getDetectionMethod() != null || exp.getPubmedIds() != null) {
                experiments = experiments + (exp.getDetectionMethod() == null ? "null" : exp.getDetectionMethod());
                experiments = experiments + "---";
                experiments = experiments + (exp.getPubmedIds() == null ? "null" : (Serializable)exp.getPubmedIds().get(0));
                experiments = experiments + "|";
                continue;
            }
            this.log.warn("Experiment description did not contain a detection method neither a pubmed id.");
        }
        if (!experiments.trim().isEmpty()) {
            interaction_properties.setProperty("experiments", experiments);
        }
        interaction_properties.setProperty("interaction_type", in_interaction.getInteractionType() == null ? "" : in_interaction.getInteractionType());
        interaction_properties.setProperty("complex_ppi", in_interaction.isComplex() ? "1" : "0");
        interaction_properties.setProperty("disease_ppi", in_interaction.isDisease() ? "1" : "0");
        interaction_properties.setProperty("predicted", in_interaction.isPredicted() ? "1" : "0");
        interaction_properties.setProperty("db_source_id", "" + this.source_id.ordinal());
        boolean all_proteins_fetched = true;
        int good_interactor_count = 0;
        this.log.info("Loading proteins ...");
        for (Protein prot : in_interactors) {
            DBProtein[] new_protein = null;
            new_protein = this.proteinLoader.load(prot);
            this.proteins_loaded.add(prot);
            if (new_protein == null) {
                all_proteins_fetched = false;
                this.proteins_failing_to_load.add(prot);
                continue;
            }
            interactors[good_interactor_count++] = new_protein;
        }
        this.no_mapping_count = this.proteinLoader.no_mappings_count;
        if (!all_proteins_fetched && good_interactor_count < 2) {
            throw new LoaderException("Less than 2 proteins could be successfully loaded for this interaction!");
        }
        this.log.info("... Done loading proteins (" + good_interactor_count + "/" + interactors.length + ")");
        interactors = (DBProtein[][])Arrays.copyOf(interactors, good_interactor_count);
        this.log.info("Inserting interaction(s) into the db ...");
        try {
            for (int i = 0; i < interactors.length; ++i) {
                for (int j = i + 1; j < interactors.length; ++j) {
                    String demerged = interactors[i].length > 1 || interactors[j].length > 1 ? "1" : "0";
                    for (int k = 0; k < interactors[i].length; ++k) {
                        for (int l = 0; l < interactors[j].length; ++l) {
                            DBInteraction interaction = this.dbInteractionService.newDBInteraction(interaction_properties);
                            interaction.setProperty("demerged", demerged);
                            interaction.setProteinA(interactors[i][k]);
                            interaction.setProteinB(interactors[j][l]);
                            if (!InteractionChecker.check(interaction)) continue;
                            interaction.insert();
                            ++this.inserted_interaction_count;
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            this.log.error("Couldn't insert interaction into db.", e);
            return false;
        }
        this.log.info("DONE!");
        return true;
    }

    public Set<Protein> getFailedProteins() {
        return this.proteins_failing_to_load;
    }

    public Set<Protein> getLoadedProteins() {
        return this.proteins_loaded;
    }

    public int getInteractionCount() {
        return this.inserted_interaction_count;
    }

    public Connection getConnnection() {
        return this.connnection;
    }
}

