/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;

public class SqlScript {
    public static final char QUERY_END = ';';
    private BufferedReader reader;
    private Statement statement;

    public SqlScript(BufferedReader reader, Statement statement) throws SQLException {
        this.reader = reader;
        this.statement = statement;
    }

    public void loadScript() throws IOException, SQLException {
        StringBuffer query = new StringBuffer();
        boolean queryEnds = false;
        String line = this.reader.readLine();
        while (line != null) {
            if (this.isComment(line)) continue;
            queryEnds = this.checkStatementEnds(line);
            query.append(line);
            if (queryEnds) {
                this.statement.addBatch(query.toString());
                query.setLength(0);
            }
            line = this.reader.readLine();
        }
    }

    private boolean isComment(String line) {
        if (line != null && line.length() > 0) {
            return line.charAt(0) == '#';
        }
        return false;
    }

    public void execute() throws IOException, SQLException {
        this.statement.executeBatch();
    }

    private boolean checkStatementEnds(String s) {
        return s.indexOf(59) != -1;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }
}

