/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.db;

import com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource;
import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.PpiToolkit;
import de.berlin.hu.ppi.mediator.dbx.DBConnectionProvider;
import de.berlin.hu.ppi.mediator.dbx.DBInteractionService;
import de.berlin.hu.ppi.mediator.dbx.DBLookupProteinService;
import de.berlin.hu.ppi.mediator.dbx.DBProteinService;
import de.berlin.hu.ppi.tool.SqlScriptRunner;
import de.berlin.hu.ppi.tool.TextDeformer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;

public class DbService
implements PpiConstants,
DBConnectionProvider,
Closeable {
    private static DbService instance;
    private Connection staticConnection;
    private Statement statement;
    public DBProteinService dbProteinService;
    public DBInteractionService dbInteractionService;
    public DBLookupProteinService dbLookupProteinService;
    public static final String DEFAULT_DRIVER = "com.mysql.jdbc.Driver";
    private String password;
    public static final String RESSOURCE_SCHEMA_FILE = "de/berlin/hu/ppi/schema.sql";
    private MysqlConnectionPoolDataSource dataSource;
    private static Matcher matcherServer;

    private DbService(String server, int port, String database, String username, String password) throws Exception {
        server = server == null ? "racer.informatik.hu-berlin.de" : server;
        this.password = password;
        this.dataSource = new MysqlConnectionPoolDataSource();
        this.dataSource.setUser(username);
        this.dataSource.setPassword(this.password);
        this.dataSource.setServerName(server);
        this.dataSource.setPort(port);
        if (database != null) {
            this.dataSource.setDatabaseName(database);
        }
    }

    public static void initDataSource(MysqlConnectionPoolDataSource test, Properties settings) {
        test.setDatabaseName(settings.getProperty("pipa.database"));
        test.setServerName(settings.getProperty("pipa.server"));
        test.setUser(settings.getProperty("pipa.username"));
        test.setPassword(settings.getProperty("pipa.password"));
        test.setConnectTimeout(100);
        test.setDatabaseName(settings.getProperty("pipa.database"));
    }

    public DBProteinService createDBProteinService(Connection con) {
        return new DBProteinService(con);
    }

    public DBInteractionService createDBInteractionService(Connection con, DBProteinService dbProteinService) {
        return new DBInteractionService(con, dbProteinService);
    }

    public DBLookupProteinService createDBLookupService(Connection con) {
        return new DBLookupProteinService(con);
    }

    public String getUser() {
        return this.dataSource.getUser();
    }

    public String getServerName() {
        return this.dataSource.getServerName();
    }

    public String getDatabaseName() {
        return this.dataSource.getDatabaseName();
    }

    public static DbService createNewDbService(String server, int port, String database, String username, String password) throws Exception {
        instance = new DbService(server, port, database, username, password);
        return instance;
    }

    public static DbService createMyDbService() throws Exception {
        return DbService.createNewDbService(PpiToolkit.loadSettings());
    }

    public static DbService createNewDbService(Properties settings) throws Exception {
        String password = settings.getProperty("pipa.password");
        if (password == null) {
            password = TextDeformer.decode(settings.getProperty("pipa.password"));
        }
        String server = settings.getProperty("pipa.server");
        matcherServer.reset(server);
        if (matcherServer.matches()) {
            server = matcherServer.group(1);
            int port = 3306;
            String portString = matcherServer.group(3);
            if (portString != null) {
                port = Integer.parseInt(portString);
            }
            return DbService.createNewDbService(server, port, settings.getProperty("pipa.database"), settings.getProperty("pipa.username"), password);
        }
        return null;
    }

    public static DbService createNewDbServiceIgnoreDB(Properties settings) throws Exception {
        String server = settings.getProperty("pipa.server");
        String username = settings.getProperty("pipa.username");
        String password2 = settings.getProperty("pipa.password");
        int port = 3306;
        return DbService.createNewDbService(server, port, null, username, password2);
    }

    public void createNewDatabase(String databaseName) throws SQLException, Exception {
        this.getStaticStatement().executeUpdate("create database " + databaseName);
    }

    public void useDatabase(String databaseName) throws SQLException {
        this.getStaticStatement().executeUpdate("use " + databaseName);
    }

    public static DbService getCurrentService() {
        return instance;
    }

    @Override
    public Connection getStaticConnection() throws SQLException {
        if (this.staticConnection == null || this.staticConnection.isClosed()) {
            this.staticConnection = this.getNewConnection();
        }
        return this.staticConnection;
    }

    public Statement getStaticStatement() throws SQLException {
        if (this.statement == null || this.statement.isClosed()) {
            this.statement = this.getStaticConnection().createStatement();
        }
        return this.statement;
    }

    public DBProteinService getDBProteinService() {
        if (this.dbProteinService == null) {
            this.dbProteinService = new DBProteinService(this.staticConnection);
        }
        return this.dbProteinService;
    }

    public DBLookupProteinService getDBLookupProteinService() throws SQLException {
        if (this.dbLookupProteinService == null) {
            Connection connection = this.getStaticConnection();
            this.dbLookupProteinService = new DBLookupProteinService(connection);
        }
        return this.dbLookupProteinService;
    }

    public DBInteractionService getDBInteractionService() throws SQLException {
        if (this.dbInteractionService == null) {
            Connection connection = this.getStaticConnection();
            DBProteinService service = this.getDBProteinService();
            this.dbInteractionService = new DBInteractionService(connection, service);
        }
        return this.dbInteractionService;
    }

    @Override
    public Connection getNewConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public String getPassword() {
        return this.password;
    }

    public void importSchemaFromRessource(String ressource) throws IOException, SQLException {
        this.importSchema(ClassLoader.getSystemResourceAsStream(ressource));
    }

    public void importSchema(File schemaFile) throws IOException, SQLException {
        this.importSchema(new FileInputStream(schemaFile));
    }

    public void importSchema(InputStream input) throws IOException, SQLException {
        List<String> queries = SqlScriptRunner.extractSqlQueries(input);
        this.runQueries(queries);
    }

    public boolean isCorrectDatabase() {
        try {
            List<String> testTables = Arrays.asList("client_properties", "hui");
            for (String table : testTables) {
                this.getStaticStatement().executeQuery(String.format("select * from %s limit 0", table));
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Properties loadPropertiesFromTable(String table) throws Exception {
        Properties output = new Properties();
        ResultSet result = this.getStaticStatement().executeQuery("select property_key, property_value from " + table);
        while (result.next()) {
            String key = result.getString(1);
            String value = result.getString(2);
            output.put(key, value);
        }
        return output;
    }

    public MysqlDataSource getMysqlDataSource() {
        return this.dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void runQueries(List<String> queries) throws SQLException {
        DbService.runQueries(queries, this.getStaticStatement());
    }

    public static void runQueries(List<String> queries, Statement statement) throws SQLException {
        for (String query : queries) {
            try {
                statement.executeUpdate(query);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 1231) continue;
                throw e;
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.staticConnection.close();
            this.statement.close();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    static {
        matcherServer = Pattern.compile("([^:]*)(:(\\d*))?").matcher("");
    }
}

