/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.client;

import de.berlin.hu.ppi.PpiToolkit;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePluginException;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;

public class UpdatePluginUI
extends Composite {
    private static final String LABEL_TASK_PROGRESS = "Task progress:";
    private static final String LABEL_UPDATE_PROGRESS = "Update progress:";
    private static final String LABEL_START = "Start";
    private static final String LABEL_UPDATE = "Update";
    private static final String LABEL_CANCEL = "Cancel";
    private static final String LABEL_RESET = "Reset";
    UpdatePlugin plugin;
    ProgressBar totalProgressBar;
    ProgressBar currentProgressBar;
    Label name;
    Label description;
    Button control;
    private static Logger log = Logger.getLogger(UpdatePlugin.class);
    private Group group;
    private Display display = Display.getDefault();

    public UpdatePluginUI(Composite parent, int style, UpdatePlugin updatePlugin) {
        super(parent, style);
        String[] labels;
        this.plugin = updatePlugin;
        this.group = new Group((Composite)this, 64);
        this.group.setText(updatePlugin.getName());
        FillLayout fill = new FillLayout();
        this.setLayout((Layout)fill);
        GridLayout grid = new GridLayout();
        grid.numColumns = 2;
        this.group.setLayout((Layout)grid);
        GridData data = new GridData();
        Label updateProgressLabel = new Label((Composite)this.group, 131072);
        updateProgressLabel.setText(LABEL_UPDATE_PROGRESS);
        updateProgressLabel.setLayoutData((Object)data);
        this.totalProgressBar = new ProgressBar((Composite)this.group, 0);
        this.totalProgressBar.setMinimum(0);
        this.totalProgressBar.setMaximum(1000);
        this.totalProgressBar.setLayoutData((Object)new GridData(768));
        Label taskProgressLabel = new Label((Composite)this.group, 131072);
        taskProgressLabel.setText(LABEL_TASK_PROGRESS);
        this.currentProgressBar = new ProgressBar((Composite)this.group, 256);
        this.currentProgressBar.setMinimum(0);
        this.currentProgressBar.setMaximum(1000);
        this.currentProgressBar.setLayoutData((Object)new GridData(768));
        this.control = new Button((Composite)this.group, 8);
        data = new GridData();
        for (String label : labels = new String[]{LABEL_CANCEL, LABEL_RESET, LABEL_START, LABEL_UPDATE}) {
            this.control.setText(label);
            this.control.pack();
            data.widthHint = Math.max(data.widthHint, this.control.getSize().x);
            data.heightHint = Math.max(data.heightHint, this.control.getSize().y);
        }
        this.control.setText(LABEL_START);
        this.control.setLayoutData((Object)data);
        grid = new GridLayout();
        grid.numColumns = 2;
        Composite com = new Composite((Composite)this.group, 0);
        com.setLayoutData((Object)new GridData(1808));
        com.setLayout((Layout)grid);
        this.description = new Label(com, 0);
        data = new GridData(768);
        data.widthHint = 400;
        this.description.setLayoutData((Object)data);
        Label helpLabel = new Label(com, 4);
        helpLabel.setText("Info");
        helpLabel.setToolTipText(this.plugin.getDescription());
        this.control.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                UpdatePluginUI.this.handlePressedControlButton();
            }
        });
        this.updateView();
    }

    public void asyncSetControlText(final String text) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                UpdatePluginUI.this.control.setText(text);
            }
        });
    }

    public void asyncSetControlEnabled(final boolean enabled) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                UpdatePluginUI.this.control.setEnabled(enabled);
            }
        });
    }

    public void handlePressedControlButton() {
        String tmp;
        this.control.setEnabled(false);
        final String command = tmp = this.control.getText();
        Thread handler = new Thread("Handler for " + this.plugin.getName()){

            @Override
            public void run() {
                int style = 40;
                if (UpdatePluginUI.LABEL_START.equals(command) || UpdatePluginUI.LABEL_UPDATE.equals(command)) {
                    try {
                        UpdatePluginUI.this.plugin.startUpdate();
                        UpdatePluginUI.this.asyncSetControlText(UpdatePluginUI.LABEL_CANCEL);
                    }
                    catch (Exception e) {
                        UpdatePluginUI.this.showMessage(style, e.getMessage());
                    }
                } else if (UpdatePluginUI.LABEL_CANCEL.equals(command)) {
                    log.info("Cancel pressed, trying to abort update...");
                    try {
                        UpdatePluginUI.this.plugin.cancel();
                    }
                    catch (Exception e) {
                        UpdatePluginUI.this.showMessage(style, e.getMessage());
                    }
                } else if (UpdatePluginUI.LABEL_RESET.equals(command)) {
                    try {
                        UpdatePluginUI.this.plugin.reset();
                    }
                    catch (UpdatePluginException e) {
                        UpdatePluginUI.this.showMessage(style, e.getMessage());
                    }
                }
                UpdatePluginUI.this.asyncSetControlEnabled(true);
            }
        };
        handler.start();
    }

    private void showMessage(final int style, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox box = new MessageBox(UpdatePluginUI.this.getShell(), style);
                box.setMessage(message);
                box.open();
            }
        });
    }

    public void updateView() {
        Runnable viewUpdater = new Runnable(){

            @Override
            public void run() {
                String descriptionString = UpdatePluginUI.this.plugin.getTaskDescription();
                String controlString = UpdatePluginUI.LABEL_START;
                switch (UpdatePluginUI.this.plugin.getState()) {
                    case RUNNING: {
                        controlString = UpdatePluginUI.LABEL_CANCEL;
                        break;
                    }
                    case CANCELLED: {
                        Exception e = UpdatePluginUI.this.plugin.getException();
                        if (e != null) {
                            UpdatePluginUI.this.showMessage(1, "An exception occured during update process:\n\nMessage:\n\n" + e.getMessage() + "\n\nPlease refer to logFile '" + PpiToolkit.getLogFilePath() + "' and contact a developer.");
                        }
                    }
                    case DONE: {
                        controlString = UpdatePluginUI.LABEL_RESET;
                        break;
                    }
                    case RESET: {
                        if (!UpdatePluginUI.this.plugin.isUpdateAvailable()) break;
                        descriptionString = descriptionString + " (New updates available)";
                        controlString = UpdatePluginUI.LABEL_UPDATE;
                    }
                }
                UpdatePluginUI.this.currentProgressBar.setSelection((int)(UpdatePluginUI.this.plugin.getTaskProgress() * 1000.0));
                UpdatePluginUI.this.totalProgressBar.setSelection((int)(UpdatePluginUI.this.plugin.getProgress() * 1000.0));
                if (!UpdatePluginUI.this.control.getText().equals(controlString)) {
                    UpdatePluginUI.this.control.setText(controlString);
                }
                if (!UpdatePluginUI.this.description.getText().equals(descriptionString)) {
                    UpdatePluginUI.this.description.setText(descriptionString);
                }
            }
        };
        Display.getDefault().asyncExec(viewUpdater);
    }
}

