/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.client;

import com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource;
import de.berlin.hu.ppi.ClientMain;
import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.PpiToolkit;
import de.berlin.hu.ppi.client.EntryInfo;
import de.berlin.hu.ppi.db.DbService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SettingsUI
extends Window
implements PpiConstants {
    private static final String MESSAGE = "Please enter requested information.\nChecked items will be saved to '" + PpiToolkit.getSettingsFile().getAbsolutePath() + "'.";
    private Map<String, Button> buttonMap = new HashMap<String, Button>();
    private Map<String, Combo> comboMap = new HashMap<String, Combo>();
    private Map<String, Text> textMap = new HashMap<String, Text>();
    private List<EntryInfo> entryInfoList;
    private Composite table;
    private Logger log = Logger.getLogger(SettingsUI.class);
    private Properties oldSettings;
    private Properties settingsToStore;
    private Properties settings;
    private static GridData fillBoth = new GridData(1808);
    private static GridData fillHorizontal = new GridData(768);
    private static GridData center = new GridData(64);
    private static final String TOOLTIP_CONNECT = "Connects to an existing database instance.";
    private static final String TOOLTIP_TEST = "Tests if a connection can be established.";
    private static final String TOOLTIP_ABORT = "Aborts the connection attemp and exits the application.";
    private static final String TOOLTIP_CREATE = "Creates a new empty PiPa-Database";

    public SettingsUI(Properties oldSettings, List<EntryInfo> entryList) {
        this(null, oldSettings, entryList);
    }

    public SettingsUI(Shell parent, Properties oldSettings, List<EntryInfo> entryList) {
        super(parent);
        this.oldSettings = oldSettings;
        this.entryInfoList = new ArrayList<EntryInfo>(entryList.size());
        for (EntryInfo info : entryList) {
            this.entryInfoList.add(info);
        }
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Login:");
    }

    protected String getSettingValue(String key) {
        return this.oldSettings.getProperty(key, "");
    }

    protected void initButton(EntryInfo info) {
        Button button = new Button(this.table, 32);
        this.buttonMap.put(info.key, button);
        button.setText(info.label);
        button.setToolTipText(info.tooltip);
        if (!this.getSettingValue(info.key).isEmpty()) {
            button.setSelection(true);
        }
    }

    @Override
    protected Control createContents(Composite all) {
        GridLayout allLayout = new GridLayout(1, false);
        allLayout.marginHeight = 10;
        allLayout.marginWidth = 10;
        allLayout.marginLeft = 10;
        allLayout.marginRight = 10;
        allLayout.verticalSpacing = 20;
        all.setLayout((Layout)allLayout);
        all.setLayoutData((Object)new GridData(1808));
        Label infoLabel = new Label(all, 2048);
        infoLabel.setText(MESSAGE);
        infoLabel.setLayoutData((Object)GridDataFactory.copyData(fillHorizontal));
        this.table = new Composite(all, 0);
        GridLayout tableLayout = new GridLayout(2, false);
        tableLayout.horizontalSpacing = 15;
        tableLayout.verticalSpacing = 5;
        this.table.setLayout((Layout)tableLayout);
        this.table.setLayoutData((Object)GridDataFactory.copyData(fillBoth));
        for (EntryInfo info : this.entryInfoList) {
            this.initEntry(info);
        }
        Composite south = new Composite(all, 0);
        GridLayout southLayout = new GridLayout(4, false);
        southLayout.horizontalSpacing = 30;
        south.setLayout((Layout)southLayout);
        south.setLayoutData((Object)GridDataFactory.copyData(center));
        Button connectButton = new Button(south, 0);
        connectButton.setText("&Connect");
        connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsUI.this.connect();
            }
        });
        connectButton.setFocus();
        connectButton.setToolTipText(TOOLTIP_CONNECT);
        Button createButton = new Button(south, 0);
        createButton.setText("Create &new");
        createButton.setLayoutData((Object)GridDataFactory.copyData(center));
        createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingsUI.this.createNewDatabase();
            }
        });
        createButton.setToolTipText(TOOLTIP_CREATE);
        Button testButton = new Button(south, 0);
        testButton.setText("&Test Connection");
        testButton.setLayoutData((Object)GridDataFactory.copyData(center));
        testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SettingsUI.this.test();
            }
        });
        testButton.setToolTipText(TOOLTIP_TEST);
        Button quitButton = new Button(south, 0);
        quitButton.setText("&Quit");
        quitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SettingsUI.this.setReturnCode(1);
                SettingsUI.this.close();
            }
        });
        quitButton.setToolTipText(TOOLTIP_ABORT);
        return all;
    }

    private void createNewDatabase() {
        this.readSettings();
        try {
            DbService service = DbService.createNewDbServiceIgnoreDB(this.settings);
            String name = this.settings.getProperty("pipa.database");
            service.createNewDatabase(name);
            service.useDatabase(name);
            service.importSchemaFromRessource("de/berlin/hu/ppi/schema.sql");
            this.showInfo("Database successfully created.");
        }
        catch (Exception e) {
            this.log.error("", e);
            this.showError("Could not create a new database:\n\n" + e.getMessage());
        }
    }

    private void initEntry(EntryInfo entryInfo) {
        this.initButton(entryInfo);
        String initText = this.getSettingValue(entryInfo.key);
        if (initText.isEmpty() && entryInfo.defaults.length > 0) {
            initText = entryInfo.defaults[0];
        }
        Combo control = null;
        Composite c = new Composite(this.table, 0);
        switch (entryInfo.typeI) {
            case 0: 
            case 1: {
                c.setLayout((Layout)new GridLayout(1, false));
                c.setLayoutData((Object)new GridData(768));
                Text text = new Text(c, 2048);
                this.textMap.put(entryInfo.key, text);
                if (entryInfo.typeI == 1) {
                    text.setEchoChar('*');
                }
                text.setText(initText);
                text.setLayoutData((Object)new GridData(768));
                control = text;
                break;
            }
            case 3: {
                c.setLayout((Layout)new GridLayout(2, false));
                Text t = new Text(c, 2048);
                this.textMap.put(entryInfo.key, t);
                t.setText(initText);
                t.setLayoutData((Object)new GridData(768));
                Button openButton = new Button(c, 0);
                openButton.setToolTipText("Opens directory dialog");
                MySelectionAdapter fileSelection = new MySelectionAdapter();
                fileSelection.setText(t);
                openButton.addSelectionListener((SelectionListener)fileSelection);
                openButton.setText("...");
                control = c;
                break;
            }
            case 2: {
                c.setLayout((Layout)new GridLayout(1, false));
                c.setLayoutData((Object)new GridData(768));
                Combo combo = new Combo(c, 0);
                combo.setItems(entryInfo.defaults);
                combo.setText(initText);
                this.comboMap.put(entryInfo.key, combo);
                control = combo;
            }
        }
        control.setLayoutData((Object)GridDataFactory.copyData(fillHorizontal));
        control.setToolTipText(entryInfo.tooltip);
    }

    private void test() {
        this.readSettings();
        if (this.isConnectable()) {
            this.showInfo("Successfully connected to database.");
        }
    }

    private boolean isSelected(String key) {
        return this.buttonMap.get(key).getSelection();
    }

    public void readSettings() {
        Properties settings = new Properties();
        Properties settingsToStore = new Properties();
        for (EntryInfo entryInfo : this.entryInfoList) {
            String value = this.readSetting(entryInfo);
            if (value == null || value.isEmpty()) continue;
            String key = entryInfo.key;
            settings.put(key, value);
            if (!this.isSelected(key)) continue;
            settingsToStore.put(key, value);
        }
        this.settings = settings;
        this.settingsToStore = settingsToStore;
    }

    public Properties getSettings() {
        return this.settings;
    }

    public Properties getSettingsToStore() {
        return this.settingsToStore;
    }

    private String readSetting(EntryInfo currentEntryInfo) {
        String value = "";
        switch (currentEntryInfo.typeI) {
            case 2: {
                Combo combo = this.comboMap.get(currentEntryInfo.key);
                if (combo == null) break;
                value = combo.getText();
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                Text text = this.textMap.get(currentEntryInfo.key);
                if (text == null) break;
                value = text.getText();
            }
        }
        return value;
    }

    public boolean isConnectable() {
        this.readSettings();
        String ppiPath = this.settings.getProperty("pipaPath");
        File ppiDirectory = new File(ppiPath);
        if (!ppiDirectory.exists()) {
            boolean yes = this.askQuestion("The directory '" + ppiDirectory + "' does not exist. Do yout want to create a new one?");
            boolean sucess = false;
            if (yes) {
                sucess = ppiDirectory.mkdirs();
            }
            if (!sucess) {
                return false;
            }
        }
        MysqlConnectionPoolDataSource test = new MysqlConnectionPoolDataSource();
        DbService.initDataSource(test, this.settings);
        try {
            Connection con = test.getConnection();
            try {
                con.createStatement().executeQuery("select * from client_properties limit 0");
                con.createStatement().executeQuery("select * from molecule limit 0");
                con.createStatement().executeQuery("select * from protein_interaction limit 0");
                return true;
            }
            catch (Exception e) {
                this.log.error("", e);
                this.showError("It seems that the given database is not compatible to PiPa. Choose a different one or create a new one.");
                return false;
            }
        }
        catch (Exception e) {
            block11: {
                this.log.error("", e);
                test.setDatabaseName("");
                try {
                    test.getConnection();
                    this.showError("The connection to the database server was successfully established, but the given database '" + this.settings.getProperty("pipa.database") + "' does not exist. You may create a new one.");
                }
                catch (Exception e2) {
                    String message = e2.getMessage();
                    if (message.startsWith("Communications link failure")) {
                        this.showError("Server did not respond within timeout. Please check the server url.");
                        break block11;
                    }
                    if (message.startsWith("Access denied for user")) {
                        this.showError("Could not connect to given database server. Please check your username and/or your password.");
                        break block11;
                    }
                    this.log.error(e2.getMessage());
                    this.showError("Could not connect to given database server. Message: " + message);
                }
            }
            return false;
        }
    }

    private boolean askQuestion(String question) {
        MessageBox messageBox = new MessageBox(this.getShell(), 196);
        messageBox.setMessage(question);
        int yes = messageBox.open();
        return yes == 64;
    }

    private void showError(String message) {
        MessageBox box = new MessageBox(this.getShell(), 1);
        box.setMessage(message);
        box.open();
    }

    private void showInfo(String message) {
        MessageBox box = new MessageBox(this.getShell(), 16);
        box.setMessage(message);
        box.open();
    }

    private void connect() {
        if (this.isConnectable()) {
            this.setReturnCode(0);
            this.close();
        }
    }

    @Override
    protected Layout getLayout() {
        return null;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        SettingsUI ui = ClientMain.openPpiSettingsUI(PpiToolkit.loadSettings(), PpiToolkit.getPiPaProperties());
        int returnCode = ui.open();
        System.out.println(returnCode);
    }

    class MySelectionAdapter
    extends SelectionAdapter {
        Text t;

        MySelectionAdapter() {
        }

        public void setText(Text t) {
            this.t = t;
        }

        public void widgetSelected(SelectionEvent e) {
            DirectoryDialog dialog = new DirectoryDialog(SettingsUI.this.getShell(), 4096);
            dialog.setText("Choose PPI-Data-Path");
            dialog.setFilterPath(this.t.getText());
            dialog.open();
            this.t.setText(dialog.getFilterPath());
        }
    }
}

