/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi.client;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.client.UIToolkit;
import de.berlin.hu.ppi.client.UpdatePluginUI;
import de.berlin.hu.ppi.db.DbService;
import de.berlin.hu.ppi.statistics.Statistics;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePluginException;
import de.berlin.hu.ppi.update.UpdatePluginManager;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class ClientUI
extends Window
implements Runnable,
PpiConstants {
    public static final String NAME = "ProtPathDB Updater";
    private static Logger log = Logger.getLogger(ClientUI.class);
    private Map<UpdatePlugin, UpdatePluginUI> addedPlugins = new HashMap<UpdatePlugin, UpdatePluginUI>();
    private Map<String, Map<String, Text>> sectionNameTextMap = new HashMap<String, Map<String, Text>>();
    private int refreshRate = 10;
    private UpdatePluginManager manager;
    private TabFolder tabFolder;
    private Thread runner;
    private Button computeStatisticsButton;
    private Statistics statistics;
    private Properties properties;

    public ClientUI(Properties properties, Statistics statistics, UpdatePluginManager manager) {
        this(null, properties, statistics, manager);
    }

    public ClientUI(Shell parent, Properties properties, Statistics statistics, UpdatePluginManager manager) {
        super(parent);
        this.properties = new Properties(properties);
        this.statistics = statistics;
        this.manager = manager;
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String name = this.properties.getProperty("ppi.client.name", "ProtPathDB");
        String revision = this.properties.getProperty("ppi.client.revision", "???");
        String version = this.properties.getProperty("ppi.client.version", "?");
        String database = this.properties.getProperty("pipa.database");
        newShell.setText(String.format("%s\t%s\t (Rev %s) connected to '%s'", name, version, revision, database));
        UIToolkit.centerShell(newShell);
    }

    @Override
    protected Layout getLayout() {
        return new FillLayout();
    }

    @Override
    protected Control createContents(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        this.initializeUpdateTab();
        this.initializeStatisitcsTab();
        this.getShell().pack();
        UIToolkit.centerShell(this.getShell());
        return null;
    }

    private void initializeUpdateTab() {
        TabItem updateItem = new TabItem(this.tabFolder, 0);
        updateItem.setText("Updates");
        TabFolder folder = new TabFolder((Composite)this.tabFolder, 0);
        updateItem.setControl((Control)folder);
        this.initializeUpdatePluginComposite(UpdatePlugin.UpdateType.INTERACTION_DATA, folder);
        this.initializeUpdatePluginComposite(UpdatePlugin.UpdateType.PATHWAY_DATA, folder);
        this.initializeUpdatePluginComposite(UpdatePlugin.UpdateType.META_DATA, folder);
        this.initializeUpdatePluginComposite(UpdatePlugin.UpdateType.LOOKUP_TABLES, folder);
    }

    public void initializeUpdatePluginComposite(UpdatePlugin.UpdateType type, TabFolder tabFolder) {
        ScrolledComposite output = new ScrolledComposite((Composite)tabFolder, 512);
        output.setExpandHorizontal(true);
        output.setExpandVertical(true);
        Composite content = new Composite((Composite)output, 0);
        output.setContent((Control)content);
        content.setLayout((Layout)new GridLayout(1, true));
        List<UpdatePlugin> plugins = this.manager.getUpdatePluginsByType().get((Object)type);
        if (plugins != null) {
            for (UpdatePlugin plugin : plugins) {
                UpdatePluginUI ui = new UpdatePluginUI(content, 0, plugin);
                this.addedPlugins.put(plugin, ui);
                ui.setLayoutData(new GridData(768));
            }
        }
        TabItem tab = new TabItem(tabFolder, 0);
        tab.setText(type.toString());
        tab.setControl((Control)output);
        content.pack();
        output.setMinHeight(content.getSize().y);
    }

    public void initializeStatisitcsTab() {
        Composite output = new Composite((Composite)this.tabFolder, 0);
        GridLayout layout = new GridLayout(1, true);
        output.setLayout((Layout)layout);
        TabFolder statisticsTabFolder = new TabFolder(output, 0);
        statisticsTabFolder.setLayoutData((Object)new GridData(1808));
        for (String section : this.statistics.getSections()) {
            TabItem sectionItem = new TabItem(statisticsTabFolder, 0);
            sectionItem.setText(section);
            Composite content = new Composite((Composite)statisticsTabFolder, 0);
            GridLayout contentGridLayout = new GridLayout(3, true);
            contentGridLayout.makeColumnsEqualWidth = false;
            content.setLayout((Layout)contentGridLayout);
            sectionItem.setControl((Control)content);
            for (String subsection : this.statistics.getSubsections(section)) {
                Label label = new Label(content, 0);
                label.setText(subsection + ":");
                GridData data = new GridData();
                data.widthHint = 300;
                label.setLayoutData((Object)data);
                Text text = new Text(content, 133128);
                if (this.sectionNameTextMap.get(section) == null) {
                    this.sectionNameTextMap.put(section, new HashMap());
                }
                this.sectionNameTextMap.get(section).put(subsection, text);
                data = new GridData(768);
                data.widthHint = 100;
                text.setLayoutData((Object)data);
                Label info = new Label(content, 0x1000000);
                info.setText("Info");
                String infoString = this.statistics.getInfo(section, subsection);
                info.setToolTipText(infoString);
                data = new GridData();
                data.widthHint = 50;
                info.setLayoutData((Object)data);
            }
        }
        try {
            DbService.getCurrentService().getStaticConnection().close();
        }
        catch (Exception e) {
            log.error("", e);
        }
        TabItem item = new TabItem(this.tabFolder, 0);
        item.setText("Statistics");
        item.setControl((Control)output);
        this.computeStatisticsButton = new Button(output, 0);
        this.computeStatisticsButton.setLayoutData((Object)new GridData(128));
        this.computeStatisticsButton.setText("Compute");
        this.computeStatisticsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Runnable resultComputer = new Runnable(){

                    @Override
                    public void run() {
                        ClientUI.this.computeResults();
                    }
                };
                new Thread(resultComputer, "ResultComputer").start();
            }
        });
    }

    public void computeResults() {
        for (final String section : this.sectionNameTextMap.keySet()) {
            for (final String name : this.sectionNameTextMap.get(section).keySet()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((Text)((Map)ClientUI.this.sectionNameTextMap.get(section)).get(name)).setText("computing...");
                    }
                });
            }
        }
        for (final String section : this.sectionNameTextMap.keySet()) {
            for (final String subsection : this.sectionNameTextMap.get(section).keySet()) {
                Runnable textUpdater = new Runnable(){

                    @Override
                    public void run() {
                        String result = ClientUI.this.statistics.getResult(section, subsection);
                        try {
                            double value = Double.parseDouble(result);
                            NumberFormat format = NumberFormat.getInstance();
                            format.setMaximumFractionDigits(2);
                            format.setMinimumFractionDigits(2);
                            result = format.format(value);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ((Text)((Map)ClientUI.this.sectionNameTextMap.get(section)).get(subsection)).setText(result);
                    }
                };
                Display.getDefault().asyncExec(textUpdater);
            }
        }
    }

    public void start() {
        this.create();
        if (this.runner == null || !this.runner.isAlive()) {
            this.runner = new Thread(this);
            this.runner.start();
        }
        this.setBlockOnOpen(true);
        this.open();
        this.stop();
    }

    public void stop() {
        this.runner.interrupt();
        for (UpdatePlugin plugin : this.addedPlugins.keySet()) {
            switch (plugin.getState()) {
                case RUNNING: {
                    try {
                        plugin.cancel();
                        break;
                    }
                    catch (UpdatePluginException e) {
                        log.error("", e);
                    }
                }
            }
        }
    }

    public void setRefreshRate(int rate) {
        this.refreshRate = rate;
    }

    @Override
    public void run() {
        try {
            while (!this.runner.isInterrupted()) {
                Thread.sleep(this.refreshRate);
                for (UpdatePlugin plugin : this.addedPlugins.keySet()) {
                    UpdatePluginUI control = this.addedPlugins.get(plugin);
                    if (control.isDisposed()) continue;
                    control.updateView();
                    Thread.sleep(this.refreshRate);
                }
            }
        }
        catch (InterruptedException e) {
            this.runner.interrupt();
        }
    }
}

