/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.PpiToolkit;
import de.berlin.hu.ppi.wrapper.MultipleWrapper;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import de.berlin.hu.ppi.wrapper.StaxWrapper;
import de.berlin.hu.ppi.wrapper.ZipInteractionIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class SourceFactory
implements PpiConstants {
    public static Logger log = Logger.getLogger(SourceFactory.class);

    public static Iterable<ProteinInteraction> getPpiWrapper(File file) {
        return new StaxWrapper(file);
    }

    public static Iterable<ProteinInteraction> getPpiWrapper(String pathToSourceFile) {
        File sourceFile = new File(pathToSourceFile);
        if (sourceFile.exists() && !sourceFile.isDirectory()) {
            return SourceFactory.getPpiWrapper(sourceFile);
        }
        return null;
    }

    public static Iterable<ProteinInteraction> getPpiWrapperGZip(File file) {
        try {
            GZIPInputStream input = new GZIPInputStream(new FileInputStream(file));
            return new StaxWrapper(input, file.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            log.error("", e);
        }
        catch (IOException e) {
            log.error("", e);
        }
        return null;
    }

    public static Iterable<ProteinInteraction> getPpiWrapperZip(String pathToSourceZipFile) {
        try {
            ZipFile sourceFile = new ZipFile(pathToSourceZipFile);
            return SourceFactory.getPpiWrapper(sourceFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Iterable<ProteinInteraction> getPpiWrapper(ZipFile zipFile) {
        if (zipFile == null) {
            log.warn(SourceFactory.class.getSimpleName() + ".getPpiWrapper(ZipFile zipFile): zipFile was null.");
            return null;
        }
        if (zipFile.size() < 1) {
            log.warn(SourceFactory.class.getSimpleName() + ".getPpiWrapper(ZipFile zipFile): zipFile " + zipFile.getName() + "contains no files to parse.");
            return null;
        }
        return new MultipleWrapper(new ZipInteractionIterator(zipFile));
    }

    public static Iterable<ProteinInteraction> getPpiWrapper(Collection<File> sources) {
        if (sources == null || sources.size() == 0) {
            log.warn(SourceFactory.class.getSimpleName() + ".getPpiWrapper(Collection<File> sources): Collection was null or empty. Returned null.");
            return null;
        }
        ArrayList<Iterable<ProteinInteraction>> sourcesToWrap = new ArrayList<Iterable<ProteinInteraction>>(sources.size());
        for (File file : sources) {
            if (PpiToolkit.hasValidName(file)) {
                if (file.getName().endsWith("zip")) {
                    try {
                        sourcesToWrap.add(SourceFactory.getPpiWrapper(new ZipFile(file)));
                    }
                    catch (ZipException e) {
                        log.error(SourceFactory.class.getSimpleName() + ".getPpiWrapper(Collection<File> sources): File " + file.getAbsolutePath() + "was no zip-file.", e);
                    }
                    catch (IOException e) {
                        log.error(SourceFactory.class.getSimpleName() + ".getPpiWrapper(Collection<File> sources): File " + file.getAbsolutePath() + "was no zip-file.", e);
                    }
                    continue;
                }
                sourcesToWrap.add(SourceFactory.getPpiWrapper(file));
                continue;
            }
            log.info(SourceFactory.class.getSimpleName() + ".getPpiWrapper(Collection<File> sources): Datei ignoriert: " + file);
        }
        return new MultipleWrapper(sourcesToWrap);
    }

    public static Iterable<ProteinInteraction> getInteractionSourceById(PpiConstants.DB_ID dbId) {
        if (PpiConstants.DB_ID.getPPISourceIds().contains((Object)dbId)) {
            return SourceFactory.getPpiWrapper(PpiToolkit.getInteractionSourceFiles(dbId));
        }
        IllegalArgumentException exception = new IllegalArgumentException("Delivered id was out of range. Returned null.");
        log.warn(SourceFactory.class.getSimpleName() + ".getDatabaseSourceById(id): ", exception);
        return null;
    }

    public static Iterable<ProteinInteraction> getAllInteractionSources() {
        HashSet<Iterable<ProteinInteraction>> all = new HashSet<Iterable<ProteinInteraction>>(10);
        for (PpiConstants.DB_ID dbId : PpiToolkit.getSourceIds()) {
            log.info("Adding Parser for " + PpiToolkit.getInteractionSourceName(dbId));
            all.add(SourceFactory.getInteractionSourceById(dbId));
        }
        return new MultipleWrapper(all.iterator());
    }

    static {
        log.addAppender(new ConsoleAppender(new SimpleLayout()));
        log.setLevel(Level.OFF);
    }
}

