/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.SourceFactory;
import de.berlin.hu.ppi.tool.TextDeformer;
import de.berlin.hu.ppi.wrapper.Experiment;
import de.berlin.hu.ppi.wrapper.Protein;
import de.berlin.hu.ppi.wrapper.ProteinInteraction;
import de.berlin.hu.wbi.common.misc.ClasspathModifier;
import de.berlin.hu.wbi.common.misc.SwtToolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class PpiToolkit
implements PpiConstants {
    private static final int COPY_BUFFER_SIZE = 4095;
    private static Logger log = Logger.getLogger(PpiToolkit.class);
    private static Properties piPaProperties;
    private static int[] additionalTaxIds;
    private static File dotFolder;
    public static double printInteractionInformationThreshold;
    private static File tmpDir;

    public static void overwriteProperties(Properties properties) {
        if (properties != null) {
            for (String key : properties.stringPropertyNames()) {
                piPaProperties.setProperty(key, properties.getProperty(key));
            }
        }
    }

    public static void addProperties(Properties properties) {
        if (properties != null) {
            for (String key : properties.stringPropertyNames()) {
                if (piPaProperties.getProperty(key) != null) continue;
                piPaProperties.setProperty(key, properties.getProperty(key));
            }
        }
    }

    public static boolean deleteTmpFilesOnExit() {
        return "true".equals(piPaProperties.getProperty("ppi.deleteTempFilesOnExit"));
    }

    public static void storePpiProperties(File propertiesFile) {
        try {
            piPaProperties.store(new FileOutputStream(propertiesFile), "");
            PpiToolkit.orderText(propertiesFile);
            log.info("PpiProperties stored");
        }
        catch (FileNotFoundException e) {
            log.error("", e);
        }
        catch (IOException e) {
            log.error("", e);
        }
    }

    public static void orderText(File propertiesFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(propertiesFile));
        ArrayList<String> lines = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            lines.add(line);
            line = reader.readLine();
        }
        Collections.sort(lines);
        reader.close();
        BufferedWriter writer = new BufferedWriter(new FileWriter(propertiesFile));
        for (String newLine : lines) {
            writer.write(newLine);
            writer.newLine();
        }
        writer.flush();
        writer.close();
    }

    public static void importRelevantTaxIds() {
        String taxIdProperty = piPaProperties.getProperty("ppi.additionalTaxIds");
        if (taxIdProperty != null && !taxIdProperty.isEmpty()) {
            String[] taxIds = taxIdProperty.split("[|]");
            additionalTaxIds = new int[taxIds.length];
            for (int i = 0; i < taxIds.length; ++i) {
                PpiToolkit.additionalTaxIds[i] = Integer.parseInt(taxIds[i]);
            }
        }
    }

    public static String cleanDatabaseName(String dbName) {
        if (!("uniprotkb".equals(dbName = dbName.toLowerCase()) || "afcs".equals(dbName) || "bind".equals(dbName) || "cabri".equals(dbName) || "camjedb".equals(dbName) || "cdna accession".equals(dbName) || "cdna gi".equals(dbName) || "cgnc".equals(dbName) || "chebi".equals(dbName) || "cygd".equals(dbName) || "dip".equals(dbName) || "ddbj-embl-genbank".equals(dbName) || "ddbj/embl/genbank".equals(dbName) || "ecogene".equals(dbName) || "ecocyc".equals(dbName) || "encode".equals(dbName) || "ensembl".equals(dbName) || "entrez gene/locuslink".equals(dbName) || "entrez protein".equals(dbName) || "entrez nucleotide".equals(dbName) || "entrezgene".equals(dbName) || "flybase".equals(dbName) || "genbank_protein_gi".equals(dbName) || "genbank_nucleotide_g".equals(dbName) || "genedb".equals(dbName) || "go".equals(dbName) || "grid".equals(dbName) || "grid_legacy".equals(dbName) || "hgnc".equals(dbName) || "hprd".equals(dbName) || "huge".equals(dbName) || "imgt/gene-db".equals(dbName) || "intact".equals(dbName) || "interpro".equals(dbName) || "ipi".equals(dbName) || "mgd/mgi".equals(dbName) || "mgi".equals(dbName) || "mim".equals(dbName) || "mint".equals(dbName) || "n/a".equals(dbName) || "newt".equals(dbName) || "nucleotide genbank identifier".equals(dbName) || "omim".equals(dbName) || "pdb".equals(dbName) || "pir".equals(dbName) || "protein".equals(dbName) || "protein accession".equals(dbName) || "protein genbank identifier".equals(dbName) || "protein gi".equals(dbName) || "psi-mi".equals(dbName) || "pubmed".equals(dbName) || "ratmap".equals(dbName) || "reactome".equals(dbName) || "reactome protein".equals(dbName) || "rcsb pdb".equals(dbName) || "refseq".equals(dbName) || "rgd".equals(dbName) || "sgd".equals(dbName) || "so".equals(dbName) || "tair".equals(dbName) || "uniparc".equals(dbName) || "wormbase".equals(dbName) || "zfin".equals(dbName))) {
            if ("uniprot knowledge base".equals(dbName) || "uniprot".equals(dbName) || "sp".equals(dbName) || "trembl".equals(dbName)) {
                dbName = "uniprotkb";
            } else if ("omim".equals(dbName)) {
                dbName = "mim";
            } else if ("gb".equals(dbName)) {
                dbName = "genebank";
            } else if ("entrez gene/locuslink".equals(dbName)) {
                dbName = "entrezgene";
            }
        }
        return dbName;
    }

    public static EnumSet<PpiConstants.DB_ID> getSourceIds() {
        return PpiConstants.DB_ID.getPPISourceIds();
    }

    public static File createDotFolder(String name) {
        String path = System.getProperty("user.home") + File.separatorChar + name;
        File dotFolder = new File(path);
        if (!dotFolder.exists()) {
            dotFolder.mkdirs();
        }
        return dotFolder;
    }

    public static File getDotFolder() {
        if (dotFolder == null) {
            dotFolder = PpiToolkit.createDotFolder(".pipa");
            dotFolder.mkdirs();
        }
        return dotFolder;
    }

    public static File getSettingsFile() {
        String path = PpiToolkit.getDotFolder().getAbsolutePath() + File.separatorChar + "settings";
        File settingsFile = new File(path);
        if (!settingsFile.exists()) {
            try {
                settingsFile.createNewFile();
            }
            catch (IOException e) {
                log.error("", e);
            }
        }
        return settingsFile;
    }

    public static Collection<File> getAllFiles(File rootDir) {
        ArrayList<File> file = new ArrayList<File>(20);
        PpiToolkit.searchFiles(file, rootDir);
        return file;
    }

    public static Collection<File> getAllFiles(String path) {
        File root = new File(path);
        return PpiToolkit.getAllFiles(root);
    }

    public static Collection<File> getInteractionSourceFiles(PpiConstants.DB_ID dbId) {
        String directoy = "";
        switch (dbId) {
            case BIND: {
                directoy = "bind/";
                break;
            }
            case BIOGRID: {
                directoy = "biogrid/";
                break;
            }
            case DIP: {
                directoy = "dip/";
                break;
            }
            case HPRD: {
                directoy = "hprd/";
                break;
            }
            case INTACT: {
                directoy = "intact/";
                break;
            }
            case INTACT_DISEASE: {
                directoy = "intact_disease/";
                break;
            }
            case MINT: {
                directoy = "mint/";
                break;
            }
            case MIPS: {
                directoy = "mips/";
            }
        }
        return PpiToolkit.getAllFiles(PpiToolkit.getPpiDataPath() + directoy);
    }

    public static String getInteractionSourceName(PpiConstants.DB_ID dbId) {
        if (PpiConstants.DB_ID.getPPISourceIds().contains((Object)dbId)) {
            return PpiConstants.DB_ID.BIND.toString();
        }
        log.warn(PpiToolkit.class.getSimpleName() + ".resolveName(int id): ", new IllegalArgumentException("Delivered database id is unknown."));
        return null;
    }

    public static Properties getPiPaProperties() {
        return piPaProperties;
    }

    public static boolean hasValidName(File file) {
        return PpiToolkit.isValidFileName(file.getAbsolutePath());
    }

    public static boolean isRelevantTaxId(int id) {
        switch (id) {
            case 4932: 
            case 6239: 
            case 7227: 
            case 9606: 
            case 10090: 
            case 10116: {
                return true;
            }
        }
        if (additionalTaxIds != null) {
            for (int taxId : additionalTaxIds) {
                if (taxId != id) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRelevantTaxId(String id) {
        return id == null ? false : PpiToolkit.isRelevantTaxId(Integer.parseInt(id));
    }

    public static int countInteractions(PpiConstants.DB_ID dbId) {
        int count = 0;
        Iterator<ProteinInteraction> i = SourceFactory.getInteractionSourceById(dbId).iterator();
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidFileName(String fileName) {
        String includeRegEx = piPaProperties.getProperty("ppi.includeFileRegEx");
        String excludeRegEx = piPaProperties.getProperty("ppi.excludeFileRegEx");
        if (fileName.matches(includeRegEx)) {
            if (!fileName.matches(excludeRegEx)) return true;
            log.info("Skipping excluded file: " + fileName);
            return false;
        } else {
            log.info("Skipping invalid file: " + fileName);
        }
        return false;
    }

    public static boolean isValidSourceId(PpiConstants.DB_ID dbId) {
        return PpiConstants.DB_ID.getPPISourceIds().contains((Object)dbId);
    }

    public static boolean isCachingEnabled() {
        return "true".equals(piPaProperties.get("ppi.enableCaching"));
    }

    public static void printInteractionInfo(ProteinInteraction interaction) {
        PpiToolkit.printInteractionInfo(interaction, System.out);
    }

    public static void printInteractionInfo(ProteinInteraction interaction, PrintStream out) {
        if (out != null && interaction != null) {
            out.println("\nNew Interaction:");
            out.println("Interaction Type:\t" + interaction.getInteractionType());
            out.println("Complex:         \t" + interaction.isComplex());
            out.println("Predicted:       \t" + interaction.isPredicted());
            out.println("Disease:         \t" + interaction.isDisease());
            for (Protein p : interaction.getInteractors()) {
                out.println("\tProtein:");
                Map<String, String> map = p.getAllIds();
                if (map == null) continue;
                for (String key : map.keySet()) {
                    out.println("\t\t" + key + ":\t" + map.get(key));
                }
            }
            for (Experiment experiment : interaction.getExperiments()) {
                out.println("\tExperiment:");
                out.println("\t\tPubMedId: " + experiment.getPubmedIds().get(0));
                out.println("\t\tDetectionMethod: " + experiment.getDetectionMethod());
            }
        } else {
            log.error(PpiToolkit.class.getSimpleName() + ".printInteractionInfo(ProteinInteraction interaction, PrintStream out): " + "None of the parameters must be null.", new NullPointerException());
        }
    }

    public static void printRandomInteractions(Iterable<ProteinInteraction> interactions, PrintStream out) {
        for (ProteinInteraction interaction : interactions) {
            if (!(Math.random() < printInteractionInformationThreshold)) continue;
            PpiToolkit.printInteractionInfo(interaction, out);
        }
    }

    public static void searchFiles(Collection<File> fileList, File file) {
        if (file.isFile()) {
            fileList.add(file);
        } else if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                PpiToolkit.searchFiles(fileList, child);
            }
        }
    }

    public static int test(PpiConstants.DB_ID dbId) {
        int countInteractions = 0;
        Iterable<ProteinInteraction> source = SourceFactory.getInteractionSourceById(dbId);
        System.out.println("\n" + PpiToolkit.getInteractionSourceName(dbId) + ":");
        for (ProteinInteraction interaction : source) {
            ++countInteractions;
            if (!(Math.random() < printInteractionInformationThreshold)) continue;
            PpiToolkit.printInteractionInfo(interaction);
        }
        return countInteractions;
    }

    public static void testAll() {
        int sumCount = 0;
        int currentCount = 0;
        for (PpiConstants.DB_ID dbId : PpiToolkit.getSourceIds()) {
            System.out.println("\n" + PpiToolkit.getInteractionSourceName(dbId) + ":");
            currentCount = PpiToolkit.test(dbId);
            sumCount += currentCount;
            System.out.println(PpiToolkit.getInteractionSourceName(dbId) + ": " + currentCount + " Interactions.");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Found: " + sumCount);
    }

    public static int countInteractions(Iterable<ProteinInteraction> interactions, PrintStream out) {
        int count = 0;
        for (ProteinInteraction i : interactions) {
            for (Protein protein : i.getInteractors()) {
                protein.getAllIds();
            }
            if (++count % 1000 != 0) continue;
            out.println("Found so far: " + count);
        }
        if (out != null) {
            out.println("Found totally: " + count);
        }
        return count;
    }

    public static String[] getDistinctInteractionTypes(Iterable<ProteinInteraction> interactions, PrintStream out) {
        HashSet<String> methods = new HashSet<String>(1000);
        for (ProteinInteraction interaction : interactions) {
            String method = interaction.getInteractionType();
            if (methods.contains(method)) continue;
            if (out != null) {
                out.println(method);
            }
            methods.add(method);
        }
        return methods.toArray(new String[methods.size()]);
    }

    public static String[] getDistinctDetectionMethods(Iterable<ProteinInteraction> interactions, PrintStream out) {
        HashSet<String> methods = new HashSet<String>(1000);
        for (ProteinInteraction interaction : interactions) {
            for (Experiment experiment : interaction.getExperiments()) {
                String method = experiment.getDetectionMethod();
                if (methods.contains(method)) continue;
                if (out != null) {
                    out.println(method);
                }
                methods.add(method);
            }
        }
        return methods.toArray(new String[methods.size()]);
    }

    public static String convertPackageToPath(Object o) {
        return PpiToolkit.convertPackageToPath(o.getClass());
    }

    public static String convertPackageToPath(Class<?> c) {
        return c.getPackage().getName().replace('.', '/').concat("/");
    }

    public static String getLogFilePath() {
        return PpiToolkit.getDotFolder().getAbsolutePath() + File.separatorChar + "logFile.log";
    }

    public static String getPpiDataPath() {
        return piPaProperties.getProperty("ppi.ppiDataPath");
    }

    public static void storeSettings(Properties settings) {
        if ((settings = (Properties)settings.clone()) != null) {
            try {
                String password = settings.getProperty("pipa.password");
                if (password != null) {
                    password = TextDeformer.encode(password);
                    settings.put("pipa.password", password);
                }
                settings.store(new FileOutputStream(PpiToolkit.getSettingsFile()), "This file stores settings used for database connection.");
            }
            catch (FileNotFoundException e) {
                log.error("", e);
            }
            catch (IOException e) {
                log.error("", e);
            }
        }
    }

    public static Properties loadSettings() {
        Properties storedSettings = new Properties();
        try {
            storedSettings.load(new FileReader(PpiToolkit.getSettingsFile().getAbsolutePath()));
            String decryptedPassword = TextDeformer.decode(storedSettings.getProperty("pipa.password"));
            storedSettings.setProperty("pipa.password", decryptedPassword);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return storedSettings;
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        byte[] buf = new byte[bufferSize];
        int length = in.read(buf);
        while (length != -1) {
            out.write(buf, 0, length);
            length = in.read(buf);
        }
        in.close();
        out.flush();
        out.close();
    }

    public static File extractRessource(String ressource, String fileName) throws IOException {
        InputStream in = ClassLoader.getSystemResourceAsStream(ressource);
        File extractedFile = new File(fileName);
        if (!extractedFile.exists()) {
            extractedFile.createNewFile();
            FileOutputStream out = new FileOutputStream(extractedFile);
            PpiToolkit.copy(in, out, 4095);
        }
        return extractedFile;
    }

    public static String getDefaultTemporaryDirectoryPath() {
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        String userName = System.getProperty("user.name");
        return tmpDirPath + File.separatorChar + userName;
    }

    public static File getTempDirectory() {
        if (tmpDir == null || !tmpDir.exists()) {
            String path = piPaProperties.getProperty("pipa.tmpDir");
            if (path == null) {
                path = PpiToolkit.getDefaultTemporaryDirectoryPath();
            }
            if (!(tmpDir = new File(path)).exists() && !tmpDir.mkdirs()) {
                log.error("Cannot create file " + tmpDir.getAbsolutePath());
            }
        }
        return tmpDir;
    }

    public static String getTempDirectoryPath() {
        return PpiToolkit.getTempDirectory().getAbsolutePath();
    }

    public static void setupEnvironment() throws IOException {
        File extracetedFile = PpiToolkit.extractRessource("de/berlin/hu/ppi/ppi.properties", PpiToolkit.getDotFolder() + File.separator + "pipa.properties");
        piPaProperties = new Properties();
        piPaProperties.load(new FileInputStream(extracetedFile));
        Properties piPaProperties = PpiToolkit.getPiPaProperties();
        piPaProperties.load(ClassLoader.getSystemResourceAsStream("de/berlin/hu/ppi/ppi.properties"));
        String appenderFile = PpiToolkit.getDotFolder().getAbsolutePath() + File.separator + "pipa.log";
        piPaProperties.setProperty("log4j.appender.File.file", appenderFile);
        PropertyConfigurator.configure(piPaProperties);
        File swtJarFile = new File(PpiToolkit.getDotFolder(), "swt.jar");
        SwtToolkit swt = new SwtToolkit();
        ClasspathModifier.addFile(swtJarFile);
        File searchDir = new File(".").getCanonicalFile();
        if (swtJarFile.exists()) {
            if (!swt.isSwtLoaded()) {
                swtJarFile.delete();
                swt.loadSwtJar(searchDir, swtJarFile);
            }
        } else {
            swt.loadSwtJar(searchDir, swtJarFile);
        }
    }

    static {
        printInteractionInformationThreshold = 0.0;
    }
}

