/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi;

import java.util.EnumSet;

public interface PpiConstants {
    public static final int TAX_ID_YEAST = 4932;
    public static final int TAX_ID_CAEEL = 6239;
    public static final int TAX_ID_DROME = 7227;
    public static final int TAX_ID_HUMAN = 9606;
    public static final int TAX_ID_MOUSE = 10090;
    public static final int TAX_ID_RAT = 10116;
    public static final String YEAST = "yeast";
    public static final String CAEEL = "caeel";
    public static final String DROME = "drome";
    public static final String HUMAN = "human";
    public static final String MOUSE = "mouse";
    public static final String RAT = "rat";
    public static final String PROTEIN = "protein";
    public static final String BIND_DIR = "bind/";
    public static final String BIOGRID_DIR = "biogrid/";
    public static final String DIP_DIR = "dip/";
    public static final String HPRD_DIR = "hprd/";
    public static final String INTACT_DIR = "intact/";
    public static final String INTACT_DISEASE_DIR = "intact_disease/";
    public static final String MINT_DIR = "mint/";
    public static final String MIPS_DIR = "mips/";
    public static final String KEY_ADDITIONAL_TAX_IDS = "ppi.additionalTaxIds";
    public static final String KEY_CLIENT_NAME = "ppi.client.name";
    public static final String KEY_DATABASE = "pipa.database";
    public static final String KEY_DRIVER = "driver";
    public static final String KEY_ENABLE_CACHING = "ppi.enableCaching";
    public static final String KEY_EXCLUDE_FILE_REG_EX = "ppi.excludeFileRegEx";
    public static final String KEY_INCLUDE_FILE_REG_EX = "ppi.includeFileRegEx";
    public static final String KEY_PASSWORD = "pipa.password";
    public static final String KEY_DIP_PATH = "pipaPath";
    public static final String KEY_PPI_DATA_PATH = "ppi.ppiDataPath";
    public static final String KEY_PPI_USERS = "ppi.users";
    public static final String KEY_PPI_SERVERS = "ppi.servers";
    public static final String KEY_LOG4J_APPENDER_FILE = "log4j.appender.File.file";
    public static final String KEY_REVISION = "ppi.client.revision";
    public static final String KEY_SERVER = "pipa.server";
    public static final String KEY_TMP_DIR = "pipa.tmpDir";
    public static final String KEY_USERNAME = "pipa.username";
    public static final String KEY_VERSION = "ppi.client.version";
    public static final String KEY_DELETE_TEMP_FILES_ON_EXIT = "ppi.deleteTempFilesOnExit";
    public static final String KEY_LOADER_THREAD_COUNT = "ppi.loaderThreadCount";
    public static final String NAME_LOG_FILE = "logFile.log";
    public static final String NAME_PIPA_PROPERTIES = "pipa.properties";
    public static final String NAME_PIPA_DOT_FOLDER = ".pipa";
    public static final String NAME_SETTINGS_FILE = "settings";
    public static final String DEFAULT_PPI_DATA_PATH = "/vol/home-vol3/wbi/wbi_stud/ppi_data/";
    public static final String DEFAULT_DATABASE_PPI = "ppi";
    public static final String DEFAULT_DATABASE_PROTPATH_TEST = "protpath_";
    public static final String DEFAULT_DATABASE_PROTPATH = "protpath";
    public static final String DEFAULT_SERVER = "racer.informatik.hu-berlin.de";
    public static final String RESSOURCE_SCHEMA_FILE = "de/berlin/hu/ppi/schema.sql";
    public static final String RESSOURCE_PREFIX = "de/berlin/hu/ppi";
    public static final String RESSOURCE_STATISICS_CONF = "de/berlin/hu/ppi/statistics.conf";
    public static final String RESSOURCE_QUERIES_PROPERTIES = "de/berlin/hu/ppi/queries.properties";
    public static final String RESSOURCE_PLUGINS_CONF = "de/berlin/hu/ppi/plugins.conf";
    public static final String RESSOURCE_PPI_PROPERTIES = "de/berlin/hu/ppi/ppi.properties";

    public static enum MOLECULE_TYPE {
        COMPLEX,
        COMPOUND,
        DNA,
        GENE,
        GROUP,
        ORTHOLOG,
        PHYSICALENTITY,
        PROTEIN,
        RNA,
        SMALLMOLECULE,
        REPRESENTATIVEMOLECULE,
        UNDEFINED;

    }

    public static enum DB_ID {
        BIND,
        BIOGRID,
        DIP,
        HPRD,
        INTACT,
        MINT,
        MIPS,
        INTACT_DISEASE,
        BIOCYC,
        INOH,
        KEGG,
        PATHWAY_COMMONS_BIOGRID,
        PATHWAY_COMMONS_CANCERCELLMAP,
        PATHWAY_COMMONS_HPRD,
        PATHWAY_COMMONS_IMID,
        PATHWAY_COMMONS_INTACT,
        PATHWAY_COMMONS_MINT,
        PATHWAY_INTERACTION_DATABASE_BIOCARTA,
        PATHWAY_INTERACTION_DATABASE_NCI,
        PATHWAY_INTERACTION_DATABASE_REACTOME,
        REACTOME,
        SPIKE,
        UNIPROT,
        MGI,
        WormBase,
        RGD,
        FlyBase,
        SGD,
        GoaHuman,
        GoaUniProt;


        public static EnumSet<DB_ID> getPPISourceIds() {
            return EnumSet.range(BIND, INTACT_DISEASE);
        }

        public static EnumSet<DB_ID> getPathwayCommonsDbs() {
            return EnumSet.range(PATHWAY_COMMONS_BIOGRID, PATHWAY_COMMONS_MINT);
        }

        public static EnumSet<DB_ID> getPathwayInteractionDatabaseDbs() {
            return EnumSet.range(PATHWAY_INTERACTION_DATABASE_BIOCARTA, PATHWAY_INTERACTION_DATABASE_REACTOME);
        }
    }
}

