/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi;

import de.berlin.hu.ppi.wrapper.StaxWrapper;
import java.io.InputStream;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamReader;

public class InteractionCounter
implements XMLStreamConstants {
    int interactionCount = 0;
    XMLStreamReader reader;

    public InteractionCounter(InputStream stream) {
        this.reader = StaxWrapper.getParser(stream);
        this.count();
    }

    private void count() {
        try {
            while (this.reader.hasNext()) {
                if ("interaction".equals(this.reader.getLocalName()) && this.reader.getEventType() == 1) {
                    int proteinCount = 0;
                    while (this.reader.hasNext()) {
                        if (("proteinInteractor".equals(this.reader.getLocalName()) || "participant".equals(this.reader.getLocalName())) && this.reader.getEventType() == 1) {
                            ++proteinCount;
                        } else if ("interaction".equals(this.reader.getLocalName()) && this.reader.getEventType() == 2) break;
                        this.reader.next();
                    }
                    if (proteinCount > 1) {
                        ++this.interactionCount;
                    }
                }
                this.reader.next();
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public int getInteractionCount() {
        return this.interactionCount;
    }
}

