/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.ppi;

import de.berlin.hu.ppi.PpiConstants;
import de.berlin.hu.ppi.PpiToolkit;
import de.berlin.hu.ppi.client.ClientUI;
import de.berlin.hu.ppi.client.EntryInfo;
import de.berlin.hu.ppi.client.SettingsUI;
import de.berlin.hu.ppi.db.DbService;
import de.berlin.hu.ppi.statistics.StatisticsNew;
import de.berlin.hu.ppi.update.LockingManager;
import de.berlin.hu.ppi.update.UpdatePlugin;
import de.berlin.hu.ppi.update.UpdatePluginException;
import de.berlin.hu.ppi.update.UpdatePluginManager;
import de.berlin.hu.ppi.update.plugin.HprdUpdatePlugin;
import de.berlin.hu.ppi.update.plugin.IntActDiseaseUpdatePlugin;
import de.berlin.hu.ppi.update.plugin.IntActUpdatePlugin;
import de.berlin.hu.ppi.update.plugin.MintUpdatePlugin;
import de.berlin.hu.ppi.update.plugin.MipsUpdatePlugin;
import de.berlin.hu.wbi.common.misc.SystemProperties;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClientMain
implements PpiConstants {
    private static Logger log = Logger.getLogger(ClientMain.class);
    private static boolean isBatchMode = false;
    private static final Class<?>[] classes = new Class[]{HprdUpdatePlugin.class, IntActDiseaseUpdatePlugin.class, IntActUpdatePlugin.class, MintUpdatePlugin.class, MipsUpdatePlugin.class};

    public static SettingsUI openPpiSettingsUI(Properties storedSettings, Properties ppiProperties) {
        EntryInfo username = new EntryInfo();
        username.key = "pipa.username";
        username.label = "Username:";
        username.typeI = 0;
        username.tooltip = "Enter your username for the database server.";
        username.defaults = new String[]{"root"};
        EntryInfo password = new EntryInfo();
        password.key = "pipa.password";
        password.label = "Password:";
        password.typeI = 1;
        password.tooltip = "Enter your password for the database server. It will be saved in unreadable form.";
        EntryInfo server = new EntryInfo();
        server.key = "pipa.server";
        server.label = "Server:";
        server.typeI = 0;
        server.tooltip = "Enter the URL or IP-address of the database server. If you do not specify the port using suffix ':<port>' PiPa connects to default MySQL port '3306'.";
        server.defaults = new String[]{"localhost"};
        EntryInfo ppiPath = new EntryInfo();
        ppiPath.key = "pipaPath";
        ppiPath.label = "DIP Data Path:";
        ppiPath.typeI = 3;
        String tempPath = SystemProperties.getTempPath();
        ppiPath.defaults = new String[]{tempPath + "/pipa"};
        ppiPath.tooltip = "As DIP restricts the download to registered users only, please specify the location of the source files here. You can download the file from 'dip.doe-mbi.ucla.edu'";
        EntryInfo database = new EntryInfo();
        database.key = "pipa.database";
        database.label = "Database:";
        database.typeI = 0;
        database.defaults = new String[]{"pipa"};
        database.tooltip = "Enter or choose the name of the database to connect.";
        EntryInfo tmpDir = new EntryInfo();
        tmpDir.key = "pipa.tmpDir";
        tmpDir.label = "Temporary Directory:";
        tmpDir.typeI = 3;
        tmpDir.defaults = new String[]{PpiToolkit.getDefaultTemporaryDirectoryPath()};
        tmpDir.tooltip = "Enter or choose the path temporary files are stored to.";
        List<EntryInfo> entryInfos = Arrays.asList(username, password, server, database, tmpDir, ppiPath);
        SettingsUI settings = new SettingsUI(storedSettings, entryInfos);
        settings.setBlockOnOpen(true);
        settings.create();
        return settings;
    }

    public static void fillTablesWithConstantValues() throws Exception {
        Connection connection = DbService.getCurrentService().getNewConnection();
        String query = "INSERT IGNORE INTO molecule_type VALUES (?,?)";
        PreparedStatement insertMoleculeType = connection.prepareStatement(query);
        Statement statement = connection.createStatement();
        ResultSet result = statement.executeQuery("SELECT count(*) FROM molecule_type");
        result.next();
        if (result.getInt(1) < PpiConstants.MOLECULE_TYPE.values().length) {
            log.warn("Table 'molecule_type' is out of sync and will be updated.");
            for (PpiConstants.MOLECULE_TYPE mt : PpiConstants.MOLECULE_TYPE.values()) {
                insertMoleculeType.setInt(1, mt.ordinal());
                insertMoleculeType.setString(2, mt.toString().toLowerCase());
                insertMoleculeType.addBatch();
            }
            insertMoleculeType.executeBatch();
        }
        result = statement.executeQuery("SELECT count(*) FROM db_source");
        result.next();
        if (result.getInt(1) < PpiConstants.DB_ID.values().length) {
            query = "INSERT IGNORE INTO db_source VALUES (?,?)";
            PreparedStatement insertDbSource = connection.prepareStatement(query);
            log.warn("Table 'db_source' is out of sync and will be updated.");
            for (PpiConstants.DB_ID id : PpiConstants.DB_ID.values()) {
                insertDbSource.setInt(1, id.ordinal());
                insertDbSource.setString(2, id.toString().toLowerCase());
                insertDbSource.addBatch();
            }
            insertDbSource.executeBatch();
        }
        connection.close();
    }

    public static void main(String[] args) throws Exception {
        SettingsUI settings;
        PpiToolkit.setupEnvironment();
        Properties piPaProperties = PpiToolkit.getPiPaProperties();
        if (args.length > 0) {
            piPaProperties.load(new FileReader(args[0]));
        }
        if ((settings = ClientMain.openPpiSettingsUI(PpiToolkit.loadSettings(), piPaProperties)).open() == 0) {
            Properties settingProperties = settings.getSettings();
            for (String key : settingProperties.stringPropertyNames()) {
                piPaProperties.setProperty(key, settingProperties.getProperty(key));
            }
            DbService provider = DbService.createNewDbService(piPaProperties);
            LockingManager lockingManager = LockingManager.instanciate(provider);
            ClientMain.fillTablesWithConstantValues();
            PpiToolkit.storeSettings(settings.getSettingsToStore());
            Properties queries = new Properties();
            queries.load(ClassLoader.getSystemResourceAsStream("de/berlin/hu/ppi/queries.properties"));
            InputStreamReader reader = new InputStreamReader(ClassLoader.getSystemResourceAsStream("de/berlin/hu/ppi/statistics.conf"));
            StatisticsNew statistics = new StatisticsNew(reader, queries);
            final UpdatePluginManager manager = UpdatePluginManager.getInstance();
            int numberOfPlugins = manager.loadPluginsFromRessource("de/berlin/hu/ppi/plugins.conf");
            log.info("Loaded " + numberOfPlugins + " update plugins");
            ClientUI clientUI = new ClientUI(piPaProperties, statistics, manager);
            if (isBatchMode) {
                new Thread(){

                    @Override
                    public void run() {
                        ClientMain.runBatch(manager, classes);
                    }
                }.start();
            }
            clientUI.start();
            lockingManager.clearSessionLocks();
        }
    }

    private static void runBatch(UpdatePluginManager manager, Class<?>[] classes2) {
        for (Class<?> clazz : classes2) {
            UpdatePlugin plugin = manager.getUpdatePlugin(clazz);
            System.out.println("Starting: " + plugin.getName());
            try {
                plugin.startUpdate();
                class Test
                extends Thread {
                    private UpdatePlugin plugin;

                    public Test(UpdatePlugin plugin) {
                        this.plugin = plugin;
                        this.start();
                    }

                    @Override
                    public void run() {
                        while (this.plugin.getState() == UpdatePlugin.State.RUNNING) {
                            log.info(String.format("%s\t%f\t\n", this.plugin.getName(), this.plugin.getProgress()));
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        System.out.println(this.getName() + " done.");
                    }
                }
                new Test(plugin);
                plugin.join();
            }
            catch (UpdatePluginException e) {
                e.printStackTrace();
            }
        }
    }
}

