/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.InteractionNetwork;
import common.Parameter;
import common.Protein;
import common.SerializeAndDeserialize;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Utils {
    private static Utils instance = new Utils();

    private Utils() {
    }

    public static Utils getInstance() {
        return instance;
    }

    public final void myMethod() {
    }

    public final boolean is_term_in_list(String src_term, String[] terms) {
        boolean inside = false;
        for (int i = 0; i < terms.length; ++i) {
            if (!src_term.equals(terms[i])) continue;
            inside = true;
            break;
        }
        return inside;
    }

    public final String list_to_string(String[] list, String sep) {
        String out;
        StringBuffer buf = new StringBuffer();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                buf.append(list[i]).append(sep);
            }
        }
        if ((out = buf.toString()).endsWith(sep)) {
            out = out.substring(0, out.length() - 1);
        }
        return out;
    }

    public final String hashset_to_string(HashSet<String> list, String sep) {
        String out;
        StringBuffer buf = new StringBuffer();
        if (list != null) {
            Iterator<String> iter = list.iterator();
            while (iter.hasNext()) {
                buf.append(iter.next()).append(sep);
            }
        }
        if ((out = buf.toString()).endsWith(sep)) {
            out = out.substring(0, out.length() - 1);
        }
        return out;
    }

    public final String list_to_string(Double[] list, String sep) {
        String out;
        StringBuffer buf = new StringBuffer();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                buf.append(list[i]).append(sep);
            }
        }
        if ((out = buf.toString()).endsWith(sep)) {
            out = out.substring(0, out.length() - 1);
        }
        return out;
    }

    public String bool_list_to_string(boolean[] list, String sep) {
        String out;
        StringBuffer buf = new StringBuffer();
        String str_true = "true";
        String str_false = "false";
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (list[i]) {
                    buf.append(str_true).append(sep);
                    continue;
                }
                buf.append(str_false).append(sep);
            }
        }
        if ((out = buf.toString()).endsWith(sep)) {
            out = out.substring(0, out.length() - 1);
        }
        return out;
    }

    public final String int_vector_to_string(Vector<Integer> vec, String sep) {
        String out;
        StringBuffer buf = new StringBuffer();
        if (vec.size() > 0) {
            for (int i = 0; i < vec.size(); ++i) {
                buf.append(vec.elementAt(i)).append(sep);
            }
        }
        if ((out = buf.toString()).endsWith(sep)) {
            out = out.substring(0, out.length() - 1);
        }
        return out;
    }

    public final Vector<Double> double_list_to_vector(Double[] double_list) {
        Vector<Double> vec = new Vector<Double>();
        for (int i = 0; i < double_list.length; ++i) {
            vec.addElement(double_list[i]);
        }
        return vec;
    }

    public final void print_list(String[] list) {
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                System.out.print(list[i] + " ");
            }
        } else {
            System.out.println("liste leer");
        }
        System.out.println();
    }

    public final double get_log2(double s) {
        return Math.log(s) / Math.log(2.0);
    }

    public final String print_list(double[] protein_scores) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        for (int i = 0; i < protein_scores.length; ++i) {
            buf.append(" ").append(protein_scores[i]);
        }
        buf.append(")");
        return buf.toString();
    }

    public final double mean(int[] m) {
        return (double)this.sum(m) / (double)m.length;
    }

    public final double sum(double[] m) {
        double sum = 0.0;
        for (int i = 0; i < m.length; ++i) {
            sum += m[i];
        }
        return sum;
    }

    public final int sum(int[] m) {
        int sum = 0;
        for (int i = 0; i < m.length; ++i) {
            sum += m[i];
        }
        return sum;
    }

    public final double roundScale2(double d) {
        return Math.rint(d * 100.0) / 100.0;
    }

    public final double roundScale4(double d) {
        return Math.rint(d * 10000.0) / 10000.0;
    }

    public final String get_root_from_ontology(char ontology) {
        String root_term = "";
        root_term = ontology == 'F' ? "GO:0003674" : (ontology == 'P' ? "GO:0008150" : "GO:0005575");
        return root_term;
    }

    public final String get_ontology_from_root(String root) {
        String ontology = "";
        ontology = root.equals("GO:0003674") ? "F" : (root.equals("GO:0008150") ? "P" : "C");
        return ontology;
    }

    public final Vector<String> list_to_vector(String[] list) {
        Vector<String> vector = new Vector<String>();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                vector.addElement(list[i]);
            }
        }
        return vector;
    }

    public final HashSet<String> list_to_hashset(String[] list) {
        HashSet<String> hash = new HashSet<String>();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                hash.add(list[i]);
            }
        }
        return hash;
    }

    public final Vector<Protein> list_to_vector(Protein[] list) {
        Vector<Protein> vector = new Vector<Protein>();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                vector.addElement(list[i]);
            }
        }
        return vector;
    }

    public final String[] vector_to_string_list(Vector<String> vec) {
        String[] list = new String[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            list[i] = vec.elementAt(i);
        }
        return list;
    }

    public final String[] hashSet_to_string_list(HashSet<String> hashSet) {
        String[] list = new String[hashSet.size()];
        Iterator<String> iter = hashSet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            list[i] = iter.next();
            ++i;
        }
        return list;
    }

    public final String vector_to_string(Vector<Double> vec, String sep) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vec.size(); ++i) {
            buf.append(vec.elementAt(i)).append(sep);
        }
        String out = buf.toString();
        if (out.endsWith(sep)) {
            out = out.substring(0, out.length() - sep.length());
        }
        return out;
    }

    public final Protein[] vector_to_protein_list(Vector<Protein> vec) {
        Protein[] list = new Protein[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            list[i] = vec.elementAt(i);
        }
        return list;
    }

    public final String[] create_new_list(int m, String[] terms) {
        String[] new_list = new String[terms.length - 1];
        int index = 0;
        for (int i = 0; i < terms.length; ++i) {
            if (i == m) continue;
            new_list[index] = terms[i];
            ++index;
        }
        return new_list;
    }

    public final Vector<Protein> hash_to_vector(Hashtable<String, Protein> proteins) {
        Vector<Protein> protein_vector = new Vector<Protein>();
        Iterator<String> iter = proteins.keySet().iterator();
        while (iter.hasNext()) {
            protein_vector.addElement(proteins.get(iter.next()));
        }
        return protein_vector;
    }

    public final Protein[] arrayList_to_list(ArrayList<Protein> arraylist) {
        Protein[] list = new Protein[arraylist.size()];
        for (int i = 0; i < arraylist.size(); ++i) {
            list[i] = arraylist.get(i);
        }
        return list;
    }

    public final double[] doubleArrayList_to_list(ArrayList<Double> arraylist) {
        double[] list = new double[arraylist.size()];
        for (int i = 0; i < arraylist.size(); ++i) {
            list[i] = arraylist.get(i);
        }
        return list;
    }

    public InteractionNetwork[] retrieve_networks(String[] organisms_abbr) {
        InteractionNetwork[] networks = new InteractionNetwork[organisms_abbr.length];
        for (int i = 0; i < organisms_abbr.length; ++i) {
            networks[i] = SerializeAndDeserialize.deserialize(Parameter.PATH_INTERACTION_NETWORKS + organisms_abbr[i] + ".ser");
        }
        return networks;
    }

    public InteractionNetwork retrieve_networks(String organisms_abbr) {
        return SerializeAndDeserialize.deserialize(Parameter.PATH_INTERACTION_NETWORKS + organisms_abbr + ".ser");
    }

    public InteractionNetwork retrieve_networks_map_reduce(String organisms_abbr) {
        InputStream is = null;
        try {
            System.err.println("about to load hsa.ser");
            is = Utils.class.getResourceAsStream("/" + organisms_abbr + ".ser");
        }
        catch (Exception e) {
            return null;
        }
        return SerializeAndDeserialize.deserialize(is);
    }

    public String[] read_files_from_folder(String directory) {
        File dir = new File(directory);
        String[] files = dir.list();
        return files;
    }

    public Vector<String> combine_predictions(Vector<String> predicted_function_ortholog, Vector<String> predicted_function_knn) {
        Vector predictions = new Vector();
        predictions = (Vector)predicted_function_ortholog.clone();
        for (int i = 0; i < predicted_function_knn.size(); ++i) {
            String t = predicted_function_knn.elementAt(i);
            if (predictions.contains(t)) continue;
            predictions.addElement(t);
        }
        return predictions;
    }

    public final String get_folder_from_abbr(String abbr) {
        String species = "";
        if (abbr.equalsIgnoreCase(Parameter.ORGANISM_RATTUS_NORVEGICUS_ABBR)) {
            species = Parameter.ORGANISM_RATTUS_NORVEGICUS_FOLDER_NAME;
        } else if (abbr.equalsIgnoreCase(Parameter.ORGANISM_MUS_MUSCULUS_ABBR)) {
            species = Parameter.ORGANISM_MUS_MUSCULUS_FOLDER_NAME;
        } else if (abbr.equalsIgnoreCase(Parameter.ORGANISM_HOMO_SAPIENS_ABBR)) {
            species = Parameter.ORGANISM_HOMO_SAPIENS_FOLDER_NAME;
        } else if (abbr.equalsIgnoreCase(Parameter.ORGANISM_DROSOPHILA_MELANOGASTER_ABBR)) {
            species = Parameter.ORGANISM_DROSOPHILA_MELANOGASTER_FOLDER_NAME;
        } else if (abbr.equalsIgnoreCase(Parameter.ORGANISM_CAENORHABDITIS_ELEGANS_ABBR)) {
            species = Parameter.ORGANISM_CAENORHABDITIS_ELEGANS_FOLDER_NAME;
        } else if (abbr.equalsIgnoreCase(Parameter.ORGANISM_SACCAROMYCES_CEREVISIAE_ABBR)) {
            species = Parameter.ORGANISM_SACCAROMYCES_CEREVISIAE_FOLDER_NAME;
        }
        return species;
    }

    public final String get_folder_name_from_real_name(String organism) {
        String species = "";
        if (organism.equalsIgnoreCase(Parameter.ORGANISM_RATTUS_NORVEGICUS)) {
            species = Parameter.ORGANISM_RATTUS_NORVEGICUS_FOLDER_NAME;
        } else if (organism.equalsIgnoreCase(Parameter.ORGANISM_MUS_MUSCULUS)) {
            species = Parameter.ORGANISM_MUS_MUSCULUS_FOLDER_NAME;
        } else if (organism.equalsIgnoreCase(Parameter.ORGANISM_HOMO_SAPIENS)) {
            species = Parameter.ORGANISM_HOMO_SAPIENS_FOLDER_NAME;
        } else if (organism.equalsIgnoreCase(Parameter.ORGANISM_DROSOPHILA_MELANOGASTER)) {
            species = Parameter.ORGANISM_DROSOPHILA_MELANOGASTER_FOLDER_NAME;
        } else if (organism.equalsIgnoreCase(Parameter.ORGANISM_CAENORHABDITIS_ELEGANS)) {
            species = Parameter.ORGANISM_CAENORHABDITIS_ELEGANS_FOLDER_NAME;
        } else if (organism.equalsIgnoreCase(Parameter.ORGANISM_SACCAROMYCES_CEREVISIAE)) {
            species = Parameter.ORGANISM_SACCAROMYCES_CEREVISIAE_FOLDER_NAME;
        }
        return species;
    }

    public final String get_abbr_from_real_name(String species) {
        String abbr = "";
        if (species.equalsIgnoreCase(Parameter.ORGANISM_RATTUS_NORVEGICUS)) {
            abbr = Parameter.ORGANISM_RATTUS_NORVEGICUS_ABBR;
        } else if (species.equalsIgnoreCase(Parameter.ORGANISM_MUS_MUSCULUS)) {
            abbr = Parameter.ORGANISM_MUS_MUSCULUS_ABBR;
        } else if (species.equalsIgnoreCase(Parameter.ORGANISM_HOMO_SAPIENS)) {
            abbr = Parameter.ORGANISM_HOMO_SAPIENS_ABBR;
        } else if (species.equalsIgnoreCase(Parameter.ORGANISM_DROSOPHILA_MELANOGASTER)) {
            abbr = Parameter.ORGANISM_DROSOPHILA_MELANOGASTER_ABBR;
        } else if (species.equalsIgnoreCase(Parameter.ORGANISM_CAENORHABDITIS_ELEGANS)) {
            abbr = Parameter.ORGANISM_CAENORHABDITIS_ELEGANS_ABBR;
        } else if (species.equalsIgnoreCase(Parameter.ORGANISM_SACCAROMYCES_CEREVISIAE)) {
            abbr = Parameter.ORGANISM_SACCAROMYCES_CEREVISIAE_ABBR;
        }
        return abbr;
    }

    public final String get_result_folder(String[] organisms_abbr) {
        String folder = "";
        for (int i = 0; i < organisms_abbr.length; ++i) {
            folder = folder.concat(this.get_folder_from_abbr(organisms_abbr[i]) + "-");
        }
        folder = folder.substring(0, folder.lastIndexOf("-"));
        return folder + "/";
    }

    public String create_result_folder(String[] organisms_abbr, String path) {
        String folder = path + this.get_result_folder(organisms_abbr);
        File f = new File(folder);
        f.mkdir();
        return folder;
    }

    public final String[] read_organisms(String[] args) {
        String[] species = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase(Parameter.ORGANISM_RATTUS_NORVEGICUS_ABBR)) {
                species[i] = "Rattus norvegicus";
                continue;
            }
            if (args[i].equalsIgnoreCase(Parameter.ORGANISM_MUS_MUSCULUS_ABBR)) {
                species[i] = "Mus musculus";
                continue;
            }
            if (args[i].equalsIgnoreCase(Parameter.ORGANISM_HOMO_SAPIENS_ABBR)) {
                species[i] = "Homo sapiens";
                continue;
            }
            if (args[i].equalsIgnoreCase(Parameter.ORGANISM_DROSOPHILA_MELANOGASTER_ABBR)) {
                species[i] = "Drosophila melanogaster";
                continue;
            }
            if (args[i].equalsIgnoreCase(Parameter.ORGANISM_CAENORHABDITIS_ELEGANS_ABBR)) {
                species[i] = "Caenorhabditis elegans";
                continue;
            }
            if (!args[i].equalsIgnoreCase(Parameter.ORGANISM_SACCAROMYCES_CEREVISIAE_ABBR)) continue;
            species[i] = "Saccharomyces cerevisiae";
        }
        return species;
    }

    public HashMap<String, Integer> create_position_map(String[] organisms) {
        HashMap<String, Integer> taxa_position = new HashMap<String, Integer>();
        for (int i = 0; i < organisms.length; ++i) {
            if (organisms[i].equals(Parameter.ORGANISM_RATTUS_NORVEGICUS_ABBR)) {
                taxa_position.put("Rno", i);
                continue;
            }
            if (organisms[i].equals(Parameter.ORGANISM_MUS_MUSCULUS_ABBR)) {
                taxa_position.put("Mmu", i);
                continue;
            }
            if (organisms[i].equals(Parameter.ORGANISM_HOMO_SAPIENS_ABBR)) {
                taxa_position.put("Hsa", i);
                continue;
            }
            if (organisms[i].equals(Parameter.ORGANISM_DROSOPHILA_MELANOGASTER_ABBR)) {
                taxa_position.put("Dme", i);
                continue;
            }
            if (organisms[i].equals(Parameter.ORGANISM_CAENORHABDITIS_ELEGANS_ABBR)) {
                taxa_position.put("Cel", i);
                continue;
            }
            if (!organisms[i].equals(Parameter.ORGANISM_SACCAROMYCES_CEREVISIAE_ABBR)) continue;
            taxa_position.put("Sce", i);
        }
        return taxa_position;
    }

    public final BufferedReader create_buffered_reader_txt(String file_name, String method_name) {
        BufferedReader buf = null;
        try {
            buf = new BufferedReader(new InputStreamReader(new FileInputStream(file_name)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.out.println("*** " + method_name + "\t" + e);
        }
        return buf;
    }

    public final BufferedWriter create_buffered_writer_txt(String file_name, String method_name) {
        BufferedWriter buf = null;
        try {
            buf = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file_name)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.out.println("*** " + method_name + "\t" + e);
        }
        return buf;
    }

    public BufferedReader create_buffered_reader_html(String url, String method_name) {
        URL url_txt = null;
        URLConnection con = null;
        BufferedReader buf = null;
        try {
            url_txt = new URL(url);
            con = url_txt.openConnection();
            buf = new BufferedReader(new InputStreamReader(con.getInputStream()));
        }
        catch (MalformedURLException e) {
            System.out.println("*** " + method_name + "\t" + e);
        }
        catch (IOException e) {
            System.out.println("*** " + method_name + "\t" + e);
        }
        return buf;
    }

    public final String doubles_to_string(double[] list, String sep) {
        String out;
        StringBuffer buf = new StringBuffer();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                buf.append(list[i]).append(sep);
            }
        }
        if ((out = buf.toString()).endsWith(sep)) {
            out = out.substring(0, out.length() - sep.length());
        }
        return out;
    }

    public final String doubles_to_string(Double[] list, String sep) {
        String out;
        StringBuffer buf = new StringBuffer();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                buf.append(list[i]).append(sep);
            }
        }
        if ((out = buf.toString()).endsWith(sep)) {
            out = out.substring(0, out.length() - sep.length());
        }
        return out;
    }

    public final Vector<Double> double_list_to_vector(double[] list) {
        Vector<Double> vec = new Vector<Double>();
        for (int i = 0; i < list.length; ++i) {
            vec.addElement(list[i]);
        }
        return vec;
    }

    public final int string_to_int(String str) {
        int i = Integer.valueOf(str);
        return i;
    }

    public final double string_to_double(String str) {
        double d = Double.parseDouble(str);
        return d;
    }
}

