/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;

public class ProteinInteraction
implements Serializable {
    private static final long serialVersionUID = 327343338477562836L;
    private static final String PATTERN = "From:\t%s\nTo:\t%s\nDetectionMethods:\t%s\nSourceDB:\t%s\nisDemerged:\t%s\nisComplex\t%s\nisPredicted:%s\n\tisDisease:\t%s";
    private String from = "";
    private String to = "";
    private String interaction_type = "";
    private String source_db = "";
    private String[] detection_methods = new String[0];
    private boolean isDemerged = false;
    private boolean isComplex = false;
    private boolean isPredicted = false;
    private boolean isDisease = false;
    private Hashtable<String, String> methods_shorts = null;

    public boolean isComplex() {
        return this.isComplex;
    }

    public void setComplex(boolean isComplex) {
        this.isComplex = isComplex;
    }

    public boolean isPredicted() {
        return this.isPredicted;
    }

    public void setPredicted(boolean isPredicted) {
        this.isPredicted = isPredicted;
    }

    public boolean isDisease() {
        return this.isDisease;
    }

    public void setDisease(boolean isDisease) {
        this.isDisease = isDisease;
    }

    public boolean isDemerged() {
        return this.isDemerged;
    }

    public void setDemerged(boolean isDemerged) {
        this.isDemerged = isDemerged;
    }

    public ProteinInteraction() {
        this.init_methods_shorts();
    }

    public ProteinInteraction(String from, String to) {
        this.init_methods_shorts();
        this.set_from(from);
        this.set_to(to);
    }

    private void init_methods_shorts() {
        this.methods_shorts = new Hashtable();
        this.methods_shorts.put("two hybrid", "Y2H");
        this.methods_shorts.put("coimmunoprecipitation", "coip");
        this.methods_shorts.put("enzyme linked immunosorbent assay", "elisa");
        this.methods_shorts.put("anti tag coimmunoprecipitation", "anti tag coip");
        this.methods_shorts.put("anti bait coimmunoprecipitation", "anti bait coip");
        this.methods_shorts.put("cosedimentation through density gradient", "cosedi");
        this.methods_shorts.put("protein cross-linking with a bifunctional reagent", "x-linking");
        this.methods_shorts.put("comigration in non denaturing gel electrophoresis", "comig");
        this.methods_shorts.put("beta galactosidase complementation", "-gal compl");
        this.methods_shorts.put("affinity chromatography technology", "affi-chromatography");
        this.methods_shorts.put("molecular sieving", "mol_sieving");
        this.methods_shorts.put("inferred by curator", "curation");
        this.methods_shorts.put("pull down", "p-down");
        this.methods_shorts.put("isothermal titration calorimetry", "calorimetry");
        this.methods_shorts.put("surface plasmon resonance", "spr");
        this.methods_shorts.put("scintillation proximity assay", "scintillation");
        this.methods_shorts.put("experimental interaction detection", "exp detection");
        this.methods_shorts.put("ion exchange chromatography", "ion chromatography");
    }

    public void set_from(String from) {
        if (from != null) {
            this.from = from;
        }
    }

    public void set_to(String to) {
        if (to != null) {
            this.to = to;
        }
    }

    public void set_interaction_type(String interaction_type) {
        if (interaction_type != null) {
            this.interaction_type = interaction_type;
        }
    }

    public void set_source_db(String source_db) {
        if (source_db != null) {
            this.source_db = source_db;
        }
    }

    @Deprecated
    public void set_detection_method(String detection_method) {
        this.set_detection_methods(new String[]{detection_method});
    }

    public void set_detection_methods(String[] detection_methods) {
        if (detection_methods != null) {
            this.detection_methods = new String[detection_methods.length];
            for (int i = 0; i < detection_methods.length; ++i) {
                String method = detection_methods[i];
                this.detection_methods[i] = this.methods_shorts.containsKey(method) ? this.methods_shorts.get(method) : method;
            }
        }
    }

    public String get_from() {
        return this.from;
    }

    public String get_to() {
        return this.to;
    }

    public String get_interaction_type() {
        return this.interaction_type;
    }

    public String get_source_db() {
        return this.source_db;
    }

    @Deprecated
    public String get_detection_method() {
        return this.detection_methods[0];
    }

    public String[] get_detection_methods() {
        return this.detection_methods;
    }

    public String toString() {
        return String.format(PATTERN, this.from, this.to, Arrays.toString(this.detection_methods), this.source_db, this.isDemerged, this.isComplex, this.isPredicted, this.isDisease);
    }
}

