/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.Serializable;
import java.util.Vector;

public class Protein
implements Serializable {
    private static final long serialVersionUID = -8252180734826540672L;
    private String name = "";
    private String shortName = "";
    private String primary_id = "";
    private String sequence = "";
    private String ec_number = "";
    private String organism = "";
    private String org_specific_id = "";
    private String gene_id = "";
    private String chromosome = "";
    private String band = "";
    private String[] interproIds = new String[0];
    private String[] mol_fun = new String[0];
    private String[] bio_pro = new String[0];
    private String[] cell_comp = new String[0];
    private String[] pathway_ids = new String[0];
    private String[] omimPhenotypes = new String[0];
    private String[] reactomeIds = new String[0];
    private String[] keggIds = new String[0];
    public static final String outputFormat = "Name:\t%s\nShort name:\t%s\nUniprotId:\t%s\nSequence:\t%s\nEc-Number:\t%s\nOrganism:\t%s\nOrg Specific ID:\t%s\nGene ID:\t%s\nChromosme:\t%s\nBand:\t%s\nInterproIds:\t%s\nGO function:\t%s\nGO process:\t%s\nGo component:\t%s\nKegg pathways:\t%s\nOmim Phenotypes:\t%s\nReactome IDs:\t%s\nKegg IDs:\t%s";

    public String[] getKeggIds() {
        return this.keggIds;
    }

    public void setKeggIds(String[] keggIds) {
        this.keggIds = keggIds;
    }

    public String getOrganism() {
        return this.organism;
    }

    public void setOrganism(String organism) {
        this.organism = organism;
    }

    public String[] getReactomeIds() {
        return this.reactomeIds;
    }

    public void setReactomeIds(String[] reactomeIds) {
        this.reactomeIds = reactomeIds;
    }

    public Protein() {
    }

    public String getShortName() {
        return this.shortName;
    }

    public Protein(String primary_id, String organism) {
        this.primary_id = primary_id;
        this.organism = organism;
    }

    public void setPrimaryUniprotId(String primary_id) {
        if (primary_id != null) {
            this.primary_id = primary_id;
        }
    }

    public void setSequence(String sequence) {
        if (sequence != null) {
            this.sequence = sequence;
        }
    }

    public void setEcNumber(String ec_number) {
        if (ec_number != null) {
            this.ec_number = ec_number;
        }
    }

    public void setName(String name) {
        if (name != null) {
            if ((name = name.replaceAll("'", "\\\\'")).length() > 100) {
                name = name.substring(0, 99);
            }
            this.name = name;
        }
    }

    public void setGeneId(String gene_id) {
        if (gene_id != null) {
            this.gene_id = gene_id;
        }
    }

    public void set_pathway_ids(String[] pathway_ids) {
        if (pathway_ids != null) {
            this.pathway_ids = pathway_ids;
        }
    }

    public void set_annotation(String[] mf, String[] bp, String[] cc) {
        if (this.mol_fun != null) {
            this.mol_fun = mf;
        }
        if (this.bio_pro != null) {
            this.bio_pro = bp;
        }
        if (this.cell_comp != null) {
            this.cell_comp = cc;
        }
    }

    public void set_go(Vector<String> mol_fun, Vector<String> bio_pro, Vector<String> cell_comp) {
        this.set_annotation(this.vector_to_list(mol_fun), this.vector_to_list(bio_pro), this.vector_to_list(cell_comp));
    }

    public void set_chromosome(String chromosome) {
        if (chromosome != null) {
            this.chromosome = chromosome;
        }
    }

    public void set_band(String band) {
        if (band != null) {
            this.band = band;
        }
    }

    public final void print_list(String[] list) {
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                System.out.print(list[i] + " ");
            }
        } else {
            System.out.println("liste leer");
        }
        System.out.println();
    }

    public void setOrgSpecificId(String org_specific_id) {
        if (org_specific_id != null) {
            this.org_specific_id = org_specific_id;
        }
    }

    public void setOmimPhenotypes(String[] omimPhenotypes) {
        if (omimPhenotypes != null) {
            this.omimPhenotypes = omimPhenotypes;
        }
    }

    public String get_primary_id() {
        return this.primary_id;
    }

    public String get_sequence() {
        return this.sequence;
    }

    public String get_ec_number() {
        return this.ec_number;
    }

    public String[] get_pathway_ids() {
        return this.pathway_ids;
    }

    public String get_interpro_toString() {
        String out = "";
        if (this.interproIds != null) {
            for (int i = 0; i < this.interproIds.length; ++i) {
                out = out.concat(this.interproIds[i] + ":");
            }
        }
        return out;
    }

    public String[] getInterproIds() {
        return this.interproIds;
    }

    public void setInterproIds(String[] interproIds) {
        this.interproIds = interproIds;
    }

    public String[] get_mol_fun() {
        return this.mol_fun;
    }

    public String[] get_bio_pro() {
        return this.bio_pro;
    }

    public String[] get_cell_comp() {
        return this.cell_comp;
    }

    public String get_name() {
        return this.name;
    }

    public String get_organism() {
        return this.organism;
    }

    public String get_org_specific_id() {
        return this.org_specific_id;
    }

    public String get_gene_id() {
        return this.gene_id;
    }

    public String[] getOmimPhenotypes() {
        return this.omimPhenotypes;
    }

    public String get_chromosome() {
        return this.chromosome;
    }

    public String get_band() {
        return this.band;
    }

    public String toString() {
        return String.format(outputFormat, this.name, this.shortName, this.primary_id, this.sequence, this.ec_number, this.organism, this.org_specific_id, this.gene_id, this.chromosome, this.band, this.interproIds.length, this.mol_fun.length, this.bio_pro.length, this.cell_comp.length, this.pathway_ids.length, this.omimPhenotypes.length, this.reactomeIds.length, this.keggIds.length);
    }

    public String[] get_annotation(char ontology) {
        if (ontology == 'F') {
            return this.mol_fun;
        }
        if (ontology == 'P') {
            return this.bio_pro;
        }
        if (ontology == 'C') {
            return this.cell_comp;
        }
        System.out.println("### subontology not exisiting");
        return null;
    }

    public final String[] vector_to_list(Vector<String> vec) {
        String[] list = new String[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            list[i] = vec.elementAt(i);
        }
        return list;
    }

    public void setShortName(String shortName) {
        if (shortName != null) {
            this.shortName = shortName;
        }
    }
}

