/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.InteractionNetwork;
import common.Parameter;
import common.Protein;
import common.ProteinInteraction;
import common.Queries;
import common.SerializeAndDeserialize;
import common.Utils;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.sql.DataSource;

public class PipaDB
implements Queries {
    private static final String STRING_M = "m";
    private static final String COLUMN_PRIMARY_UNIPROT_ID = "primary_uniprot_id";
    private static final String COLUMN_SOURCE = "source";
    private static final String COLUMN_TO_ID = "to_id";
    private static final String COLUMN_FROM_ID = "from_id";
    private static final String COLUMN_DEMERGED = "demerged";
    private static final String COLUMN_DISEASE = "disease";
    private static final String PARAMETER_COMPLEX = "complex";
    private static final String ONE = "1";
    private static final String COLUMN_PREDICTED = "predicted";
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_NAME = "name";
    private static final String COLUMN_SHORT_NAME = "short_name";
    private static final String COLUMN_LOCATION = "location";
    private static final String COLUMN_SEQUENCE = "sequence";
    private static final String COLUMN_EC_NUMBER = "ec_number";
    private static final String COLUMN_GENE_ID = "gene_id";
    private static final String COLUMN_ORG_SPECIFIC_ID = "org_specific_id";
    private Connection con = null;
    private PreparedStatement pstmt_number_of_ppis = null;
    private PreparedStatement pstmt_is_in_db = null;
    private PreparedStatement pstmt_num_of_functions = null;
    private PreparedStatement pstmt_db_source = null;
    private Utils utils = null;
    private PreparedStatement statementDetectionMethodsByInteractionId;
    private PreparedStatement statementPpis;
    private PreparedStatement statementPhenotypes;
    private PreparedStatement statementKeggIds;
    private PreparedStatement statementReactomeIds;
    private PreparedStatement statementProteins;
    private PreparedStatement statmentInterproIds;
    private PreparedStatement statementKeggPathways;

    public PipaDB(DataSource dataSource) {
        try {
            this.utils = Utils.getInstance();
            this.con = dataSource.getConnection();
            this.pstmt_number_of_ppis = this.con.prepareStatement("Select swiss_id_from, swiss_id_to from ppi where swiss_id_from like ? or swiss_id_to like ?");
            this.pstmt_is_in_db = this.con.prepareStatement("Select swiss_id from protein where swiss_id like ?");
            this.pstmt_num_of_functions = this.con.prepareStatement("Select go_id from rel_go where swiss_id like ? and ontology = ? and annotation_type = ?");
            this.pstmt_db_source = this.con.prepareStatement("Select db_source from ppi where (swiss_id_from like ? and swiss_id_to like ?) or (swiss_id_to like ? and swiss_id_from like ?)");
        }
        catch (Exception e) {
            System.out.println("MySQL_DB(): " + e);
        }
    }

    public String get_db_source(String p1, String p2) {
        String db_source = null;
        try {
            this.pstmt_db_source.setString(1, "%" + p1);
            this.pstmt_db_source.setString(2, "%" + p2);
            this.pstmt_db_source.setString(3, "%" + p1);
            this.pstmt_db_source.setString(4, "%" + p2);
            ResultSet rs_temp = this.pstmt_db_source.executeQuery();
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    db_source = rs_temp.getString("db_source");
                }
            }
            rs_temp.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return db_source;
    }

    public String check_entry_type(String omim) {
        String query = "select type from omim where omim = '" + omim + "'";
        String type = "";
        boolean result_retrieved = false;
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    type = rs_temp.getString("type");
                    result_retrieved = true;
                }
            }
        }
        catch (SQLException e) {
            System.out.println("*** check_entry_type: " + e + "\n");
        }
        if (!result_retrieved) {
            type = "*";
        }
        return type;
    }

    public void insert_hpo_relations(Vector<String[]> entries) {
        for (int i = 0; i < entries.size(); ++i) {
            String[] entry = entries.elementAt(i);
            String insert = "INSERT INTO rel_hpo VALUE(";
            insert = insert.concat("'" + entry[0] + "', '" + entry[1] + "','" + entry[2] + "')");
            try {
                Statement stmt = this.con.createStatement();
                stmt.executeUpdate(insert);
                stmt.close();
                continue;
            }
            catch (SQLException e) {
                System.out.println(insert);
                System.out.println("*** insert_hpo_relations: " + e + "\n");
            }
        }
    }

    public void insert_omim_ids(String id, String type, String description) {
        description = description.replaceAll("'", "\\\\'");
        String insert = "INSERT INTO omim VALUE(";
        insert = insert.concat("'" + id + "','" + type + "','" + description + "','','')");
        try {
            Statement stmt = this.con.createStatement();
            stmt.executeUpdate(insert);
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(insert);
            System.out.println("*** insert_omim_ids: " + e + "\n");
        }
    }

    public Vector<String> get_human_genes(String org) {
        Vector<String> uniprot_ids = new Vector<String>();
        String query = "select swiss_id from protein where organism like '" + org + "%'";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    uniprot_ids.addElement(rs_temp.getString("swiss_id"));
                }
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        return uniprot_ids;
    }

    public Vector<String> get_uniprot_ids(String org) {
        Vector<String> uniprot_ids = new Vector<String>();
        String query = "select swiss_id from protein where organism like '" + org + "%' and (swiss_id like 'uni%' or swiss_id like 'trembl%')";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    uniprot_ids.addElement(rs_temp.getString("swiss_id"));
                }
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        return uniprot_ids;
    }

    public Vector<String> get_uniprot_ids_without_kegg(String org) {
        Vector<String> uniprot_ids = new Vector<String>();
        String query = "select swiss_id from protein where (swiss_id like 'uni%' or swiss_id like 'trembl%') and kegg_id = ''";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    uniprot_ids.addElement(rs_temp.getString("swiss_id"));
                }
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        return uniprot_ids;
    }

    public Vector<String> get_uniprot_ids_with_wrong_omim() {
        Vector<String> uniprot_ids = new Vector<String>();
        String query = "select swiss_id from protein where omim like '%omim%' and organism like 'H%'";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    uniprot_ids.addElement(rs_temp.getString("swiss_id"));
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return uniprot_ids;
    }

    public Vector<String> get_uniprot_ids_without_omim() {
        Vector<String> uniprot_ids = new Vector<String>();
        String query = "select swiss_id from protein where omim = '' and organism like 'H%' and (swiss_id like 'uni%' or swiss_id like 'trembl%')";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    uniprot_ids.addElement(rs_temp.getString("swiss_id"));
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return uniprot_ids;
    }

    public Vector<String> get_uniprot_ids_without_gene_id() {
        Vector<String> uniprot_ids = new Vector<String>();
        String query = "select swiss_id from protein where (swiss_id like 'uni%' or swiss_id like 'trembl%') and GeneID = ''";
        System.out.println(query);
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    uniprot_ids.addElement(rs_temp.getString("swiss_id"));
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return uniprot_ids;
    }

    public Vector<String> get_proteins_with_gene_id() {
        Vector<String> gene_ids = new Vector<String>();
        String query = "select GeneID from protein where GeneID != '' and chromo_location = '' and organism like 'H%' ";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    gene_ids.addElement(rs_temp.getString("GeneID"));
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return gene_ids;
    }

    public InteractionNetwork create_interaction_network(String organism) throws SQLException {
        Vector<Protein> proteins = this.get_proteins(organism);
        Vector<ProteinInteraction> ppis = this.get_interactions(organism);
        InteractionNetwork network = new InteractionNetwork(organism, proteins, ppis);
        System.out.println(Parameter.PATH_INTERACTION_NETWORKS + this.utils.get_abbr_from_real_name(organism) + ".ser");
        SerializeAndDeserialize.serialize(Parameter.PATH_INTERACTION_NETWORKS + this.utils.get_abbr_from_real_name(organism) + ".ser", network);
        return network;
    }

    public Vector<String> get_afcs() {
        String query = "Select swiss_id from protein where swiss_id like 'afcs:%'";
        Vector<String> afcs = new Vector<String>();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    afcs.addElement(rs_temp.getString("swiss_id"));
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return afcs;
    }

    public Vector<String> get_ids_without_flybaseid(String org) {
        String query = "select swiss_id from protein where organism like '" + org + "%' and org_specific_id = '' and swiss_id like 'gi:%'";
        Vector<String> ids = new Vector<String>();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    ids.addElement(rs_temp.getString("swiss_id"));
                }
            }
        }
        catch (SQLException e) {
            System.out.println("*** get_ids_without_flybaseid " + e);
        }
        return ids;
    }

    public Vector<String> get_core() {
        String query = "Select swiss_id from protein where swiss_id like 'core:%'";
        Vector<String> core = new Vector<String>();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    core.addElement(rs_temp.getString("swiss_id"));
                }
            }
        }
        catch (SQLException e) {
            System.out.println("*** get_core " + e);
        }
        return core;
    }

    public Vector<String> get_gi() {
        String query = "Select swiss_id from protein where swiss_id like 'gi:%'";
        Vector<String> gi = new Vector<String>();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    gi.addElement(rs_temp.getString("swiss_id"));
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return gi;
    }

    public Vector<Protein> get_proteins(String organism) throws SQLException {
        if (this.statementProteins == null) {
            this.statementProteins = this.con.prepareStatement("select m.id, m.name , m.short_name, m.primary_uniprot_id, c.location , s.sequence, r1.id ec_number, r2.id gene_id, r3.id org_specific_id from molecule m left join chromosomal_location c on m.id = c.molecule_id left join sequence s on m.id = s.molecule_id left join reference r1 on (r1.molecule_id = m.id and r1.db = 'ec_number') left join reference r2 on (r2.molecule_id = m.id and r2.db = 'gene_id') left join reference r3 on (r3.molecule_id = m.id and r3.db = 'org_specific_id') and m.tax_id = ?");
        }
        int taxId = Integer.parseInt(organism);
        this.statementProteins.setInt(1, taxId);
        Vector<Protein> proteins = new Vector<Protein>();
        Protein p = null;
        ResultSet result = this.statementProteins.executeQuery();
        while (result.next()) {
            int i;
            int id = result.getInt(COLUMN_ID);
            String name = result.getString(COLUMN_NAME);
            String shortName = result.getString(COLUMN_SHORT_NAME);
            String uniprotId = result.getString(COLUMN_PRIMARY_UNIPROT_ID);
            String location = result.getString(COLUMN_LOCATION);
            String sequence = result.getString(COLUMN_SEQUENCE);
            String ecNumber = result.getString(COLUMN_EC_NUMBER);
            String geneId = result.getString(COLUMN_GENE_ID);
            String orgSpecificId = result.getString(COLUMN_ORG_SPECIFIC_ID);
            String[] omimPhenotypes = this.getOmimPhentypes(id);
            String[] reactomeIds = this.getReactomeIds(id);
            String[] keggIds = this.getKeggIds(id);
            String[] interproIds = this.getInterproIds(id);
            p = new Protein();
            p.setName(name);
            p.setShortName(shortName);
            p.setPrimaryUniprotId(uniprotId);
            p.setSequence(sequence);
            p.setOrganism(organism);
            p.setEcNumber(ecNumber);
            p.setGeneId(geneId);
            p.setOrgSpecificId(orgSpecificId);
            p.setOmimPhenotypes(omimPhenotypes);
            p.setReactomeIds(reactomeIds);
            p.setKeggIds(keggIds);
            p.setInterproIds(interproIds);
            if (9606 == Integer.parseInt(organism) && location != null && (i = this.getSplitIndex(location)) > -1) {
                String chromosome = location.substring(0, i);
                String band = location.substring(i, location.length());
                p.set_chromosome(chromosome);
                p.set_band(band);
            }
            Vector<String> mol_fun = this.get_annotation_for_protein(uniprotId, "F", STRING_M);
            Vector<String> bio_pro = this.get_annotation_for_protein(uniprotId, "P", STRING_M);
            Vector<String> cell_comp = this.get_annotation_for_protein(uniprotId, "C", STRING_M);
            p.set_go(mol_fun, bio_pro, cell_comp);
            p.set_pathway_ids(this.getPathwayIds(id));
            p.setOrganism(organism);
            proteins.add(p);
            System.out.println(p);
        }
        result.close();
        return proteins;
    }

    public int getSplitIndex(String mapLocation) {
        if (mapLocation != null) {
            String value = mapLocation.toLowerCase();
            return Math.max(value.indexOf(112), value.indexOf(113));
        }
        return -1;
    }

    private String[] getPathwayIds(int moleculeId) throws SQLException {
        ArrayList<String> pathwayIds = new ArrayList<String>(20);
        if (this.statementKeggPathways == null) {
            this.statementKeggPathways = this.con.prepareStatement("select k.pathway_id from reference r, kegg_rel k where r.db = 'kegg_id' and k.kegg_id = r.id and r.molecule_id = ?");
        }
        this.statementKeggPathways.setInt(1, moleculeId);
        ResultSet result = this.statementKeggPathways.executeQuery();
        while (result.next()) {
            String pathwayId = result.getString(1);
            pathwayIds.add(pathwayId);
        }
        result.close();
        return pathwayIds.toArray(new String[pathwayIds.size()]);
    }

    public Vector<String> get_annotation_for_protein(String swiss_id, String ontology, String annotation_type) throws SQLException {
        String query = "select g.go_id from molecule m, go_rel_evidence mg, go g where m.id = mg.molecule_id and mg.go_id = g.go_id and mg.evidence %s= 'IEA' and m.primary_uniprot_id = ? and g.ontology = ?";
        query = String.format(query, STRING_M.equalsIgnoreCase(annotation_type) ? "!" : "");
        PreparedStatement statement = this.con.prepareStatement(query);
        statement.setString(1, swiss_id);
        statement.setString(2, ontology);
        Vector<String> annotation = new Vector<String>();
        try {
            ResultSet rs_temp = statement.executeQuery();
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    String go = rs_temp.getString(1);
                    annotation.add(go);
                }
            }
            rs_temp.close();
            statement.close();
        }
        catch (SQLException e) {
            System.out.println("*** get_annotation_for_protein " + e);
        }
        return annotation;
    }

    private void update_ppi(String update, String old) {
        System.out.println("old: " + old + ", update: " + update);
        String query = "Select * from ppi where swiss_id_from ='" + old + "' or swiss_id_to = '" + old + "'";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    String from = rs_temp.getString("swiss_id_from");
                    String to = rs_temp.getString("swiss_id_to");
                    System.out.println(from + " -- " + to);
                    String db_source = rs_temp.getString("db_source");
                    String detection_method = rs_temp.getString("detection_method");
                    String type = rs_temp.getString("interaction_type");
                    ProteinInteraction ppi = new ProteinInteraction();
                    ppi.set_detection_method(detection_method);
                    ppi.set_interaction_type(type);
                    ppi.set_source_db(db_source);
                    String update_protein = "Update protein set swiss_id = '" + update + "' where swiss_id = '" + old + "';";
                    this.update(update_protein);
                    this.update_rel_go(update, old);
                    if (!from.equals(to)) {
                        if (from.equals(old)) {
                            System.out.println("from = update");
                            ppi.set_from(update);
                            ppi.set_to(to);
                        }
                        if (to.equals(old)) {
                            System.out.println("to = update");
                            ppi.set_from(from);
                            ppi.set_to(update);
                        }
                    } else {
                        System.out.println("both = update");
                        ppi.set_from(update);
                        ppi.set_to(update);
                    }
                    System.out.println("+++ ppi " + ppi);
                    this.insert_ppi(ppi);
                    String delete_ppi = "Delete from ppi where swiss_id_from = '" + from + "' and swiss_id_to = '" + to + "';";
                    this.update(delete_ppi);
                    System.out.println();
                }
            }
            String delete_protein = "Delete from protein where swiss_id = '" + old + "';";
            this.update(delete_protein);
            rs_temp.close();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        System.out.println();
    }

    private void update_rel_go(String update, String old) {
        String query = "Select * from rel_go where swiss_id ='" + old + "'";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    String go_id = rs_temp.getString("go_id");
                    String ontology = rs_temp.getString("ontology");
                    String evidence = rs_temp.getString("evidence");
                    String source = rs_temp.getString(COLUMN_SOURCE);
                    String annotation_type = rs_temp.getString("annotation_type");
                    String[] go_details = new String[]{go_id, ontology, evidence, source, annotation_type};
                    this.insert_rel_go(update, go_details);
                }
            }
            rs_temp.close();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String delete_rel_go = "Delete from rel_go where swiss_id = '" + old + "';";
        this.update(delete_rel_go);
    }

    public void check_redundant_sequences(String org) {
        String query = "Select p.swiss_id, p.sequence from protein p, protein b where p.sequence = b.sequence and p.swiss_id != b.swiss_id and p.organism like '" + org + "%' and b.organism like '" + org + "%'";
        int counter = 0;
        Vector<String> seen = new Vector<String>();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    String id1 = rs_temp.getString("p.swiss_id");
                    String sequence = rs_temp.getString("p.sequence");
                    if (!seen.contains(id1)) {
                        System.out.println("* " + id1 + "\n" + sequence);
                        String q = "Select swiss_id, sequence from protein where sequence = '" + sequence + "' and organism like '" + org + "%'";
                        seen.addElement(id1);
                        Statement stmt_2 = this.con.createStatement();
                        ResultSet rs_temp_2 = stmt_2.executeQuery(q);
                        if (rs_temp_2.isBeforeFirst()) {
                            while (rs_temp_2.next()) {
                                String id2 = rs_temp_2.getString("swiss_id");
                                String seq = rs_temp_2.getString(COLUMN_SEQUENCE);
                                if (id2.equals(id1)) continue;
                                System.out.println(id2 + "\n" + seq);
                                seen.addElement(id2);
                                if (id1.startsWith("uniprotkb:") && id2.startsWith("trembl:") && id1.split(":")[1].equals(id2.split(":")[1])) {
                                    this.update_ppi(id1, id2);
                                    continue;
                                }
                                if (!id2.startsWith("uniprotkb:") || !id1.startsWith("trembl:") || !id1.split(":")[1].equals(id2.split(":")[1])) continue;
                                this.update_ppi(id2, id1);
                            }
                        }
                        System.out.println("---------------------------------------------------------");
                    }
                    ++counter;
                }
            }
            rs_temp.close();
            stmt.close();
        }
        catch (SQLException sqlexception) {
            // empty catch block
        }
        System.out.println(counter);
    }

    public int get_num_of_annotation_for_protein(String swiss_id, String ontology, String annotation_type) {
        int annotation_counter = 0;
        try {
            this.pstmt_num_of_functions.setString(1, "%" + swiss_id);
            this.pstmt_num_of_functions.setString(2, ontology);
            this.pstmt_num_of_functions.setString(3, annotation_type);
            ResultSet rs_temp = this.pstmt_num_of_functions.executeQuery();
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    ++annotation_counter;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return annotation_counter;
    }

    public Vector<ProteinInteraction> get_interactions(String organism) throws SQLException {
        Vector<ProteinInteraction> ppis = new Vector<ProteinInteraction>();
        ProteinInteraction ppi = null;
        if (this.statementPpis == null) {
            this.statementPpis = this.con.prepareStatement("select pi.interaction_id id, pi.predicted predicted, pi.complex_ppi complex, pi.disease_ppi disease, pi.demerged demerged, m1.primary_uniprot_id from_id, m2.primary_uniprot_id to_id, d.db_source_name source from protein_interaction pi, molecule m1, molecule m2, db_source d where pi.protein_id_a = m1.id and pi.protein_id_b = m2.id and d.db_source_id = pi.db_source_id and m1.tax_id = ?");
        }
        this.statementPpis.setInt(1, Integer.parseInt(organism));
        System.out.println(this.statementPpis);
        ResultSet result = this.statementPpis.executeQuery();
        while (result.next()) {
            int id = result.getInt(COLUMN_ID);
            boolean predicted = ONE.equals(result.getString(COLUMN_PREDICTED));
            boolean complex = ONE.equals(result.getString(PARAMETER_COMPLEX));
            boolean disease = ONE.equals(result.getString(COLUMN_DISEASE));
            boolean demerged = ONE.equals(result.getString(COLUMN_DEMERGED));
            String from = result.getString(COLUMN_FROM_ID);
            String to = result.getString(COLUMN_TO_ID);
            String source = result.getString(COLUMN_SOURCE);
            ppi = new ProteinInteraction();
            ppi.setComplex(complex);
            ppi.setDemerged(demerged);
            ppi.setDisease(disease);
            ppi.setPredicted(predicted);
            ppi.set_from(from);
            ppi.set_to(to);
            ppi.set_detection_methods(this.getDetectionMethods(id));
            ppi.set_source_db(source);
            ppis.addElement(ppi);
        }
        result.close();
        this.statementPpis.close();
        return ppis;
    }

    private String[] getDetectionMethods(int interactionId) throws SQLException {
        if (this.statementDetectionMethodsByInteractionId == null) {
            this.statementDetectionMethodsByInteractionId = this.con.prepareStatement("select detection_method from experiment where interaction_id = ?");
        }
        this.statementDetectionMethodsByInteractionId.setInt(1, interactionId);
        ResultSet result = this.statementDetectionMethodsByInteractionId.executeQuery();
        ArrayList<String> values = new ArrayList<String>(100);
        while (result.next()) {
            values.add(result.getString(1));
        }
        String[] output = new String[values.size()];
        values.toArray(output);
        return output;
    }

    public String[] getOmimPhentypes(int moleculeId) throws SQLException {
        if (this.statementPhenotypes == null) {
            this.statementPhenotypes = this.con.prepareStatement("select o.omim_id, o.omim_genotype from molecule m, reference r, omim_rel o where m.tax_id = 9606 and m.id = r.molecule_id and r.db = 'org_specific_id' and r.id = o.omim_genotype and m.id = ?");
        }
        this.statementPhenotypes.setInt(1, moleculeId);
        ResultSet result = this.statementPhenotypes.executeQuery();
        ArrayList<String> values = new ArrayList<String>(100);
        while (result.next()) {
            String omimPhenotype = result.getString(1);
            values.add(omimPhenotype);
        }
        String[] output = new String[values.size()];
        values.toArray(output);
        return output;
    }

    public String[] getKeggIds(int moleculeId) throws SQLException {
        if (this.statementKeggIds == null) {
            this.statementKeggIds = this.con.prepareStatement("select r.id from reference r where r.db = 'kegg_id' and r.molecule_id = ?");
        }
        this.statementKeggIds.setInt(1, moleculeId);
        ResultSet result = this.statementKeggIds.executeQuery();
        ArrayList<String> values = new ArrayList<String>(100);
        while (result.next()) {
            String keggId = result.getString(1);
            values.add(keggId);
        }
        String[] output = new String[values.size()];
        values.toArray(output);
        return output;
    }

    public String[] getReactomeIds(int moleculeId) throws SQLException {
        if (this.statementReactomeIds == null) {
            this.statementReactomeIds = this.con.prepareStatement("select r.reactome_id from molecule m, reactome_rel r where m.id = r.molecule_id and m.id = ?");
        }
        this.statementReactomeIds.setInt(1, moleculeId);
        ResultSet result = this.statementReactomeIds.executeQuery();
        ArrayList<String> values = new ArrayList<String>(100);
        while (result.next()) {
            values.add(result.getString(1));
        }
        String[] output = new String[values.size()];
        values.toArray(output);
        return output;
    }

    public String[] getInterproIds(int moleculeId) throws SQLException {
        if (this.statmentInterproIds == null) {
            this.statmentInterproIds = this.con.prepareStatement("select i.interpro_id from interpro_rel i where i.molecule_id = ?");
        }
        this.statmentInterproIds.setInt(1, moleculeId);
        ResultSet result = this.statmentInterproIds.executeQuery();
        ArrayList<String> values = new ArrayList<String>(100);
        while (result.next()) {
            String interproId = result.getString(1);
            values.add(interproId);
        }
        String[] output = new String[values.size()];
        values.toArray(output);
        return output;
    }

    public int get_number_of_interactions(String id) {
        int counter = 0;
        try {
            this.pstmt_number_of_ppis.setString(1, "%" + id);
            this.pstmt_number_of_ppis.setString(2, "%" + id);
            ResultSet rs_temp = this.pstmt_number_of_ppis.executeQuery();
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    ++counter;
                }
            }
        }
        catch (SQLException e) {
            System.out.println("*** get_interactions " + e);
        }
        return counter;
    }

    public void ppi_statistics(String organism) {
        System.out.println(organism);
        String query = "";
        query = organism.equals("") ? "Select * from ppi" : "Select * from ppi, protein where protein.organism='" + organism + "'";
        String[] source = null;
        Hashtable<Integer, Integer> source_hash = new Hashtable<Integer, Integer>();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    source = rs_temp.getString("db_source").split(":");
                    if (source_hash.containsKey(new Integer(source.length))) {
                        Integer i;
                        Integer n = i = (Integer)source_hash.get(new Integer(source.length));
                        Integer n2 = i = Integer.valueOf(i + 1);
                        source_hash.put(new Integer(source.length), new Integer(i));
                        continue;
                    }
                    source_hash.put(new Integer(source.length), new Integer(1));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        System.out.println(source_hash.size());
        for (Integer num_source : source_hash.keySet()) {
            Integer number_of_interactions = (Integer)source_hash.get(num_source);
            System.out.println("num of source: " + num_source + ", # ppis: " + number_of_interactions);
        }
    }

    public void sequences_to_fasta_for_match(String organism) {
        String short_cut = "";
        if (organism.equals("Mus musculus")) {
            short_cut = "mmu";
        } else if (organism.equals("Homo sapiens")) {
            short_cut = "hsa";
        } else if (organism.equals("Rattus norvegicus")) {
            short_cut = "rno";
        } else if (organism.equals("Drosophila melanogaster")) {
            short_cut = "dme";
        } else if (organism.equals("Saccharomyces cerevisiae")) {
            short_cut = "sce";
        } else if (organism.equals("Caenorhabditis elegans")) {
            short_cut = "cel";
        }
        String fasta_file = "/vol/home-vol3/wbi/sjaeger/workspace/FASTA SEQUENCES/" + short_cut + ".fa";
        String anno_file = "/vol/home-vol3/wbi/sjaeger/workspace/FASTA SEQUENCES/" + short_cut + ".anno";
        String query = "Select swiss_id, sequence from protein where organism = '" + organism + "'";
        BufferedWriter buf_fasta = null;
        BufferedWriter buf_anno = null;
        try {
            buf_fasta = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fasta_file)));
            buf_anno = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(anno_file)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        int index = 1;
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    String id = rs_temp.getString("swiss_id");
                    String name = rs_temp.getString(COLUMN_NAME);
                    String sequence = rs_temp.getString(COLUMN_SEQUENCE);
                    try {
                        buf_fasta.write(">" + short_cut + index);
                        buf_fasta.newLine();
                        buf_fasta.write(sequence);
                        buf_fasta.newLine();
                        id = id.replaceAll(":", "|");
                        buf_anno.write(short_cut + index + "\t" + id + "\t" + name);
                        buf_anno.newLine();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                buf_fasta.close();
                buf_anno.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    public void sequences_to_fasta_for_orthomcl(String organism) {
        String short_cut = "";
        if (organism.equals("Mus musculus")) {
            short_cut = "Mmu";
        } else if (organism.equals("Homo sapiens")) {
            short_cut = "Hsa";
        } else if (organism.equals("Rattus norvegicus")) {
            short_cut = "Rno";
        } else if (organism.equals("Drosophila melanogaster")) {
            short_cut = "Dme";
        } else if (organism.equals("Saccharomyces cerevisiae")) {
            short_cut = "Sce";
        } else if (organism.equals("Caenorhabditis elegans")) {
            short_cut = "Cel";
        }
        String fasta_file = "/vol/home-vol3/wbi/sjaeger/workspace/FASTA SEQUENCES/" + short_cut + ".fa";
        String query = "Select swiss_id, sequence from protein where organism = '" + organism + "'";
        BufferedWriter buf_fasta = null;
        try {
            buf_fasta = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fasta_file)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    String id = rs_temp.getString("swiss_id");
                    String sequence = rs_temp.getString(COLUMN_SEQUENCE);
                    id = id.substring(id.indexOf(":") + 1, id.length());
                    try {
                        buf_fasta.write(">" + id);
                        buf_fasta.newLine();
                        buf_fasta.write(sequence);
                        buf_fasta.newLine();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                buf_fasta.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (SQLException e) {
            System.out.println("*** sequences_to_fasta_for_orthomcl" + e);
        }
    }

    private boolean is_rel_go_in_db(String primary_id, String go_id) {
        boolean inside = false;
        String query = "Select * from rel_go where swiss_id='" + primary_id + "' AND go_id ='" + go_id + "';";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                inside = true;
            }
            rs_temp.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println("*** is_rel_go_in_db " + e);
        }
        return inside;
    }

    private boolean is_protein_in_db(String primary_id) {
        boolean inside = false;
        String query = "Select * from protein where swiss_id = '" + primary_id + "';";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                inside = true;
            }
            rs_temp.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println("*** is_protein_in_db " + e);
        }
        return inside;
    }

    public boolean is_protein_in_db(String primary_id, boolean t) {
        boolean inside = false;
        try {
            this.pstmt_is_in_db.setString(1, "%" + primary_id);
            ResultSet rs_temp = this.pstmt_is_in_db.executeQuery();
            if (rs_temp.isBeforeFirst()) {
                inside = true;
            }
            rs_temp.close();
        }
        catch (SQLException e) {
            System.out.println("*** is_protein_in_db " + e);
        }
        return inside;
    }

    private ProteinInteraction is_ppi_in_db(String from, String to) {
        ProteinInteraction ppi = null;
        String query = "Select * from ppi where swiss_id_from='" + from + "' AND swiss_id_to='" + to + "';";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                ppi = new ProteinInteraction();
                while (rs_temp.next()) {
                    ppi.set_from(rs_temp.getString("swiss_id_from"));
                    ppi.set_to(rs_temp.getString("swiss_id_to"));
                    ppi.set_detection_method(rs_temp.getString("detection_method"));
                    ppi.set_source_db(rs_temp.getString("db_source"));
                    ppi.set_interaction_type(rs_temp.getString("interaction_type"));
                }
            }
            rs_temp.close();
            stmt.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return ppi;
    }

    public void insert_proteins(Hashtable<String, Protein> proteins) {
        Set<Map.Entry<String, Protein>> p = proteins.entrySet();
        for (Map.Entry<String, Protein> entry : p) {
            this.insert_protein(entry.getValue());
        }
    }

    public void insert_proteins(Vector<Protein> proteins) {
        for (int i = 0; i < proteins.size(); ++i) {
            Protein p = proteins.elementAt(i);
            this.insert_protein(p);
        }
    }

    public void insert_protein(Protein p) {
        if (!this.is_protein_in_db(p.get_primary_id())) {
            String interpro = p.get_interpro_toString();
            if (interpro.endsWith(":")) {
                interpro = interpro.substring(0, interpro.length() - 1);
            }
            String insert = "";
            insert = "INSERT INTO protein VALUE('";
            insert = insert.concat(p.get_primary_id() + "','");
            insert = insert.concat(p.get_name() + "','" + p.get_sequence() + "','");
            insert = insert.concat(p.get_organism() + "','");
            insert = insert.concat(p.get_ec_number() + "','','" + interpro + "','" + p.get_org_specific_id() + "','");
            try {
                Statement stmt = this.con.createStatement();
                stmt.executeUpdate(insert);
                stmt.close();
            }
            catch (SQLException e) {
                System.out.println(insert);
                System.out.println("*** insertProtein: " + e);
            }
        } else {
            String query = "Select organism from protein where swiss_id='" + p.get_primary_id() + "';";
            try {
                Statement stmt = this.con.createStatement();
                ResultSet rs_temp = stmt.executeQuery(query);
                if (rs_temp.isBeforeFirst()) {
                    while (rs_temp.next()) {
                        String organism = rs_temp.getString("organism");
                        if (!organism.equals(p.get_organism())) continue;
                        System.out.println("CHECK unterschiedliche spezies (" + organism + ", " + p.get_organism() + ") fuer ");
                    }
                }
                rs_temp.close();
                stmt.close();
            }
            catch (SQLException e) {
                System.out.println("*** is_protein_in_db " + e);
            }
        }
    }

    private String get_organism_from_db(String id) {
        String query = "Select organism from protein where swiss_id = '" + id + "'";
        String organism = "";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    organism = rs_temp.getString("organism");
                }
            }
            rs_temp.close();
            stmt.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return organism;
    }

    public void insert_ppi(ProteinInteraction ppi) {
        String organism_from = this.get_organism_from_db(ppi.get_from());
        String organism_to = this.get_organism_from_db(ppi.get_to());
        System.out.println(ppi.get_from() + " (" + organism_from + ")" + ppi.get_to() + " (" + organism_to + ")");
        if (organism_from.equals(organism_to)) {
            ProteinInteraction ppi_inside_1 = this.is_ppi_in_db(ppi.get_from(), ppi.get_to());
            ProteinInteraction ppi_inside_2 = this.is_ppi_in_db(ppi.get_to(), ppi.get_from());
            if (ppi_inside_1 == null && ppi_inside_2 == null) {
                System.out.println("noch nicht drin");
                String detection_method = ppi.get_detection_method();
                if (detection_method.trim().equals(";")) {
                    detection_method = "";
                }
                String insert = "INSERT INTO ppi VALUE('";
                insert = insert.concat(ppi.get_from() + "','" + ppi.get_to() + "','" + ppi.get_source_db() + "','" + detection_method + "','" + ppi.get_interaction_type() + "')");
                try {
                    Statement stmt = this.con.createStatement();
                    stmt.executeUpdate(insert);
                    stmt.close();
                }
                catch (SQLException e) {
                    System.out.println("*** insert_ppi: " + e);
                }
            } else {
                Statement stmt;
                System.out.println("schon drin");
                ProteinInteraction ppi_inside = null;
                ppi_inside = ppi_inside_1 != null && ppi_inside_2 != null ? ppi_inside_2 : (ppi_inside_1 == null ? ppi_inside_2 : ppi_inside_1);
                System.out.println(ppi_inside.get_source_db());
                System.out.println(ppi.get_source_db());
                if (ppi_inside.get_source_db().indexOf(ppi.get_source_db()) == -1) {
                    String[] source = ppi.get_source_db().split(":");
                    String update_source = ppi_inside.get_source_db();
                    for (int i = 0; i < source.length; ++i) {
                        if (update_source.indexOf(source[i]) != -1) continue;
                        update_source = update_source.concat(":" + source[i]);
                    }
                    String update = "Update ppi set db_source ='" + update_source + "' where swiss_id_from ='" + ppi.get_from() + "' AND swiss_id_to = '" + ppi.get_to() + "'";
                    try {
                        stmt = this.con.createStatement();
                        stmt.executeUpdate(update);
                        stmt.close();
                    }
                    catch (SQLException e) {
                        System.out.println(update);
                        System.out.println("*** update_ppi_db: " + e);
                    }
                }
                if (!ppi_inside.get_detection_method().equals(ppi.get_detection_method())) {
                    String[] detection_method = ppi.get_detection_method().split(";");
                    String update_method = ppi_inside.get_detection_method();
                    for (int i = 0; i < detection_method.length; ++i) {
                        if (ppi_inside.get_detection_method().indexOf(detection_method[i]) != -1) continue;
                        update_method = update_method.length() == 0 ? update_method.concat(detection_method[i]) : update_method.concat(";" + detection_method[i]);
                    }
                    String update = "Update ppi set detection_method='" + update_method + "' where  swiss_id_from ='" + ppi.get_from() + "' AND swiss_id_to = '" + ppi.get_to() + "'";
                    try {
                        stmt = this.con.createStatement();
                        stmt.executeUpdate(update);
                        stmt.close();
                    }
                    catch (SQLException e) {
                        System.out.println("*** update_ppi_method: " + e);
                    }
                }
                if (!ppi_inside.get_interaction_type().equals(ppi.get_interaction_type()) && ppi.get_interaction_type() != null) {
                    String update = "Update ppi set interaction_type='" + ppi.get_interaction_type() + "' where  swiss_id_from ='" + ppi.get_from() + "' AND swiss_id_to = '" + ppi.get_to() + "'";
                    try {
                        System.out.println(update);
                        Statement stmt2 = this.con.createStatement();
                        stmt2.executeUpdate(update);
                        stmt2.close();
                    }
                    catch (SQLException e) {
                        System.out.println("*** update_ppi_interaction_type: " + e);
                    }
                }
            }
        } else {
            System.out.println("#### " + ppi.get_from() + " -- " + ppi.get_to());
        }
    }

    public void insert_ppis(Vector<ProteinInteraction> ppis) {
        for (int i = 0; i < ppis.size(); ++i) {
            ProteinInteraction ppi = ppis.elementAt(i);
            this.insert_ppi(ppi);
        }
    }

    public void insert_ppis(Hashtable<String, ProteinInteraction> ppis) {
        Set<Map.Entry<String, ProteinInteraction>> p = ppis.entrySet();
        for (Map.Entry<String, ProteinInteraction> entry : p) {
            this.insert_ppi(entry.getValue());
        }
    }

    public void insert_rel_go(String primary_id, String[] go_details) {
        if (!this.is_rel_go_in_db(primary_id, go_details[0])) {
            String insert = "INSERT INTO rel_go VALUE('";
            insert = insert.concat(primary_id + "','" + go_details[0] + "','" + go_details[1] + "','" + go_details[2] + "','" + go_details[3] + "','" + go_details[4] + "')");
            try {
                Statement stmt = this.con.createStatement();
                System.out.println(insert);
                stmt.executeUpdate(insert);
                stmt.close();
            }
            catch (SQLException e) {
                System.out.println("*** insert_rel_go: " + e + "\n*** " + insert);
            }
        } else {
            String query = "Select source, evidence, annotation_type from rel_go where swiss_id ='" + primary_id + "' and go_id='" + go_details[0] + "'";
            try {
                Statement stmt = this.con.createStatement();
                ResultSet rs_temp = stmt.executeQuery(query);
                if (rs_temp.isBeforeFirst()) {
                    while (rs_temp.next()) {
                        String update;
                        String source = rs_temp.getString(COLUMN_SOURCE);
                        String evidence = rs_temp.getString("evidence");
                        String annotation_type = rs_temp.getString("annotation_type");
                        if (source.indexOf(go_details[3]) == -1 && !go_details[3].equals("") && !source.equalsIgnoreCase(go_details[3])) {
                            System.out.println("source: " + source + ", neu: " + go_details[3]);
                            update = "Update rel_go set source = '" + source + ";" + go_details[3] + "' where go_id = '" + go_details[0] + "' and swiss_id = '" + primary_id + "'";
                            System.out.println(update);
                            this.update(update);
                        }
                        if (evidence.indexOf(go_details[2]) == -1 && !go_details[2].equals("")) {
                            System.out.println("evidence: " + evidence + ", neu: " + go_details[2]);
                            update = "Update rel_go set evidence = '" + evidence + ";" + go_details[2] + "' where go_id = '" + go_details[0] + "' and swiss_id = '" + primary_id + "'";
                            System.out.println(update);
                            this.update(update);
                        }
                        if (annotation_type.indexOf(go_details[4]) != -1 || go_details[4].equals("")) continue;
                        System.out.println("annotation_type: " + annotation_type + ", neu: " + go_details[4]);
                        update = "Update rel_go set annotation_type = '" + annotation_type + ";" + go_details[4] + "' where go_id = '" + go_details[0] + "' and swiss_id = '" + primary_id + "'";
                        System.out.println(update);
                        this.update(update);
                    }
                }
                rs_temp.close();
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void update_protein(String swiss_id, String update) {
        try {
            Statement stmt = this.con.createStatement();
            System.out.println(update);
            stmt.executeUpdate(update);
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println("*** update_protein: " + e);
        }
    }

    private void iterate_over_annotations(String swiss_id, Vector<String[]> annotations) {
        String mol_root = "GO:0003674";
        String process_root = "GO:0008150";
        String cellular_root = "GO:0005575";
        for (int i = 0; i < annotations.size(); ++i) {
            String[] go_details = annotations.elementAt(i);
            if (go_details[0].equals(mol_root) || go_details[0].equals(process_root) || go_details[0].equals(cellular_root)) continue;
            this.insert_rel_go(swiss_id, go_details);
        }
    }

    private void update(String update) {
        try {
            Statement stmt = this.con.createStatement();
            System.out.println("! " + update);
            stmt.executeUpdate(update);
        }
        catch (SQLException e) {
            System.out.println("*** update " + e);
        }
    }

    public String get_id_for_description(String description) {
        if (description.indexOf("'") != -1) {
            description = description.replaceAll("'", "\\\\'");
        }
        String query = "Select go_id from go where description = '" + description + "'";
        String go_id = "";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    go_id = rs_temp.getString("go_id");
                }
            }
            rs_temp.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println("*** get_id_for_description " + e + "\n" + query);
        }
        return go_id;
    }

    public String get_id_for_alt_id(String alt_id) {
        String query = "Select go_id from go where alt_ids LIKE '%" + alt_id + "%'";
        String go_id = "";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    go_id = rs_temp.getString("go_id");
                }
            }
            rs_temp.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println("*** get_id_for_alt_id " + e + "\n" + query);
        }
        return go_id;
    }

    public void check_omim() {
        String query = "Select omim from protein where omim like 'null%'";
        String src_omim = "omim:";
        String src_null = "null;";
        String src_null2 = "null";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    String omim_original = rs_temp.getString("omim");
                    String omim = omim_original;
                    if (omim.indexOf(src_omim) != -1) {
                        omim = omim.substring(omim.indexOf(src_omim) + src_omim.length(), omim.length());
                    }
                    if (omim.indexOf(src_null) != -1) {
                        omim = omim.substring(omim.indexOf(src_null) + src_null.length(), omim.length());
                    }
                    if (omim.indexOf(src_null2) != -1) {
                        omim = omim.substring(omim.indexOf(src_null2) + src_null2.length(), omim.length());
                    }
                    String[] omims = omim.split(";");
                    String neu = "";
                    for (int i = 0; i < omims.length; ++i) {
                        String omim_temp = omims[i];
                        if (omim_temp.indexOf(")") != -1) {
                            omim_temp = omim_temp.substring(0, omim_temp.indexOf(")"));
                        }
                        if (omim_temp.length() == 12) {
                            omim_temp = omim_temp.substring(0, 6) + ";" + omim_temp.substring(6, 12);
                        }
                        if (omim_temp.length() == 10) {
                            omim_temp = omim_temp.substring(0, 5) + ";" + omim_temp.substring(5, 10);
                        }
                        neu = neu.equals("") ? neu.concat(omim_temp) : neu.concat(";" + omim_temp);
                    }
                    String update = "Update protein set omim ='" + neu + "' where omim = '" + omim_original + "'";
                    System.out.println(update);
                    this.update(update);
                }
                System.out.println();
            }
        }
        catch (SQLException e) {
            System.out.println("*** check_omim" + e);
        }
    }

    public void delete_proteins_without_sequence() {
        String query = "Select swiss_id from protein where sequence =''";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    String swiss_id = rs_temp.getString("swiss_id");
                    String delete_protein = "Delete from protein where swiss_id='" + swiss_id + "'";
                    String delete_ppis = "DELETE from ppi where swiss_id_from ='" + swiss_id + "' or swiss_id_to='" + swiss_id + "'";
                    Statement stmt_temp = this.con.createStatement();
                    stmt_temp.executeUpdate(delete_protein);
                    stmt_temp.executeUpdate(delete_ppis);
                    stmt_temp.close();
                }
            }
            rs_temp.close();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void check_for_primary_secondary_conflicts() {
        String swiss_id;
        String query = "Select swiss_id, secondary_refs from protein";
        Vector<String[]> sets = new Vector<String[]>();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    swiss_id = rs_temp.getString("swiss_id");
                    String secondary_refs = rs_temp.getString("secondary_refs");
                    String[] set = new String[]{swiss_id, secondary_refs};
                    sets.addElement(set);
                }
            }
        }
        catch (SQLException e) {
            System.out.println("*** check_for_primary_secondary_conflicts " + e);
        }
        for (int i = 0; i < sets.size(); ++i) {
            String[] set = (String[])sets.elementAt(i);
            swiss_id = set[0].split(":")[1];
            for (int j = 0; j < sets.size(); ++j) {
                String[] set_test = (String[])sets.elementAt(j);
                if (i == j || set_test[1].indexOf(swiss_id) == -1) continue;
                System.out.println(swiss_id + "(" + set[0] + ") is secondary of " + set_test[0] + " (" + set_test[1] + ")");
            }
        }
    }

    public void test() {
        String query = "Select swiss_id, secondary_refs from protein";
        Vector<String> vec = new Vector<String>();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    String swiss_id = rs_temp.getString("swiss_id");
                    vec.addElement(swiss_id);
                }
            }
        }
        catch (SQLException e) {
            System.out.println("*** check_for_primary_secondary_conflicts " + e);
        }
        for (int i = 0; i < vec.size(); ++i) {
            String test = (String)vec.elementAt(i);
            for (int j = 0; j < vec.size(); ++j) {
                String t = (String)vec.elementAt(j);
                if (test.split(":")[0].equals("uniprotkb") || t.split(":")[0].equals("uniprotkb")) continue;
                System.out.println(test + " " + t);
                if (i == j || !test.split(":")[1].equals(t.split(":")[1])) continue;
                System.out.println(test + " " + t);
            }
        }
    }

    private void get_interactions_from_id(String id) {
        String query = "Select * from ppi where swiss_id_from = '" + id + "' or swiss_id_to = '" + id + "'";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    String from = rs_temp.getString("swiss_id_from");
                    String to = rs_temp.getString("swiss_id_to");
                    System.out.println(from + " " + this.get_organism_from_db(from));
                    System.out.println(to + " " + this.get_organism_from_db(to));
                    System.out.println("----------");
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void check_interactions_redundancy() {
        String query = "select p1.swiss_id_from, p1.swiss_id_to, p1.db_source, p1.detection_method, p1.interaction_type, p2.swiss_id_from, p2.swiss_id_to, p2.db_source, p2.detection_method, p2.interaction_type from ppi p1, ppi p2 where p1.swiss_id_from = p2.swiss_id_to and p1.swiss_id_to = p2.swiss_id_from and p1.swiss_id_from != p1.swiss_id_to";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    String from = rs_temp.getString("p1.swiss_id_from");
                    String to = rs_temp.getString("p1.swiss_id_to");
                    String source = rs_temp.getString("p1.db_source");
                    String method = rs_temp.getString("p1.detection_method");
                    String type = rs_temp.getString("p1.interaction_type");
                    String from_2 = rs_temp.getString("p2.swiss_id_from");
                    String to_2 = rs_temp.getString("p2.swiss_id_to");
                    String source_2 = rs_temp.getString("p2.db_source");
                    String method_2 = rs_temp.getString("p2.detection_method");
                    String type_2 = rs_temp.getString("p2.interaction_type");
                    ProteinInteraction ppi = new ProteinInteraction(from, to);
                    ppi.set_detection_method(method);
                    ppi.set_source_db(source);
                    ppi.set_interaction_type(type);
                    ProteinInteraction ppi_2 = new ProteinInteraction(from_2, to_2);
                    ppi_2.set_detection_method(method_2);
                    ppi_2.set_source_db(source_2);
                    ppi_2.set_interaction_type(type_2);
                    System.out.println("ppi redundant: " + ppi);
                    System.out.println("ppi redundant: " + ppi_2);
                    this.insert_ppi(ppi_2);
                    String delete = "Delete from ppi where swiss_id_from = '" + from + "' and swiss_id_to = '" + to + "'";
                    System.out.println(delete);
                    this.update("Delete from ppi where swiss_id_from = '" + from + "' and swiss_id_to = '" + to + "'");
                    System.out.println();
                }
            }
        }
        catch (SQLException e) {
            System.out.println("*** check_interactions_redundancy " + e);
        }
    }

    public String get_ontology_for_id(String go_id) {
        String query = "Select ontology from go where go_id ='" + go_id + "'";
        String ontology = "";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    ontology = rs_temp.getString("ontology");
                }
            }
            rs_temp.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println("*** get_ontology_for_id " + e);
        }
        return ontology;
    }

    public String[] get_correct_id(String go_id, String ontology) {
        String query = "Select go_id from go where go_id like '%" + go_id + "' and ontology = '" + ontology + "'";
        Vector<String> cand = new Vector<String>();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    String id = rs_temp.getString("go_id");
                    cand.addElement(id);
                }
            }
            rs_temp.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println("*** get_ontology_for_id " + e);
        }
        return this.utils.vector_to_string_list(cand);
    }

    public Vector<String> get_uniprots_without_annotation() {
        String query = "Select swiss_id from protein where (select count(*) from rel_go where rel_go.swiss_id = protein.swiss_id) = 0 and swiss_id like 'uniprotkb%'";
        Vector<String> uniprots = new Vector<String>();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    uniprots.addElement(rs_temp.getString("swiss_id"));
                }
            }
        }
        catch (SQLException e) {
            System.out.println("*** get_uniprots_without_annotation " + e);
        }
        return uniprots;
    }

    public Vector<String> get_proteins_annotated_to_term(String term) {
        Vector<String> proteins = new Vector<String>();
        String query = "Select swiss_id from rel_go where go_id = '" + term + "'";
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs_temp = stmt.executeQuery(query);
            if (rs_temp.isBeforeFirst()) {
                while (rs_temp.next()) {
                    proteins.addElement(rs_temp.getString("swiss_id"));
                }
            }
        }
        catch (SQLException e) {
            System.out.println("*** get_proteins_annotated_to_term " + e);
        }
        return proteins;
    }

    public void execute_update(String to_execute) {
        try {
            Statement stmt = this.con.createStatement();
            System.out.println(to_execute);
            stmt.executeUpdate(to_execute);
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println("\n*** execute_update " + e);
            System.out.println(to_execute + "\n");
        }
    }
}

