/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Parameter;
import common.Protein;
import common.ProteinInteraction;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class InteractionNetwork
implements Serializable {
    private static final long serialVersionUID = 3758551826904324138L;
    private Hashtable<String, Protein> protein_hash = null;
    private Hashtable<String, Protein> alias_names = null;
    private Vector<Protein> proteins = null;
    private HashMap<String, HashMap<String, Integer>> interaction_map = null;
    private String organism = "";
    private int number_of_ppis = -1;

    public InteractionNetwork() {
    }

    public InteractionNetwork(String organism, Vector<Protein> proteins, Vector<ProteinInteraction> interactions) {
        System.out.println("Interaction network for " + organism);
        this.set_organism(organism);
        this.set_proteins(proteins);
        this.set_interactions(interactions);
        this.alias_names = new Hashtable();
        System.out.println("");
    }

    public void iniAlias() {
        this.alias_names = new Hashtable();
    }

    public void set_organism(String organism) {
        this.organism = organism;
    }

    public void set_proteins(Vector<Protein> proteins) {
        this.proteins = proteins;
        this.protein_hash = new Hashtable();
        for (int i = 0; i < proteins.size(); ++i) {
            Protein p = proteins.elementAt(i);
            this.protein_hash.put(p.get_primary_id(), p);
        }
        System.out.println("# proteine: " + proteins.size());
    }

    public void set_interactions(Vector<ProteinInteraction> interactions) {
        this.interaction_map = new HashMap();
        ProteinInteraction ppi = null;
        String from_id = null;
        String to_id = null;
        int counter = 0;
        for (int i = 0; i < interactions.size(); ++i) {
            HashMap<Object, Object> m;
            ppi = interactions.elementAt(i);
            from_id = ppi.get_from();
            to_id = ppi.get_to();
            if (!this.protein_hash.containsKey(from_id) || !this.protein_hash.containsKey(to_id)) continue;
            ++counter;
            if (this.interaction_map.containsKey(from_id)) {
                m = this.interaction_map.get(from_id);
                m.put(to_id, new Integer(ppi.get_source_db().split(":").length));
                this.interaction_map.put(from_id, m);
            } else {
                m = new HashMap<String, Integer>();
                m.put(to_id, new Integer(ppi.get_source_db().split(":").length));
                this.interaction_map.put(from_id, m);
            }
            if (this.interaction_map.containsKey(to_id)) {
                m = this.interaction_map.get(to_id);
                m.put(from_id, new Integer(ppi.get_source_db().split(":").length));
                this.interaction_map.put(to_id, m);
                continue;
            }
            m = new HashMap();
            m.put(from_id, new Integer(ppi.get_source_db().split(":").length));
            this.interaction_map.put(to_id, m);
        }
        System.out.println("# interactions: " + counter);
        this.set_number_of_ppis(counter);
    }

    private void set_number_of_ppis(int number_of_ppis) {
        this.number_of_ppis = number_of_ppis;
    }

    public void add_alias(String alias, Protein p) {
        this.alias_names.put(alias, p);
    }

    public final Protein getAliasProtein(String alias) {
        return this.alias_names.get(alias);
    }

    public final Hashtable<String, Protein> getAliasHash() {
        return this.alias_names;
    }

    public final String get_organism() {
        return this.organism;
    }

    public final Hashtable<String, Protein> get_proteins() {
        return this.protein_hash;
    }

    public final Vector<Protein> get_protein_vector() {
        return this.proteins;
    }

    public final HashMap<String, HashMap<String, Integer>> get_interaction_map() {
        return this.interaction_map;
    }

    public final Protein get_protein(String id) {
        return this.protein_hash.get(id);
    }

    public boolean containsAliasProtein(String alias) {
        return this.alias_names.containsKey(alias);
    }

    public boolean exist_edge(String from, String to) {
        boolean is_egde = false;
        if (this.interaction_map.containsKey(from)) {
            if (this.interaction_map.get(from).containsKey(to)) {
                is_egde = true;
            }
        } else if (this.interaction_map.containsKey(to) && this.interaction_map.get(to).containsKey(from)) {
            is_egde = true;
        }
        return is_egde;
    }

    public int get_num_of_db_evidence(String from, String to) {
        int number = 0;
        if (this.interaction_map.containsKey(from)) {
            if (this.interaction_map.get(from).containsKey(to)) {
                number = this.interaction_map.get(from).get(to);
            }
        } else if (this.interaction_map.containsKey(to) && this.interaction_map.get(to).containsKey(from)) {
            number = this.interaction_map.get(to).get(from);
        }
        return number;
    }

    public int compareTo(InteractionNetwork inter) {
        int x = this.get_proteins().size() < inter.get_proteins().size() ? -1 : (this.get_proteins().size() > inter.get_proteins().size() ? 1 : 0);
        return x;
    }

    public String toString() {
        String number_of_proteins = "";
        number_of_proteins = this.protein_hash.size() == 0 ? Integer.toString(0) : Integer.toString(this.protein_hash.size());
        String out = "organism: " + this.organism + "\nnum of proteins: " + number_of_proteins + "\nnum of interactions: " + this.number_of_ppis;
        return out;
    }

    public void to_cytoScape() {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(Parameter.PATH_INTERACTION_NETWORKS + this.organism + ".sif")));
            Vector<String> printed = new Vector<String>();
            for (String interactor1 : this.interaction_map.keySet()) {
                HashMap<String, Integer> interactors = this.interaction_map.get(interactor1);
                for (String interactor2 : interactors.keySet()) {
                    if (printed.contains(interactor1 + "_" + interactor2) || printed.contains(interactor2 + "_" + interactor1)) continue;
                    out.write(interactor1 + " pp " + interactor2);
                    out.newLine();
                    printed.addElement(interactor1 + "_" + interactor2);
                    printed.addElement(interactor2 + "_" + interactor1);
                }
            }
            out.close();
            printed.clear();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }
}

