/*
 * Decompiled with CFR 0.152.
 */
package scj.evaluation.evals;

import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.order.FrequencyOrder;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.twotrees.labeling.flat.FlatBoth;
import scj.algorithm.twotrees.labeling.minmax.FlatBothMinMax;
import scj.evaluation.Executor;
import scj.result.CountResultList;

public class MinMaxEvaluation
extends Executor {
    public MinMaxEvaluation(RawDataAlgorithm algorithm) {
        super(algorithm);
    }

    public static void main(String[] args) {
        Executor.EXECUTION_MODE[] eXECUTION_MODEArray = new Executor.EXECUTION_MODE[]{Executor.EXECUTION_MODE.Time};
        int n = eXECUTION_MODEArray.length;
        int n2 = 0;
        while (n2 < n) {
            Executor.EXECUTION_MODE mode = eXECUTION_MODEArray[n2];
            String dataSet = args[0];
            MinMaxEvaluation.run(CountResultList.class, dataSet, mode, MinMaxEvaluation.getBenchmarkAlgorithms());
            ++n2;
        }
    }

    public static ConfigurableRawDataAlgorithm[] getBenchmarkAlgorithms() {
        ConfigurableRawDataAlgorithm[] algorithms = new ConfigurableRawDataAlgorithm[4];
        FrequencyOrder order = new FrequencyOrder();
        algorithms[1] = new FlatBoth().withSortOrder(order);
        algorithms[0] = new FlatBothMinMax().withSortOrder(order);
        order = new InverseFrequencyOrder();
        algorithms[2] = new FlatBoth().withSortOrder(order);
        algorithms[3] = new FlatBothMinMax().withSortOrder(order);
        return algorithms;
    }
}

