/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.twotrees.labeling.flat.semi;

import java.util.Set;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.leftside.semi.SemiFlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.labeling.DAAlgorithm;
import scj.algorithm.twotrees.labeling.flat.semi.SemiFlatSearch;
import scj.algorithm.twotrees.labeling.flat.semi.SemiFlatTreeCreator;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

public class SemiFlatNone
extends DAAlgorithm {
    @Override
    public void execute(final Set<DataTuple> n_a, final Set<DataTuple> n_b, Result result) {
        RuntimeCalculator rc = new RuntimeCalculator(this.getClass());
        final SemiFlatTreeCreator flatTreeCreator = new SemiFlatTreeCreator();
        final Node innerPrefixTree = rc.measure(new Executable<Node>(){

            @Override
            public Node execute() {
                return flatTreeCreator.getPrefixTree(n_a, SemiFlatNone.this.sortOrder);
            }
        }, "build prefix tree 1 - step: build prefix tree");
        SemiFlatLeftTree t1 = rc.measure(new Executable<SemiFlatLeftTree>(){

            @Override
            public SemiFlatLeftTree execute() {
                return flatTreeCreator.getInnerFlatTree(innerPrefixTree);
            }
        }, "build prefix tree 1 - step: build flat");
        this.LOGGER.debug("Prefix tree of data set 1: {}", (Object)t1);
        final Node outerPrefixTree = rc.measure(new Executable<Node>(){

            @Override
            public Node execute() {
                return flatTreeCreator.getPrefixTree(n_b, SemiFlatNone.this.sortOrder);
            }
        }, "build prefix tree 2 - step: build prefix tree");
        PIETree t2 = rc.measure(new Executable<PIETree>(){

            @Override
            public PIETree execute() {
                return flatTreeCreator.getOuterFlatTree(outerPrefixTree);
            }
        }, "build prefix tree 2 - step: build flat");
        this.LOGGER.debug("Prefix tree of data set 2: {}", (Object)t2);
        this.LOGGER.info("{}", (Object)rc);
        if (Executor.MODE == Executor.EXECUTION_MODE.Time) {
            SemiFlatSearch search = new SemiFlatSearch(t1, t2, result);
            search.search();
        }
    }
}

