/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.twotrees.labeling.flat;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.order.SortOrder;
import scj.algorithm.tree.rightside.PIETree;
import scj.input.DataTuple;
import scj.runtime.RuntimeCalculator;

public class FlatTreeCreatorRightSideDirect {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlatTreeCreatorRightSideDirect.class);

    public PIETree getOuterFlatTree(Set<DataTuple> data, SortOrder sortOrder) {
        RuntimeCalculator rc = new RuntimeCalculator();
        rc.start("sorting");
        ArrayList<DataTuple> listData = new ArrayList<DataTuple>(data);
        TupleComparator bvc = new TupleComparator();
        Collections.sort(listData, bvc);
        rc.stop("sorting");
        PIETree tree = this.getPieTree(listData);
        rc.start("build tree");
        ArrayList<Integer> activePrefixPos = new ArrayList<Integer>();
        ArrayList<Integer> activePrefix = new ArrayList<Integer>();
        int nodeId = 0;
        tree.addNameToPreorder(-1, 0);
        for (DataTuple tuple : listData) {
            int pos = 0;
            while (pos < tuple.getSet().length) {
                int element = tuple.getSet()[pos];
                if (activePrefix.size() > pos && (Integer)activePrefix.get(pos) != element) {
                    while (activePrefix.size() > pos) {
                        int last = (Integer)activePrefixPos.remove(activePrefixPos.size() - 1);
                        activePrefix.remove(activePrefix.size() - 1);
                        tree.addRangeEnd(last, nodeId);
                    }
                }
                if (!activePrefix.contains(element) && activePrefix.size() == pos) {
                    activePrefixPos.add(++nodeId);
                    activePrefix.add(element);
                    tree.addNameToPreorder(element, nodeId);
                }
                if (pos == tuple.getSet().length - 1) {
                    tree.addPreorderToContent(nodeId, tuple.getId());
                }
                ++pos;
            }
        }
        while (activePrefixPos.size() > 0) {
            int last = (Integer)activePrefixPos.remove(activePrefixPos.size() - 1);
            tree.addRangeEnd(last, nodeId);
        }
        tree.addRangeEnd(0, nodeId);
        rc.stop("build tree");
        LOGGER.info("{}", (Object)rc);
        return tree;
    }

    public PIETree getPieTree(List<DataTuple> listData) {
        PIETree tree1 = new PIETree();
        tree1.init(listData.size());
        return tree1;
    }

    public class TupleComparator
    implements Comparator<DataTuple> {
        @Override
        public int compare(DataTuple o1, DataTuple o2) {
            return new IntArrayList(o1.getSet()).compareTo(new IntArrayList(o2.getSet()));
        }
    }
}

