/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.twotrees.labeling.flat;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.order.SortOrder;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuild;
import scj.input.DataTuple;
import scj.runtime.RuntimeCalculator;

public class FlatTreeCreatorLeftSideDirect {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlatTreeCreatorLeftSideDirect.class);

    public FlatLeftTreeDirectBuild getInnerFlatTree(Set<DataTuple> data, SortOrder sortOrder) {
        RuntimeCalculator rc = new RuntimeCalculator();
        rc.start("sorting");
        ArrayList<DataTuple> listData = new ArrayList<DataTuple>(data);
        TupleComparator bvc = new TupleComparator();
        Collections.sort(listData, bvc);
        rc.stop("sorting");
        FlatLeftTreeDirectBuild tree = this.getFlatLeftTree(listData);
        rc.start("build tree");
        ArrayList<Integer> activePrefixPos = new ArrayList<Integer>();
        ArrayList<Integer> activePrefix = new ArrayList<Integer>();
        int nodeId = 0;
        for (DataTuple tuple : listData) {
            int pos = 0;
            while (pos < tuple.getSet().length) {
                int element = tuple.getSet()[pos];
                if (activePrefix.size() > pos && (Integer)activePrefix.get(pos) != element) {
                    while (activePrefix.size() > pos) {
                        activePrefixPos.remove(activePrefixPos.size() - 1);
                        activePrefix.remove(activePrefix.size() - 1);
                    }
                }
                if (!activePrefix.contains(element) && activePrefix.size() == pos) {
                    int parent = pos == 0 ? 0 : (Integer)activePrefixPos.get(activePrefixPos.size() - 1);
                    tree.addNode(parent, element);
                    activePrefixPos.add(++nodeId);
                    activePrefix.add(element);
                }
                if (pos == tuple.getSet().length - 1) {
                    tree.addTupleToNode(nodeId, tuple.getId());
                }
                ++pos;
            }
        }
        rc.stop("build tree");
        LOGGER.info("{}", (Object)rc);
        return tree;
    }

    public FlatLeftTreeDirectBuild getFlatLeftTree(List<DataTuple> listData) {
        return new FlatLeftTreeDirectBuild(listData.size());
    }

    public class TupleComparator
    implements Comparator<DataTuple> {
        @Override
        public int compare(DataTuple o1, DataTuple o2) {
            return new IntArrayList(o1.getSet()).compareTo(new IntArrayList(o2.getSet()));
        }
    }
}

