/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.twotrees.labeling.flat;

import java.util.Set;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.labeling.DAAlgorithm;
import scj.algorithm.twotrees.labeling.flat.FlatSearch;
import scj.algorithm.twotrees.labeling.flat.FlatTreeCreator;
import scj.algorithm.twotrees.labeling.flat.FlatTreeCreatorRightSideDirect;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

public class FlatRight
extends DAAlgorithm {
    @Override
    public void execute(final Set<DataTuple> n_a, final Set<DataTuple> n_b, Result result) {
        RuntimeCalculator rc = new RuntimeCalculator(this.getClass());
        final FlatTreeCreator flatTreeCreator = new FlatTreeCreator();
        final Node innerPrefixTree = rc.measure(new Executable<Node>(){

            @Override
            public Node execute() {
                return flatTreeCreator.getPrefixTree(n_a, FlatRight.this.sortOrder);
            }
        }, "build prefix tree 1 - step: build prefix tree");
        FlatLeftTree t1 = rc.measure(new Executable<FlatLeftTree>(){

            @Override
            public FlatLeftTree execute() {
                return flatTreeCreator.getInnerFlatTree(innerPrefixTree);
            }
        }, "build prefix tree 1 - step: build flat");
        this.LOGGER.debug("Prefix tree of data set 1: {}", (Object)t1);
        PIETree t2 = rc.measure(new Executable<PIETree>(){

            @Override
            public PIETree execute() {
                return new FlatTreeCreatorRightSideDirect().getOuterFlatTree(n_b, FlatRight.this.sortOrder);
            }
        }, "build prefix tree 2");
        this.LOGGER.debug("Prefix tree of data set 2: {}", (Object)t2);
        this.LOGGER.info("{}", (Object)rc);
        if (Executor.MODE == Executor.EXECUTION_MODE.Time) {
            FlatSearch search = new FlatSearch(t1, t2, result);
            search.search();
        }
    }
}

