/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.tree.leftside;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuild;

public class FlatLeftTreeDirectBuildMinPathLength
extends FlatLeftTreeDirectBuild {
    private IntList minPathLengths;

    public FlatLeftTreeDirectBuildMinPathLength(int tupleCount) {
        super(tupleCount);
    }

    @Override
    public void complete() {
        super.complete();
        this.setPathLengths();
    }

    public void setPathLengths() {
        this.minPathLengths = new IntArrayList(this.size);
        int i = 0;
        while (i < this.size) {
            this.minPathLengths.add(i, 0);
            ++i;
        }
        this.findMinPathLengthOf(0);
    }

    private int findMinPathLengthOf(int x) {
        IntList c = this.getChildrenOf(x);
        IntListIterator it = c.iterator();
        if (this.getIdsByPosition(x).size() > 0 || this.getChildrenOf(x).size() == 0) {
            while (it.hasNext()) {
                int child = it.nextInt();
                this.findMinPathLengthOf(child);
            }
            this.minPathLengths.set(x, 0);
            return 0;
        }
        int min = this.size;
        while (it.hasNext()) {
            int child = it.nextInt();
            int minPathLengthOf = this.findMinPathLengthOf(child);
            if (minPathLengthOf >= min) continue;
            min = minPathLengthOf;
        }
        this.minPathLengths.set(x, min + 1);
        return min + 1;
    }

    public int getMinPathLengthOf(int nodeId) {
        return this.minPathLengths.getInt(nodeId);
    }
}

