/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.tree;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import scj.algorithm.tree.Node;

public class TreeNode
implements Node {
    public static final int DEFAULT_VALUE = -1;
    protected int name;
    protected IntList tupleIds;
    protected Int2ObjectMap<Node> children;

    public TreeNode(int contentElement) {
        this.name = contentElement;
        this.tupleIds = new IntArrayList();
        this.children = new Int2ObjectOpenHashMap<Node>();
    }

    public String toString() {
        throw new IllegalStateException("Do not call me!");
    }

    @Override
    public int getName() {
        return this.name;
    }

    @Override
    public boolean equalsName(Node t2) {
        return this.getName() == t2.getName();
    }

    @Override
    public boolean greaterThanOrEqualsName(Node t2) {
        return this.getName() >= t2.getName();
    }

    @Override
    public void addContent(int tuple) {
        this.tupleIds.add(tuple);
    }

    public IntList getTupleIds() {
        return this.tupleIds;
    }

    public int[] getContentAsInt() {
        return this.tupleIds.toIntArray();
    }

    @Override
    public boolean containsTuples() {
        return !this.tupleIds.isEmpty();
    }

    @Override
    public void addChild(Node node) {
        this.children.put(node.getName(), node);
    }

    @Override
    public Collection<Node> getChildren() {
        return this.children.values();
    }

    @Override
    public Node getChild(int childName) {
        if (this.children.containsKey(childName)) {
            return (Node)this.children.get(childName);
        }
        return null;
    }

    @Override
    public int compareTo(Node o) {
        return Integer.compare(this.name, o.getName());
    }
}

