/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.pretti;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.order.FrequencyOrder;
import scj.algorithm.order.SortOrder;
import scj.algorithm.pretti.PrettiInvertedIndex;
import scj.algorithm.pretti.PrettiPrefixTree;
import scj.algorithm.pretti.PrettiPrefixTreeNode;
import scj.algorithm.pretti.TupleIDList;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.TreeNode;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

public class Pretti
extends ConfigurableRawDataAlgorithm
implements RawDataAlgorithm {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pretti.class);
    SortOrder sortOrder = new FrequencyOrder();

    @Override
    public void preexecute(Set<DataTuple> set1, Set<DataTuple> set2, Result result) {
        this.sortOrder.initialize(set1);
        for (DataTuple r : set1) {
            r.setSet(this.sortOrder.sort(r.getSet()));
        }
    }

    @Override
    public void execute(final Set<DataTuple> set1, final Set<DataTuple> set2, Result result) {
        RuntimeCalculator rc = new RuntimeCalculator(this.getClass());
        PrettiPrefixTree tr = (PrettiPrefixTree)rc.measure(new Executable(){

            public Object execute() {
                return new PrettiPrefixTree(set1);
            }
        }, "build prefix tree");
        System.out.println("prefixtree built");
        PrettiInvertedIndex is = (PrettiInvertedIndex)rc.measure(new Executable(){

            public Object execute() {
                return new PrettiInvertedIndex(set2);
            }
        }, "build inv index");
        System.out.println("inverted index built");
        TIntArrayList cl = (TIntArrayList)rc.measure(new Executable(){

            public Object execute() {
                return TupleIDList.getCandicateListContainingAllEntries(set2);
            }
        }, "get full list");
        for (Node c : tr.getChildren()) {
            this.processNode((PrettiPrefixTreeNode)c, cl, is, result);
        }
        System.out.println("DONE");
        LOGGER.info("{}", (Object)rc);
    }

    public void processNode(TreeNode currentNode, TIntArrayList tupleIDCandidates, PrettiInvertedIndex invertedIndex, Result result) {
        TIntArrayList tupleIDs = TupleIDList.intersect(tupleIDCandidates, invertedIndex.get(currentNode.getName()));
        if (tupleIDs.size() == 0) {
            return;
        }
        TIntIterator it = tupleIDs.iterator();
        while (it.hasNext()) {
            int s = it.next();
            for (Integer r : currentNode.getTupleIds()) {
                result.add(r, s);
            }
        }
        for (Node c : currentNode.getChildren()) {
            this.processNode((TreeNode)c, tupleIDs, invertedIndex, result);
        }
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }
}

