/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.parallel.rangetask;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.algorithm.parallel.rangetask.FlatRangeSearchParallelization;
import scj.algorithm.parallel.rangetask.L1RangeTaskSearch;
import scj.algorithm.parallel.rangetask.SearchRangeTask;
import scj.result.Result;

public class SearchRangeInitTask
implements SearchRangeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchRangeInitTask.class);
    public static final int RANGE_SIZE = 10;
    private Result result;
    protected FlatRangeSearchParallelization search;

    public String toString() {
        return "SearchInit{}";
    }

    public SearchRangeInitTask(L1RangeTaskSearch l1RangeTaskSearch) {
        this.search = l1RangeTaskSearch;
        this.result = l1RangeTaskSearch.result.getSubresult();
    }

    @Override
    public void set(L1RangeTaskSearch onePairSearch, int rangeStart) {
        this.search = onePairSearch;
        this.result = onePairSearch.result.getSubresult();
    }

    @Override
    public void set(FlatSearchParallelization onePairSearch, int r, int s) {
        LOGGER.error("Dont call me!");
    }

    @Override
    public void run() {
        this.search(0, 0);
        this.search.result.add(this.result);
        this.search.informFinished(this);
    }

    protected void search(int r, int s) {
        this.lookForOutput(r, s);
        IntList childrenR = this.search.R.getChildrenOf(r);
        int rangeSize = L1RangeTaskSearch.findAndSetRangeSize(childrenR.size());
        int i = 0;
        while (i < childrenR.size()) {
            this.search.addNewSearch(i);
            i += rangeSize;
        }
    }

    protected void lookForOutput(int r, int s) {
        IntList content_r = this.search.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();
        if (it_r.hasNext()) {
            IntList result_s = this.search.S.getIdsByPosition(s, this.search.S.getRangeEnd(s) + 1);
            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    int nextInt1 = it_s.nextInt();
                    this.result.add(nextInt, nextInt1);
                }
            }
        }
    }
}

