/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.parallel.listtask;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.algorithm.parallel.listtask.FlatListSearchParallelization;
import scj.algorithm.parallel.listtask.SearchListTask;
import scj.result.Result;

public class SearchListTaskWholeTree
implements SearchListTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchListTaskWholeTree.class);
    private FlatListSearchParallelization search;
    private int r;
    private int s;
    private int name;
    private Result result;

    public String toString() {
        return "SearchTaskWholeTree{r=" + this.r + ", s=" + this.s + ", name=" + this.name + '}';
    }

    @Override
    public void set(FlatListSearchParallelization onePairSearch, int r, int name) {
        this.search = onePairSearch;
        this.r = r;
        this.s = this.s;
        this.name = name;
        this.result = onePairSearch.result.getSubresult();
    }

    @Override
    public void set(FlatSearchParallelization onePairSearch, int r, int s) {
        LOGGER.error("Dont call me!");
    }

    @Override
    public void run() {
        this.searchN(this.r, this.name);
        this.search.result.add(this.result);
        this.search.informFinished(this);
    }

    protected void searchN(int r, int name) {
        IntList result = this.search.S.findRanges(name, 0);
        IntListIterator resultItr = result.iterator();
        while (resultItr.hasNext()) {
            this.search(r, resultItr.nextInt());
        }
    }

    protected void search(int r, int s) {
        this.lookForOutput(r, s);
        Iterator iterator = this.search.R.getChildrenOf(r).iterator();
        while (iterator.hasNext()) {
            int c_r = (Integer)iterator.next();
            IntList result = this.search.S.findRanges(this.search.R.getNameOf(c_r), s);
            IntListIterator resultItr = result.iterator();
            while (resultItr.hasNext()) {
                this.search(c_r, resultItr.nextInt());
            }
        }
    }

    private void lookForOutput(int r, int s) {
        IntList content_r = this.search.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();
        if (it_r.hasNext()) {
            IntList result_s = this.search.S.getIdsByPosition(s, this.search.S.getRangeEnd(s) + 1);
            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    this.result.add(nextInt, it_s.nextInt());
                }
            }
        }
    }
}

