/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.parallel.FlatSearchParallelization;
import scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging.AdaptiveRangingSearch;
import scj.algorithm.parallel.adaptiverangingqueuing.adaptiveranging.PrioritizedRangeTask;
import scj.result.Result;

public class PrioritizedRangeTaskWholeTree
implements PrioritizedRangeTask,
Comparable<PrioritizedRangeTask> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrioritizedRangeTaskWholeTree.class);
    private AdaptiveRangingSearch search;
    private int rangeStart;
    private int rangeEnd;
    private int nodeId;
    private IntList rangesS;
    private int priority = -1;
    private Result result;

    @Override
    public void set(FlatSearchParallelization onePairSearch, int r, int s) {
        LOGGER.error("Dont call me!");
    }

    public void set(AdaptiveRangingSearch onePairSearch, int nodeId, int rangeStart, int rangeEnd, IntList rangeStartsS) {
        this.search = onePairSearch;
        this.nodeId = nodeId;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.rangesS = rangeStartsS;
        this.result = onePairSearch.result.getSubresult();
    }

    @Override
    public int compareTo(PrioritizedRangeTask o) {
        return Integer.compare(this.getPriority(), o.getPriority());
    }

    @Override
    public int getPriority() {
        return this.priority != -1 ? this.priority : this.calcPriority();
    }

    private int calcPriority() {
        IntList childrenR = this.search.R.getChildrenOf(this.nodeId);
        int freqSum = 0;
        int i = 0;
        while (i + this.rangeStart <= this.rangeEnd) {
            int r = childrenR.getInt(i + this.rangeStart);
            int nameOf = this.search.R.getNameOf(r);
            Integer f = 0;
            if (this.search.getFrequencyMap() != null && this.search.getFrequencyMap().containsKey(nameOf)) {
                f = this.search.getFrequencyMap().get(nameOf);
            }
            freqSum += f.intValue();
            ++i;
        }
        this.priority = freqSum;
        return freqSum;
    }

    @Override
    public void run() {
        long tmpTime = System.currentTimeMillis();
        this.searchNodes(this.nodeId, this.rangeStart, this.rangeEnd, this.rangesS);
        tmpTime = System.currentTimeMillis() - tmpTime;
        this.search.result.add(this.result);
        this.search.informFinished(this);
        LOGGER.info("{}\t{}\t{}\t{} ms\t{}", this.nodeId, this.rangeStart, this.rangeEnd, tmpTime, this.getPriority());
    }

    private void searchNodes(int nodeId, int rangeStart, int rangeEnd, IntList rangesS) {
        IntList childrenR = this.search.R.getChildrenOf(nodeId);
        int i = 0;
        while (i + rangeStart <= rangeEnd) {
            int r = childrenR.getInt(i + rangeStart);
            int nameOf = this.search.R.getNameOf(r);
            this.search(r, rangesS, nameOf);
            ++i;
        }
    }

    protected void search(int r, IntList s, int name) {
        IntListIterator sItr = s.iterator();
        while (sItr.hasNext()) {
            IntList result = this.search.S.findRanges(name, sItr.nextInt());
            IntListIterator resultItr = result.iterator();
            while (resultItr.hasNext()) {
                this.search(r, resultItr.nextInt());
            }
        }
    }

    protected void search(int r, int s) {
        this.lookForOutput(r, s);
        Iterator iterator = this.search.R.getChildrenOf(r).iterator();
        while (iterator.hasNext()) {
            int c_r = (Integer)iterator.next();
            IntList result = this.search.S.findRanges(this.search.R.getNameOf(c_r), s);
            IntListIterator resultItr = result.iterator();
            while (resultItr.hasNext()) {
                this.search(c_r, resultItr.nextInt());
            }
        }
    }

    private void lookForOutput(int r, int s) {
        IntList content_r = this.search.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();
        if (it_r.hasNext()) {
            IntList result_s = this.search.S.getIdsByPosition(s, this.search.S.getRangeEnd(s) + 1);
            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    this.result.add(nextInt, it_s.nextInt());
                }
            }
        }
    }
}

