/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.parallel.adaptiveranging;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Map;
import java.util.Set;
import scj.algorithm.parallel.DAParallelAlgorithm;
import scj.algorithm.parallel.adaptiveranging.AdaptiveRangeSearchParallelization;
import scj.algorithm.parallel.adaptiveranging.AdaptiveRangingSearch;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuild;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.twotrees.labeling.flat.FlatTreeCreatorLeftSideDirect;
import scj.algorithm.twotrees.labeling.flat.FlatTreeCreatorRightSideDirect;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

public class AdaptiveRanging
extends DAParallelAlgorithm {
    @Override
    public void execute(final Set<DataTuple> n_a, final Set<DataTuple> n_b, Result result) {
        RuntimeCalculator rc = new RuntimeCalculator(this.getClass());
        Map<Integer, Integer> frequencyMap = rc.measure(new Executable<Map<Integer, Integer>>(){

            @Override
            public Map<Integer, Integer> execute() {
                AdaptiveRanging.this.sortOrder.initialize(n_b);
                return AdaptiveRanging.this.sortOrder.getFrequencyMap();
            }
        }, "build frequency map");
        int overallItemCount = 0;
        for (Integer key : frequencyMap.keySet()) {
            overallItemCount += frequencyMap.get(key).intValue();
        }
        this.LOGGER.info("overall item overallItemCount: {}", (Object)overallItemCount);
        final FlatLeftTreeDirectBuild t1 = rc.measure(new Executable<FlatLeftTreeDirectBuild>(){

            @Override
            public FlatLeftTreeDirectBuild execute() {
                return new FlatTreeCreatorLeftSideDirect().getInnerFlatTree(n_a, AdaptiveRanging.this.sortOrder);
            }
        }, "build prefix tree 1 -- build up phase");
        rc.measure(new Executable<FlatLeftTree>(){

            @Override
            public FlatLeftTree execute() {
                t1.complete();
                return t1;
            }
        }, "build prefix tree 1 -- completion");
        this.LOGGER.debug("Prefix tree of data set 1: {}", (Object)t1);
        PIETree t2 = rc.measure(new Executable<PIETree>(){

            @Override
            public PIETree execute() {
                return new FlatTreeCreatorRightSideDirect().getOuterFlatTree(n_b, AdaptiveRanging.this.sortOrder);
            }
        }, "build prefix tree 2");
        this.LOGGER.debug("Prefix tree of data set 2: {}", (Object)t2);
        this.LOGGER.info("{}", (Object)rc);
        if (Executor.MODE == Executor.EXECUTION_MODE.Time) {
            AdaptiveRangingSearch search = new AdaptiveRangingSearch(t1, t2, result, this.getThreads());
            search.setFrequencyMap(frequencyMap);
            search.setOverallItemCount(this.overallItemCount(search));
            search.search();
        }
    }

    protected int overallItemCount(AdaptiveRangeSearchParallelization search) {
        IntList childrenR = search.R.getChildrenOf(0);
        int sum = 0;
        int i = 0;
        while (i < childrenR.size()) {
            int r = childrenR.getInt(i);
            int nameOf = search.R.getNameOf(r);
            Integer f = 0;
            if (search.getFrequencyMap() != null && search.getFrequencyMap().containsKey(nameOf)) {
                f = search.getFrequencyMap().get(nameOf);
            }
            sum += f.intValue();
            ++i;
        }
        return sum;
    }
}

