/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.limitremade.structures;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import java.util.Set;
import scj.input.DataTuple;

public class TupleIDList {
    private static final int MERGE = 1;
    private static final int BINARY = 2;
    private static final double ESTIMATED_SIZE_REDUCTION_AT_INTERSECTION = 0.5;
    private static int averageCandSize;

    public static TIntArrayList getCandicateListContainingAllEntries(Set<DataTuple> set2) {
        averageCandSize = 0;
        long candSizeSum = 0L;
        TIntArrayList cl = new TIntArrayList(set2.size());
        for (DataTuple tuple : set2) {
            cl.add(tuple.getId());
            candSizeSum += (long)tuple.getSet().length;
        }
        averageCandSize = (int)Math.ceil((double)candSizeSum / (double)cl.size());
        cl.sort();
        return cl;
    }

    public static int getAvgCandSize() {
        return averageCandSize;
    }

    public static TIntArrayList intersectHybrid(TIntArrayList tupleIDCandidates, TIntArrayList tIntArrayList, int[][] sArray) {
        int decision = TupleIDList.judgeISCost(tupleIDCandidates, tIntArrayList);
        if (decision == 1) {
            TIntArrayList r = TupleIDList.intersectMerge(tupleIDCandidates, tIntArrayList, sArray);
            return r;
        }
        if (decision == 2) {
            TIntArrayList r = TupleIDList.intersectBinary(tupleIDCandidates, tIntArrayList, sArray);
            return r;
        }
        return null;
    }

    public static int judgeISCost(TIntArrayList tupleIDCandidates, TIntArrayList tIntArrayList) {
        double mergeISCost;
        double binaryISCost;
        int y;
        int x = tupleIDCandidates.size();
        if (x > (y = tIntArrayList.size())) {
            int tmp = x;
            x = y;
            y = tmp;
        }
        if ((binaryISCost = (double)(161 * x) * Math.log(y) / Math.log(2.0) + 59074.0) < (mergeISCost = (double)(292 * x + 85 * y + 175636))) {
            return 2;
        }
        return 1;
    }

    public static TIntArrayList intersectBinary(TIntArrayList tupleIDCandidates, TIntArrayList tIntArrayList, int[][] sArray) {
        boolean candLonger;
        averageCandSize = 0;
        long candSizeSum = 0L;
        if (tupleIDCandidates.size() == 0) {
            return tupleIDCandidates;
        }
        if (tIntArrayList.size() == 0) {
            return tIntArrayList;
        }
        int estimatedListSize = (int)(0.5 * (double)Math.min(tupleIDCandidates.size(), tIntArrayList.size()));
        TIntArrayList newList = new TIntArrayList(estimatedListSize);
        boolean bl = candLonger = tupleIDCandidates.size() > tIntArrayList.size();
        if (candLonger) {
            TIntIterator iterB = tIntArrayList.iterator();
            while (iterB.hasNext()) {
                int b = iterB.next();
                if (!TupleIDList.binarySearch(tupleIDCandidates, b)) continue;
                newList.add(b);
                candSizeSum += (long)sArray[b].length;
            }
        } else {
            TIntIterator iterA = tupleIDCandidates.iterator();
            while (iterA.hasNext()) {
                int a = iterA.next();
                if (!TupleIDList.binarySearch(tIntArrayList, a)) continue;
                newList.add(a);
                candSizeSum += (long)sArray[a].length;
            }
        }
        averageCandSize = (int)Math.ceil((double)candSizeSum / (double)newList.size());
        return newList;
    }

    public static boolean binarySearch(TIntArrayList tList, int element) {
        int low = 0;
        int high = tList.size() - 1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            int midElement = tList.get(mid);
            if (element < midElement) {
                high = mid - 1;
                continue;
            }
            if (element > midElement) {
                low = mid + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    public static TIntArrayList intersectMerge(TIntArrayList tupleIDCandidates, TIntArrayList tIntArrayList, int[][] sArray) {
        averageCandSize = 0;
        long candSizeSum = 0L;
        if (tupleIDCandidates.size() == 0) {
            return tupleIDCandidates;
        }
        if (tIntArrayList.size() == 0) {
            return tIntArrayList;
        }
        int estimatedListSize = (int)(0.5 * (double)Math.min(tupleIDCandidates.size(), tIntArrayList.size()));
        TIntArrayList newList = new TIntArrayList(estimatedListSize);
        TIntIterator iterA = tupleIDCandidates.iterator();
        TIntIterator iterB = tIntArrayList.iterator();
        int b = iterB.next();
        while (iterA.hasNext()) {
            int a = iterA.next();
            while (iterB.hasNext() && a > b) {
                b = iterB.next();
            }
            if (!iterB.hasNext() && a > b) break;
            if (a != b) continue;
            candSizeSum += (long)sArray[a].length;
            newList.add(a);
        }
        averageCandSize = (int)Math.ceil((double)candSizeSum / (double)newList.size());
        return newList;
    }
}

