/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util.tq;

import java.io.Serializable;
import java.util.Date;
import org.teatrove.trove.util.tq.TransactionQueue;

public class TransactionQueueData
implements Serializable {
    private final transient TransactionQueue mTransactionQueue;
    private final long mSnapshotStart;
    private final long mSnapshotEnd;
    private final int mQueueSize;
    private final int mThreadCount;
    private final int mServicingCount;
    private final int mPeakQueueSize;
    private final int mPeakThreadCount;
    private final int mPeakServicingCount;
    private final int mTotalEnqueueAttempts;
    private final int mTotalEnqueued;
    private final int mTotalServiced;
    private final int mTotalExpired;
    private final int mTotalServiceExceptions;
    private final int mTotalUncaughtExceptions;
    private final long mTotalQueueDuration;
    private final long mTotalServiceDuration;
    private transient Date mStartDate;
    private transient Date mEndDate;

    public TransactionQueueData(TransactionQueue tq, long snapshotStart, long snapshotEnd, int queueSize, int threadCount, int servicingCount, int peakQueueSize, int peakThreadCount, int peakServicingCount, int totalEnqueueAttempts, int totalEnqueued, int totalServiced, int totalExpired, int totalServiceExceptions, int totalUncaughtExceptions, long totalQueueDuration, long totalServiceDuration) {
        this.mTransactionQueue = tq;
        this.mSnapshotStart = snapshotStart;
        this.mSnapshotEnd = snapshotEnd;
        this.mQueueSize = queueSize;
        this.mThreadCount = threadCount;
        this.mServicingCount = servicingCount;
        this.mPeakQueueSize = peakQueueSize;
        this.mPeakThreadCount = peakThreadCount;
        this.mPeakServicingCount = peakServicingCount;
        this.mTotalEnqueueAttempts = totalEnqueueAttempts;
        this.mTotalEnqueued = totalEnqueued;
        this.mTotalServiced = totalServiced;
        this.mTotalExpired = totalExpired;
        this.mTotalServiceExceptions = totalServiceExceptions;
        this.mTotalUncaughtExceptions = totalUncaughtExceptions;
        this.mTotalQueueDuration = totalQueueDuration;
        this.mTotalServiceDuration = totalServiceDuration;
    }

    public TransactionQueueData add(TransactionQueueData data) {
        return new TransactionQueueData(null, Math.min(this.mSnapshotStart, data.mSnapshotStart), Math.max(this.mSnapshotEnd, data.mSnapshotEnd), this.mQueueSize + data.mQueueSize, this.mThreadCount + data.mThreadCount, this.mServicingCount + data.mServicingCount, Math.max(this.mPeakQueueSize, data.mPeakQueueSize), Math.max(this.mPeakThreadCount, data.mPeakThreadCount), Math.max(this.mPeakServicingCount, data.mPeakServicingCount), this.mTotalEnqueueAttempts + data.mTotalEnqueueAttempts, this.mTotalEnqueued + data.mTotalEnqueued, this.mTotalServiced + data.mTotalServiced, this.mTotalExpired + data.mTotalExpired, this.mTotalServiceExceptions + data.mTotalServiceExceptions, this.mTotalUncaughtExceptions + data.mTotalUncaughtExceptions, this.mTotalQueueDuration + data.mTotalQueueDuration, this.mTotalServiceDuration + data.mTotalServiceDuration);
    }

    public TransactionQueue getTransactionQueue() {
        return this.mTransactionQueue;
    }

    public Date getSnapshotStart() {
        if (this.mStartDate == null) {
            this.mStartDate = new Date(this.mSnapshotStart);
        }
        return this.mStartDate;
    }

    public Date getSnapshotEnd() {
        if (this.mEndDate == null) {
            this.mEndDate = new Date(this.mSnapshotEnd);
        }
        return this.mEndDate;
    }

    public int getQueueSize() {
        return this.mQueueSize;
    }

    public int getThreadCount() {
        return this.mThreadCount;
    }

    public int getServicingCount() {
        return this.mServicingCount;
    }

    public int getPeakQueueSize() {
        return this.mPeakQueueSize;
    }

    public int getPeakThreadCount() {
        return this.mPeakThreadCount;
    }

    public int getPeakServicingCount() {
        return this.mPeakServicingCount;
    }

    public int getTotalEnqueueAttempts() {
        return this.mTotalEnqueueAttempts;
    }

    public int getTotalEnqueued() {
        return this.mTotalEnqueued;
    }

    public int getTotalServiced() {
        return this.mTotalServiced;
    }

    public int getTotalExpired() {
        return this.mTotalExpired;
    }

    public int getTotalServiceExceptions() {
        return this.mTotalServiceExceptions;
    }

    public int getTotalUncaughtExceptions() {
        return this.mTotalUncaughtExceptions;
    }

    public long getTotalQueueDuration() {
        return this.mTotalQueueDuration;
    }

    public long getTotalServiceDuration() {
        return this.mTotalServiceDuration;
    }

    public long getSnapshotDuration() {
        return this.mSnapshotEnd - this.mSnapshotStart;
    }

    public int getTotalEnqueueFailures() {
        return this.mTotalEnqueueAttempts - this.mTotalEnqueued;
    }

    public int getTotalUnserviced() {
        return this.getTotalEnqueueFailures() + this.mTotalExpired + this.mTotalServiceExceptions;
    }

    public double getAverageQueueDuration() {
        return (double)this.getTotalQueueDuration() / (double)this.getTotalEnqueued();
    }

    public double getAverageServiceDuration() {
        return (double)this.getTotalServiceDuration() / (double)this.getTotalServiced();
    }

    public double getEnqueueAttemptRate() {
        return (double)this.getTotalEnqueueAttempts() * 1000.0 / (double)this.getSnapshotDuration();
    }

    public double getEnqueueSuccessRate() {
        return (double)this.getTotalEnqueued() * 1000.0 / (double)this.getSnapshotDuration();
    }

    public double getServiceRate() {
        return (double)this.getTotalServiced() * 1000.0 / (double)this.getSnapshotDuration();
    }

    public double getEnqueueFailureRatio() {
        return 1.0 - (double)this.getTotalEnqueued() / (double)this.getTotalEnqueueAttempts();
    }
}

