/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util.properties;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.teatrove.trove.log.Syslog;
import org.teatrove.trove.util.PropertyChangeListener;
import org.teatrove.trove.util.PropertyMap;
import org.teatrove.trove.util.PropertyMapFactory;
import org.teatrove.trove.util.PropertyParser;
import org.teatrove.trove.util.properties.SubstitutionFactory;

public class SubstitutionPropertyMapFactory
implements PropertyMapFactory {
    private URL m_url;
    private PropertyChangeListener m_listener;
    public static final String DEFAULT_KEY_START = "$(";
    public static final String DEFAULT_KEY_END = ")";

    public SubstitutionPropertyMapFactory(String sFile) throws MalformedURLException {
        this.m_url = SubstitutionPropertyMapFactory.makeURL(sFile);
    }

    public SubstitutionPropertyMapFactory(URL u) {
        this.m_url = u;
    }

    @Override
    public PropertyMap createProperties() throws IOException {
        PropertyMap properties = new PropertyMap();
        Syslog.debug(this.getClass().getName() + " loading properties from " + this.m_url);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.m_url.openStream()));
        this.load(properties, reader);
        return properties;
    }

    @Override
    public PropertyMap createProperties(PropertyChangeListener listener) throws IOException {
        this.m_listener = listener;
        PropertyMap map = this.createProperties();
        this.m_listener = null;
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(PropertyMap properties, Reader reader) throws IOException {
        try {
            PropertyParser parser = new PropertyParser(properties);
            if (this.m_listener != null) {
                parser.addPropertyChangeListener(this.m_listener);
            }
            parser.parse(reader);
            if (this.m_listener != null) {
                parser.removePropertyChangeListener(this.m_listener);
            }
        }
        finally {
            reader.close();
        }
        PropertyMap propsSub = properties.subMap("properties.substitution");
        SubstitutionFactory subs = this.initSubstitutionFactory(propsSub);
        String sSubStart = propsSub.getString("key.start", DEFAULT_KEY_START);
        String sSubEnd = propsSub.getString("key.end", DEFAULT_KEY_END);
        for (String sKey : properties.keySet()) {
            String sValue = properties.getString(sKey);
            if (!sValue.startsWith(sSubStart) || !sValue.endsWith(sSubEnd)) continue;
            String sName = sValue.substring(sSubStart.length(), sValue.length() - sSubEnd.length());
            String sNew = subs.getSubstitution(sName);
            if (sNew == null) {
                Syslog.error("No substitution found for value (" + sName + ") in key " + sKey);
                continue;
            }
            properties.put(sKey, (Object)sNew);
        }
    }

    private SubstitutionFactory initSubstitutionFactory(PropertyMap props) {
        SubstitutionFactory factory;
        if (props == null) {
            return null;
        }
        String sClass = props.getString("factory.class");
        if (sClass == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(sClass);
            factory = (SubstitutionFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            Syslog.error("Can't locate SubstitutionMap class: " + sClass);
            Syslog.error(e);
            return null;
        }
        catch (ClassCastException e) {
            Syslog.error("Class " + sClass + " is not an instance of " + SubstitutionFactory.class.getName());
            Syslog.error(e);
            return null;
        }
        catch (InstantiationException e) {
            Syslog.error(e);
            return null;
        }
        catch (IllegalAccessException e) {
            Syslog.error(e);
            return null;
        }
        factory.init(props.subMap("factory.init"));
        return factory;
    }

    private static URL makeURL(String path) throws MalformedURLException {
        path = path.replace(File.separatorChar, '/');
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            try {
                File file = new File(path).getAbsoluteFile();
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return new URL("file:" + file.getPath());
            }
            catch (MalformedURLException e2) {
                throw e;
            }
        }
    }
}

