/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.io.Reader;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.teatrove.trove.util.PropertyMap;

public class XMLMapFactory {
    public static final Document createDocument(Reader reader) throws Exception {
        Document result = null;
        SAXBuilder builder = new SAXBuilder();
        result = builder.build(reader);
        return result;
    }

    public static final PropertyMap getPropertyMapFromElement(Element element) {
        PropertyMap result = null;
        if (element != null) {
            result = new PropertyMap();
            String name = element.getName();
            String value = element.getTextTrim();
            if (name != null) {
                if (value != null && !value.equals("")) {
                    result.put(name, (Object)value);
                } else {
                    List childList = element.getChildren();
                    PropertyMap childMap = XMLMapFactory.getChildPropertyMap(childList);
                    if (childMap != null && !childMap.isEmpty()) {
                        PropertyMap subMap = result.subMap(name);
                        subMap.putAll(childMap);
                    }
                }
            }
        }
        return result;
    }

    private static final PropertyMap getChildPropertyMap(List list) {
        PropertyMap result = null;
        if (list != null) {
            result = new PropertyMap();
            for (Object child : list) {
                if (!(child instanceof Element)) continue;
                Element childElement = (Element)child;
                String childName = childElement.getName();
                String childValue = childElement.getTextTrim();
                if (childName == null) continue;
                if (childValue != null && !childValue.equals("")) {
                    result.put(childName, (Object)childValue);
                    continue;
                }
                List childList = childElement.getChildren();
                PropertyMap childMap = XMLMapFactory.getChildPropertyMap(childList);
                if (childMap == null || childMap.isEmpty()) continue;
                PropertyMap subMap = result.subMap(childName);
                subMap.putAll(childMap);
            }
        }
        return result;
    }
}

