/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teatrove.trove.util.BeanComparator;
import org.teatrove.trove.util.NoThreadException;
import org.teatrove.trove.util.ThreadPoolEvent;
import org.teatrove.trove.util.ThreadPoolListener;

public class ThreadPool
extends ThreadGroup {
    private static int cThreadID;
    private long mTimeout = -1L;
    private long mIdleTimeout = -1L;
    private Collection mListeners = new LinkedList();
    private LinkedList mPool;
    private int mMax;
    private int mActive;
    private boolean mDaemon;
    private int mPriority;
    private boolean mClosed;

    private static synchronized int nextThreadID() {
        return cThreadID++;
    }

    public ThreadPool(String name, int max) throws IllegalArgumentException {
        this(name, max, true);
    }

    public ThreadPool(ThreadGroup parent, String name, int max) throws IllegalArgumentException {
        this(parent, name, max, true);
    }

    public ThreadPool(String name, int max, boolean daemon) throws IllegalArgumentException {
        super(name);
        this.init(max, daemon);
    }

    public ThreadPool(ThreadGroup parent, String name, int max, boolean daemon) throws IllegalArgumentException {
        super(parent, name);
        this.init(max, daemon);
    }

    private void init(int max, boolean daemon) throws IllegalArgumentException {
        if (max <= 0) {
            throw new IllegalArgumentException("Maximum number of threads must be greater than zero: " + max);
        }
        this.mMax = max;
        this.mDaemon = daemon;
        this.mPriority = Thread.currentThread().getPriority();
        this.mClosed = false;
        this.mPool = new LinkedList();
    }

    public synchronized void setTimeout(long timeout) {
        this.mTimeout = timeout;
    }

    public synchronized long getTimeout() {
        return this.mTimeout;
    }

    public synchronized void setIdleTimeout(long timeout) {
        this.mIdleTimeout = timeout;
    }

    public synchronized long getIdleTimeout() {
        return this.mIdleTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThreadPoolListener(ThreadPoolListener listener) {
        Collection collection = this.mListeners;
        synchronized (collection) {
            this.mListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThreadPoolListener(ThreadPoolListener listener) {
        Collection collection = this.mListeners;
        synchronized (collection) {
            this.mListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPriority() {
        LinkedList linkedList = this.mPool;
        synchronized (linkedList) {
            return this.mPriority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int priority) throws IllegalArgumentException {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("Priority out of range: " + priority);
        }
        LinkedList linkedList = this.mPool;
        synchronized (linkedList) {
            this.mPriority = priority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximumAllowed() {
        LinkedList linkedList = this.mPool;
        synchronized (linkedList) {
            return this.mMax;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableCount() {
        LinkedList linkedList = this.mPool;
        synchronized (linkedList) {
            return this.mPool.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPooledCount() {
        LinkedList linkedList = this.mPool;
        synchronized (linkedList) {
            return this.mActive;
        }
    }

    public int getThreadCount() {
        return this.activeCount();
    }

    public Thread[] getAllThreads() {
        int count = this.activeCount();
        Thread[] threads = new Thread[count];
        if ((count = this.enumerate(threads)) >= threads.length) {
            return this.sort(threads);
        }
        Thread[] newThreads = new Thread[count];
        System.arraycopy(threads, 0, newThreads, 0, count);
        return this.sort(newThreads);
    }

    private Thread[] sort(Thread[] threads) {
        BeanComparator c = BeanComparator.forClass(Thread.class).orderBy("threadGroup.name").orderBy("name").orderBy("priority");
        Arrays.sort(threads, c);
        return threads;
    }

    public Thread start(Runnable target) throws NoThreadException, InterruptedException {
        try {
            return this.start0(target, this.getTimeout(), null);
        }
        catch (NoThreadException e) {
            e.fillInStackTrace();
            throw e;
        }
    }

    public Thread start(Runnable target, long timeout) throws NoThreadException, InterruptedException {
        try {
            return this.start0(target, timeout, null);
        }
        catch (NoThreadException e) {
            e.fillInStackTrace();
            throw e;
        }
    }

    public Thread start(Runnable target, String name) throws NoThreadException, InterruptedException {
        try {
            return this.start0(target, this.getTimeout(), name);
        }
        catch (NoThreadException e) {
            e.fillInStackTrace();
            throw e;
        }
    }

    public Thread start(Runnable target, long timeout, String name) throws NoThreadException, InterruptedException {
        try {
            return this.start0(target, timeout, name);
        }
        catch (NoThreadException e) {
            e.fillInStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread start0(Runnable target, long timeout, String name) throws NoThreadException, InterruptedException {
        PooledThread thread;
        LinkedList linkedList;
        while (true) {
            linkedList = this.mPool;
            synchronized (linkedList) {
                this.closeCheck();
                if (this.mPool.size() <= 0) {
                    if (this.mActive < this.mMax) {
                        return this.startThread(target, name);
                    }
                    break;
                }
                thread = (PooledThread)this.mPool.removeLast();
            }
            if (thread.setTarget(target)) {
                return thread;
            }
            thread.join();
        }
        if (timeout == 0L) {
            throw new NoThreadException("No thread available from " + this);
        }
        linkedList = this.mPool;
        synchronized (linkedList) {
            this.closeCheck();
            if (timeout < 0L) {
                while (this.mPool.size() <= 0) {
                    this.mPool.wait(0L);
                    this.closeCheck();
                }
            } else {
                long expireTime = System.currentTimeMillis() + timeout;
                while (this.mPool.size() <= 0) {
                    this.mPool.wait(timeout);
                    this.closeCheck();
                    if (this.mPool.size() > 0 || System.currentTimeMillis() <= expireTime) continue;
                    throw new NoThreadException("No thread available after waiting " + timeout + " milliseconds: " + this);
                }
            }
            if ((thread = (PooledThread)this.mPool.removeLast()).setTarget(target)) {
                return thread;
            }
        }
        thread.join();
        return this.startThread(target, name);
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    public void close() throws InterruptedException {
        this.close(this.getTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long timeout) throws InterruptedException {
        LinkedList linkedList = this.mPool;
        synchronized (linkedList) {
            this.mClosed = true;
            this.mPool.notifyAll();
            if (timeout != 0L) {
                if (timeout < 0L) {
                    while (this.mActive > 0) {
                        this.mPool.wait(0L);
                    }
                } else {
                    long expireTime = System.currentTimeMillis() + timeout;
                    while (this.mActive > 0) {
                        this.mPool.wait(timeout);
                        if (System.currentTimeMillis() <= expireTime) continue;
                    }
                }
            }
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledThread startThread(Runnable target, String name) {
        PooledThread thread;
        Collection collection = this.mPool;
        synchronized (collection) {
            ++this.mActive;
            thread = new PooledThread(this.getName() + ' ' + ThreadPool.nextThreadID());
            thread.setPriority(this.mPriority);
            thread.setDaemon(this.mDaemon);
            thread.setTarget(target);
            thread.start();
        }
        collection = this.mListeners;
        synchronized (collection) {
            if (this.mListeners.size() > 0) {
                ThreadPoolEvent event = new ThreadPoolEvent(this, thread);
                Iterator it = this.mListeners.iterator();
                while (it.hasNext()) {
                    ((ThreadPoolListener)it.next()).threadStarted(event);
                }
            }
        }
        return thread;
    }

    private void closeCheck() throws NoThreadException {
        if (this.mClosed) {
            throw new NoThreadException("Thread pool is closed", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadAvailable(PooledThread thread) {
        LinkedList linkedList = this.mPool;
        synchronized (linkedList) {
            if (thread.getPriority() != this.mPriority) {
                thread.setPriority(this.mPriority);
            }
            this.mPool.addLast(thread);
            this.mPool.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadExiting(PooledThread thread) {
        Collection collection = this.mPool;
        synchronized (collection) {
            this.mPool.remove(thread);
            --this.mActive;
            this.mPool.notify();
        }
        collection = this.mListeners;
        synchronized (collection) {
            if (this.mListeners.size() > 0) {
                ThreadPoolEvent event = new ThreadPoolEvent(this, thread);
                Iterator it = this.mListeners.iterator();
                while (it.hasNext()) {
                    ((ThreadPoolListener)it.next()).threadExiting(event);
                }
            }
        }
    }

    private class PooledThread
    extends Thread {
        private Runnable mTarget;
        private boolean mExiting;

        public PooledThread(String name) {
            super((ThreadGroup)ThreadPool.this, name);
            this.setInheritedAccessControlContextToNull();
        }

        private boolean setInheritedAccessControlContextToNull() {
            Logger log = Logger.getLogger(PooledThread.class.getName());
            try {
                Field field = Thread.class.getDeclaredField("inheritedAccessControlContext");
                if (field != null) {
                    field.setAccessible(true);
                    field.set(this, null);
                    return true;
                }
            }
            catch (IllegalAccessException e) {
                log.logp(Level.WARNING, PooledThread.class.getName(), "<init>", "Unable to nullify inheritedAccessControlContext.", e);
            }
            catch (NoSuchFieldException e) {
                log.logp(Level.WARNING, PooledThread.class.getName(), "<init>", "Unable to nullify inheritedAccessControlContext.", e);
            }
            return false;
        }

        synchronized boolean setTarget(Runnable target) {
            if (this.mTarget != null) {
                throw new IllegalStateException("Target runnable in pooled thread is already set");
            }
            if (this.mExiting) {
                return false;
            }
            this.mTarget = target;
            this.notify();
            return true;
        }

        private synchronized Runnable waitForTarget() {
            Runnable target = this.mTarget;
            if (target == null) {
                long idle = ThreadPool.this.getIdleTimeout();
                target = this.mTarget;
                if (target == null) {
                    if (idle != 0L) {
                        try {
                            if (idle < 0L) {
                                this.wait(0L);
                            } else {
                                this.wait(idle);
                            }
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if ((target = this.mTarget) == null) {
                        this.mExiting = true;
                    }
                }
            }
            return target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!ThreadPool.this.isClosed()) {
                    if (Thread.interrupted()) continue;
                    Runnable target = this.waitForTarget();
                    if (target == null) {
                        break;
                    }
                    try {
                        target.run();
                    }
                    catch (ThreadDeath death) {
                        break;
                    }
                    catch (Throwable e) {
                        ThreadPool.this.uncaughtException(Thread.currentThread(), e);
                        Object var2_2 = null;
                    }
                    target = null;
                    this.mTarget = null;
                    ThreadPool.this.threadAvailable(this);
                }
            }
            finally {
                ThreadPool.this.threadExiting(this);
            }
        }
    }
}

