/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SortedArrayList
extends ArrayList {
    private Comparator mComparator = null;

    public SortedArrayList(Comparator c) {
        this.mComparator = c;
    }

    public SortedArrayList() {
    }

    public SortedArrayList(Collection c) {
        this.addAll(c);
    }

    public Comparator comparator() {
        return this.mComparator;
    }

    @Override
    public boolean add(Object o) {
        int idx = 0;
        if (!this.isEmpty()) {
            idx = this.findInsertionPoint(o);
        }
        try {
            super.add(idx, o);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        Iterator i = c.iterator();
        boolean changed = false;
        while (i.hasNext()) {
            boolean ret = this.add(i.next());
            if (changed) continue;
            changed = ret;
        }
        return changed;
    }

    public Object lastElement() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(this.size() - 1);
    }

    public int findInsertionPoint(Object o) {
        return this.findInsertionPoint(o, 0, this.size() - 1);
    }

    @Override
    public void add(int index, Object element) {
        System.out.println("add");
        throw new UnsupportedOperationException("add(int index, Object element is not Supported");
    }

    @Override
    public Object set(int index, Object element) {
        throw new UnsupportedOperationException("set(int index, Object element) is not Supported");
    }

    @Override
    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException("addAll(int index, Collection c) is not Supported");
    }

    private int compare(Object k1, Object k2) {
        return this.mComparator == null ? ((Comparable)k1).compareTo(k2) : this.mComparator.compare(k1, k2);
    }

    private int findInsertionPoint(Object o, int startIndex, int endIndex) {
        int halfPt = (endIndex - startIndex) / 2 + startIndex;
        int delta = this.compare(this.get(halfPt), o);
        if (delta < 0) {
            endIndex = halfPt;
        } else if (delta > 0) {
            startIndex = halfPt;
        } else {
            return halfPt;
        }
        if (endIndex - startIndex <= 1) {
            return endIndex + 1;
        }
        return this.findInsertionPoint(o, startIndex, endIndex);
    }
}

