/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.teatrove.trove.util.IdentityMap;

public class SoftHashMap
extends AbstractMap
implements Map,
Cloneable {
    private transient Entry[] mTable;
    private transient int mCount;
    private int mThreshold;
    private float mLoadFactor;
    private transient int mModCount = 0;
    private transient Set mKeySet = null;
    private transient Set mEntrySet = null;
    private transient Collection mValues = null;

    public SoftHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.mLoadFactor = loadFactor;
        this.mTable = new Entry[initialCapacity];
        this.mThreshold = (int)((float)initialCapacity * loadFactor);
    }

    public SoftHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public SoftHashMap() {
        this(11, 0.75f);
    }

    public SoftHashMap(Map t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public int size() {
        return this.mCount;
    }

    @Override
    public boolean isEmpty() {
        return this.mCount == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            value = new Null();
        }
        Entry[] tab = this.mTable;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            Entry prev = null;
            while (e != null) {
                Object entryValue = e.getValue();
                if (entryValue == null) {
                    ++this.mModCount;
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[i] = e.mNext;
                    }
                    --this.mCount;
                } else {
                    if (value.equals(entryValue)) {
                        return true;
                    }
                    prev = e;
                }
                e = e.mNext;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        Entry[] tab = this.mTable;
        if (key != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e.getValue() == null) {
                    ++this.mModCount;
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[index] = e.mNext;
                    }
                    --this.mCount;
                } else {
                    if (e.mHash == hash && key.equals(e.mKey)) {
                        return true;
                    }
                    prev = e;
                }
                e = e.mNext;
            }
        } else {
            Entry e = tab[0];
            Entry prev = null;
            while (e != null) {
                if (e.getValue() == null) {
                    ++this.mModCount;
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[0] = e.mNext;
                    }
                    --this.mCount;
                } else {
                    if (e.mKey == null) {
                        return true;
                    }
                    prev = e;
                }
                e = e.mNext;
            }
        }
        return false;
    }

    public Object get(Object key) {
        Entry[] tab = this.mTable;
        if (key != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                Object entryValue = e.getValue();
                if (entryValue == null) {
                    ++this.mModCount;
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[index] = e.mNext;
                    }
                    --this.mCount;
                } else {
                    if (e.mHash == hash && key.equals(e.mKey)) {
                        return entryValue instanceof Null ? null : entryValue;
                    }
                    prev = e;
                }
                e = e.mNext;
            }
        } else {
            Entry e = tab[0];
            Entry prev = null;
            while (e != null) {
                Object entryValue = e.getValue();
                if (entryValue == null) {
                    ++this.mModCount;
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[0] = e.mNext;
                    }
                    --this.mCount;
                } else {
                    if (e.mKey == null) {
                        return entryValue instanceof Null ? null : entryValue;
                    }
                    prev = e;
                }
                e = e.mNext;
            }
        }
        return null;
    }

    private void cleanup() {
        Entry[] tab = this.mTable;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            Entry prev = null;
            while (e != null) {
                if (e.getValue() == null) {
                    ++this.mModCount;
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[i] = e.mNext;
                    }
                    --this.mCount;
                } else {
                    prev = e;
                }
                e = e.mNext;
            }
        }
    }

    private void rehash() {
        int oldCapacity = this.mTable.length;
        Entry[] oldMap = this.mTable;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.mModCount;
        this.mThreshold = (int)((float)newCapacity * this.mLoadFactor);
        this.mTable = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.mNext;
                if (e.getValue() == null) {
                    --this.mCount;
                    continue;
                }
                int index = (e.mHash & Integer.MAX_VALUE) % newCapacity;
                e.mNext = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public Object put(Object key, Object value) {
        Entry e;
        int index;
        int hash;
        if (value == null) {
            value = new Null();
        }
        Entry[] tab = this.mTable;
        if (key != null) {
            hash = key.hashCode();
            index = (hash & Integer.MAX_VALUE) % tab.length;
            e = tab[index];
            Entry prev = null;
            while (e != null) {
                Object entryValue = e.getValue();
                if (e.getValue() == null) {
                    ++this.mModCount;
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[index] = e.mNext;
                    }
                    --this.mCount;
                } else {
                    if (e.mHash == hash && key.equals(e.mKey)) {
                        e.setValue(value);
                        return entryValue instanceof Null ? null : entryValue;
                    }
                    prev = e;
                }
                e = e.mNext;
            }
        } else {
            hash = 0;
            index = 0;
            e = tab[0];
            Entry prev = null;
            while (e != null) {
                Object entryValue = e.getValue();
                if (entryValue == null) {
                    ++this.mModCount;
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[0] = e.mNext;
                    }
                    --this.mCount;
                } else {
                    if (e.mKey == null) {
                        e.setValue(value);
                        return entryValue instanceof Null ? null : entryValue;
                    }
                    prev = e;
                }
                e = e.mNext;
            }
        }
        ++this.mModCount;
        if (this.mCount >= this.mThreshold) {
            this.cleanup();
        }
        if (this.mCount >= this.mThreshold) {
            this.rehash();
            tab = this.mTable;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry(hash, key, value, tab[index]);
        ++this.mCount;
        return null;
    }

    public Object remove(Object key) {
        Entry[] tab = this.mTable;
        if (key != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                Object entryValue = e.getValue();
                if (entryValue == null) {
                    ++this.mModCount;
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[index] = e.mNext;
                    }
                    --this.mCount;
                } else {
                    if (e.mHash == hash && key.equals(e.mKey)) {
                        ++this.mModCount;
                        if (prev != null) {
                            prev.mNext = e.mNext;
                        } else {
                            tab[index] = e.mNext;
                        }
                        --this.mCount;
                        e.setValue((Object)null);
                        return entryValue instanceof Null ? null : entryValue;
                    }
                    prev = e;
                }
                e = e.mNext;
            }
        } else {
            Entry e = tab[0];
            Entry prev = null;
            while (e != null) {
                Object entryValue = e.getValue();
                if (entryValue == null) {
                    ++this.mModCount;
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[0] = e.mNext;
                    }
                    --this.mCount;
                } else {
                    if (e.mKey == null) {
                        ++this.mModCount;
                        if (prev != null) {
                            prev.mNext = e.mNext;
                        } else {
                            tab[0] = e.mNext;
                        }
                        --this.mCount;
                        e.setValue((Object)null);
                        return entryValue instanceof Null ? null : entryValue;
                    }
                    prev = e;
                }
                e = e.mNext;
            }
        }
        return null;
    }

    public void putAll(Map t) {
        for (Map.Entry e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        Entry[] tab = this.mTable;
        ++this.mModCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.mCount = 0;
    }

    @Override
    public Object clone() {
        try {
            SoftHashMap t = (SoftHashMap)super.clone();
            t.mTable = new Entry[this.mTable.length];
            int i = this.mTable.length;
            while (i-- > 0) {
                t.mTable[i] = this.mTable[i] != null ? (Entry)this.mTable[i].clone() : null;
            }
            t.mKeySet = null;
            t.mEntrySet = null;
            t.mValues = null;
            t.mModCount = 0;
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        if (this.mKeySet == null) {
            this.mKeySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return SoftHashMap.this.getHashIterator(0);
                }

                @Override
                public int size() {
                    return SoftHashMap.this.mCount;
                }

                @Override
                public boolean contains(Object o) {
                    return SoftHashMap.this.containsKey(o);
                }

                @Override
                public boolean remove(Object o) {
                    if (o == null) {
                        if (SoftHashMap.this.containsKey(null)) {
                            SoftHashMap.this.remove(null);
                            return true;
                        }
                        return false;
                    }
                    return SoftHashMap.this.remove(o) != null;
                }

                @Override
                public void clear() {
                    SoftHashMap.this.clear();
                }

                @Override
                public String toString() {
                    return IdentityMap.toString(this);
                }
            };
        }
        return this.mKeySet;
    }

    public Collection values() {
        if (this.mValues == null) {
            this.mValues = new AbstractCollection(){

                @Override
                public Iterator iterator() {
                    return SoftHashMap.this.getHashIterator(1);
                }

                @Override
                public int size() {
                    return SoftHashMap.this.mCount;
                }

                @Override
                public boolean contains(Object o) {
                    return SoftHashMap.this.containsValue(o);
                }

                @Override
                public void clear() {
                    SoftHashMap.this.clear();
                }

                @Override
                public String toString() {
                    return IdentityMap.toString(this);
                }
            };
        }
        return this.mValues;
    }

    public Set entrySet() {
        if (this.mEntrySet == null) {
            this.mEntrySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return SoftHashMap.this.getHashIterator(2);
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry[] tab = SoftHashMap.this.mTable;
                    int hash = key == null ? 0 : key.hashCode();
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    Entry prev = null;
                    while (e != null) {
                        Object entryValue = e.getValue();
                        if (entryValue == null) {
                            SoftHashMap.this.mModCount++;
                            if (prev != null) {
                                prev.mNext = e.mNext;
                            } else {
                                tab[index] = e.mNext;
                            }
                            SoftHashMap.this.mCount--;
                        } else {
                            if (e.mHash == hash && e.equals(entry)) {
                                return true;
                            }
                            prev = e;
                        }
                        e = e.mNext;
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry[] tab = SoftHashMap.this.mTable;
                    int hash = key == null ? 0 : key.hashCode();
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    Entry prev = null;
                    while (e != null) {
                        Object entryValue = e.getValue();
                        if (entryValue == null) {
                            SoftHashMap.this.mModCount++;
                            if (prev != null) {
                                prev.mNext = e.mNext;
                            } else {
                                tab[index] = e.mNext;
                            }
                            SoftHashMap.this.mCount--;
                        } else {
                            if (e.mHash == hash && e.equals(entry)) {
                                SoftHashMap.this.mModCount++;
                                if (prev != null) {
                                    prev.mNext = e.mNext;
                                } else {
                                    tab[index] = e.mNext;
                                }
                                SoftHashMap.this.mCount--;
                                e.setValue((Object)null);
                                return true;
                            }
                            prev = e;
                        }
                        e = e.mNext;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return SoftHashMap.this.mCount;
                }

                @Override
                public void clear() {
                    SoftHashMap.this.clear();
                }

                @Override
                public String toString() {
                    return IdentityMap.toString(this);
                }
            };
        }
        return this.mEntrySet;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.entrySet().iterator();
        buf.append("{");
        int i = 0;
        while (it.hasNext()) {
            if (i > 0) {
                buf.append(", ");
            }
            Map.Entry e = (Map.Entry)it.next();
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    private Iterator getHashIterator(int type) {
        if (this.mCount == 0) {
            return IdentityMap.cEmptyHashIterator;
        }
        return new HashIterator(type);
    }

    static class Null {
        Null() {
        }

        public boolean equals(Object other) {
            return other == null || other instanceof Null;
        }

        public String toString() {
            return "null";
        }
    }

    private class HashIterator
    implements Iterator {
        private Entry[] mTable;
        private int mIndex;
        private Entry mEntry;
        private Object mEntryValue;
        private Entry mLastReturned;
        private int mType;
        private int expectedModCount;

        HashIterator(int type) {
            this.mTable = SoftHashMap.this.mTable;
            this.mIndex = this.mTable.length;
            this.expectedModCount = SoftHashMap.this.mModCount;
            this.mType = type;
        }

        @Override
        public boolean hasNext() {
            while (this.mEntry == null || (this.mEntryValue = this.mEntry.getValue()) == null) {
                if (this.mEntry != null) {
                    this.remove(this.mEntry);
                    this.mEntry = this.mEntry.mNext;
                }
                if (this.mEntry != null) continue;
                if (this.mIndex <= 0) {
                    return false;
                }
                this.mEntry = this.mTable[--this.mIndex];
            }
            return true;
        }

        public Object next() {
            if (SoftHashMap.this.mModCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.mLastReturned = this.mEntry;
            this.mEntry = this.mEntry.mNext;
            if (this.mType == 0) {
                return this.mLastReturned.getKey();
            }
            if (this.mType == 1) {
                Object value = this.mLastReturned.getValue();
                return value instanceof Null ? null : value;
            }
            return this.mLastReturned;
        }

        @Override
        public void remove() {
            if (this.mLastReturned == null) {
                throw new IllegalStateException();
            }
            if (SoftHashMap.this.mModCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.remove(this.mLastReturned);
            this.mLastReturned = null;
        }

        private void remove(Entry toRemove) {
            Entry[] tab = this.mTable;
            int index = (toRemove.mHash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e == toRemove) {
                    SoftHashMap.this.mModCount++;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[index] = e.mNext;
                    } else {
                        prev.mNext = e.mNext;
                    }
                    SoftHashMap.this.mCount--;
                    return;
                }
                prev = e;
                e = e.mNext;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class Entry
    implements Map.Entry {
        int mHash;
        Object mKey;
        Entry mNext;
        private Reference mValue;

        Entry(int hash, Object key, Object value, Entry next) {
            this.mHash = hash;
            this.mKey = key;
            this.mValue = new SoftReference<Object>(value);
            this.mNext = next;
        }

        private Entry(int hash, Object key, Reference value, Entry next) {
            this.mHash = hash;
            this.mKey = key;
            this.mValue = value;
            this.mNext = next;
        }

        protected Object clone() {
            return new Entry(this.mHash, this.mKey, this.mValue, this.mNext == null ? null : (Entry)this.mNext.clone());
        }

        public Object getKey() {
            return this.mKey;
        }

        public Object getValue() {
            return this.mValue.get();
        }

        public Object setValue(Object value) {
            Object oldValue = this.getValue();
            if (value == null) {
                this.mValue.clear();
            } else {
                this.mValue = new SoftReference<Object>(value);
            }
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = this.getValue();
            return (this.mKey == null ? e.getKey() == null : this.mKey.equals(e.getKey())) && (value == null ? e.getValue() == null : value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            Object value = this.getValue();
            return this.mHash ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.mKey + "=" + this.getValue();
        }
    }
}

