/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.teatrove.trove.util.AbstractMapEntry;

public class NullKeyMap
extends AbstractMap
implements Serializable {
    private static final Object NULL = new Serializable(){};
    private Map mMap;
    private transient Set mKeySet;
    private transient Set mEntrySet;

    public NullKeyMap(Map map) {
        this.mMap = map;
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key == null ? this.mMap.containsKey(NULL) : this.mMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return key == null ? this.mMap.get(NULL) : this.mMap.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.mMap.put(key == null ? NULL : key, value);
    }

    @Override
    public Object remove(Object key) {
        return key == null ? this.mMap.remove(NULL) : this.mMap.remove(key);
    }

    @Override
    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.mMap.clear();
    }

    @Override
    public Set keySet() {
        if (this.mKeySet == null) {
            this.mKeySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    final Iterator it = NullKeyMap.this.mMap.keySet().iterator();
                    return new Iterator(){

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        public Object next() {
                            Object key = it.next();
                            return key == NULL ? null : key;
                        }

                        @Override
                        public void remove() {
                            it.remove();
                        }
                    };
                }

                @Override
                public boolean contains(Object key) {
                    return NullKeyMap.this.containsKey(key == null ? NULL : key);
                }

                @Override
                public boolean remove(Object key) {
                    if (key == null) {
                        key = NULL;
                    }
                    if (NullKeyMap.this.containsKey(key)) {
                        NullKeyMap.this.remove(key);
                        return true;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return NullKeyMap.this.size();
                }

                @Override
                public void clear() {
                    NullKeyMap.this.clear();
                }
            };
        }
        return this.mKeySet;
    }

    @Override
    public Collection values() {
        return this.mMap.values();
    }

    @Override
    public Set entrySet() {
        if (this.mEntrySet == null) {
            this.mEntrySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    final Iterator it = NullKeyMap.this.mMap.entrySet().iterator();
                    return new Iterator(){

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        public Object next() {
                            final Map.Entry entry = (Map.Entry)it.next();
                            if (entry.getKey() == NULL) {
                                return new AbstractMapEntry(){

                                    public Object getKey() {
                                        return null;
                                    }

                                    public Object getValue() {
                                        return entry.getValue();
                                    }

                                    @Override
                                    public Object setValue(Object value) {
                                        return entry.setValue(value);
                                    }
                                };
                            }
                            return entry;
                        }

                        @Override
                        public void remove() {
                            it.remove();
                        }
                    };
                }

                @Override
                public boolean contains(Object obj) {
                    Object lookup;
                    if (!(obj instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)obj;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (key == null) {
                        key = NULL;
                    }
                    if ((lookup = NullKeyMap.this.get(key)) == null) {
                        return value == null;
                    }
                    return lookup.equals(value);
                }

                @Override
                public boolean remove(Object obj) {
                    if (!(obj instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)obj;
                    Object key = entry.getKey();
                    if (key == null) {
                        key = NULL;
                    }
                    if (NullKeyMap.this.containsKey(key)) {
                        NullKeyMap.this.remove(key);
                        return true;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return NullKeyMap.this.size();
                }

                @Override
                public void clear() {
                    NullKeyMap.this.clear();
                }
            };
        }
        return this.mEntrySet;
    }
}

