/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

public final class IntegerFactory {
    private static final Integer[] CACHE;
    private static final int CACHE_MASK;

    public static Integer toInteger(int value) {
        Integer[] cache = CACHE;
        int index = value & CACHE_MASK;
        Integer v = cache[index];
        if (v == null || v != value) {
            cache[index] = v = new Integer(value);
        }
        return v;
    }

    private IntegerFactory() {
    }

    static {
        Integer i = Integer.getInteger("org.teatrove.trove.util.IntegerFactory.capacity");
        int cacheSize = i == null ? 1024 : i;
        --cacheSize;
        int shift = 0;
        while (cacheSize > 0) {
            ++shift;
            cacheSize >>= 1;
        }
        cacheSize = 1 << shift;
        CACHE = new Integer[cacheSize];
        CACHE_MASK = cacheSize - 1;
    }
}

