/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.teatrove.trove.util.Deflater;

public class DeflaterOutputStream
extends FilterOutputStream {
    protected Deflater mDeflater;
    protected byte[] mBuffer;

    public DeflaterOutputStream(OutputStream out, Deflater def, byte[] buf) {
        super(out);
        this.mDeflater = def;
        this.mBuffer = buf;
    }

    public DeflaterOutputStream(OutputStream out, Deflater def, int size) {
        this(out, def, new byte[size]);
    }

    public DeflaterOutputStream(OutputStream out, Deflater def) {
        this(out, def, 512);
    }

    public DeflaterOutputStream(OutputStream out) {
        this(out, new Deflater());
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.mDeflater.finished()) {
            throw new IOException("write beyond end of stream");
        }
        this.mDeflater.setInput(b, off, len);
        while (!this.mDeflater.needsInput()) {
            this.deflate();
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.mDeflater.finished()) {
            int len;
            this.mDeflater.flush();
            while ((len = this.deflate()) == this.mBuffer.length) {
            }
        }
    }

    public void fullFlush() throws IOException {
        if (!this.mDeflater.finished()) {
            int len;
            this.mDeflater.fullFlush();
            while ((len = this.deflate()) == this.mBuffer.length) {
            }
        }
    }

    public void finish() throws IOException {
        if (!this.mDeflater.finished()) {
            this.mDeflater.finish();
            do {
                this.deflate();
            } while (!this.mDeflater.finished());
        }
    }

    @Override
    public void close() throws IOException {
        this.finish();
        super.close();
    }

    private int deflate() throws IOException {
        int len = this.mDeflater.deflate(this.mBuffer, 0, this.mBuffer.length);
        if (len > 0) {
            this.out.write(this.mBuffer, 0, len);
        }
        return len;
    }
}

