/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentLinkedList<E> {
    protected AtomicInteger mSize = new AtomicInteger(0);
    protected Node mHead = null;
    protected Node mTail = null;
    protected final ReentrantLock mPollLock = new ReentrantLock();
    protected final ReentrantLock mPutLock = new ReentrantLock();
    private SimpleObjectPool mNodePool = new SimpleObjectPool();

    public ConcurrentLinkedList() {
        this.mHead = new Node<Object>(null);
        this.mTail = new Node<Object>(null);
        this.mHead.mNext = this.mTail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node<E> offerAndGetNode(E e) {
        this.mPutLock.lock();
        try {
            Node<E> newNode = this.mNodePool.borrowNode(e);
            if (this.mSize.get() > 0) {
                newNode.mPrev = this.mTail;
            }
            this.mTail.mNext = newNode;
            if (this.mSize.get() <= 1) {
                this.mPollLock.lock();
                try {
                    this.mHead.mNext = this.mSize.get() == 0 ? newNode : newNode.mPrev;
                }
                finally {
                    this.mPollLock.unlock();
                }
            }
            this.mSize.incrementAndGet();
            this.mTail = newNode;
            Node<E> node = newNode;
            return node;
        }
        finally {
            this.mPutLock.unlock();
        }
    }

    public int size() {
        return this.mSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.mPutLock.lock();
        this.mPollLock.lock();
        try {
            this.mSize.set(0);
            this.mHead = new Node<Object>(null);
            this.mTail = new Node<Object>(null);
            this.mHead.mNext = this.mTail;
        }
        finally {
            this.mPollLock.unlock();
            this.mPutLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveToTail(Node<E> e) {
        this.mPutLock.lock();
        try {
            this.mPollLock.lock();
            try {
                if (e == null) {
                    boolean bl = false;
                    return bl;
                }
                if (e.mRemoved) {
                    boolean bl = false;
                    return bl;
                }
                if (this.mSize.get() == 0) {
                    boolean bl = false;
                    return bl;
                }
                if (e == this.mTail) {
                    boolean bl = true;
                    return bl;
                }
                if (e.mPrev == null || e.mNext == null) {
                    boolean bl = false;
                    return bl;
                }
                e.mPrev.mNext = e.mNext;
                e.mNext.mPrev = e.mPrev;
            }
            finally {
                this.mPollLock.unlock();
            }
            if (this.mSize.get() > 0) {
                e.mPrev = this.mTail;
            }
            this.mTail.mNext = e;
            if (this.mSize.get() <= 1) {
                this.mPollLock.lock();
                try {
                    this.mHead.mNext = this.mSize.get() == 0 ? e : e.mPrev;
                }
                finally {
                    this.mPollLock.unlock();
                }
            }
            this.mTail = e;
            boolean bl = true;
            return bl;
        }
        finally {
            this.mPutLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Node<E> e) {
        this.mPutLock.lock();
        this.mPollLock.lock();
        try {
            if (e == null) {
                boolean bl = false;
                return bl;
            }
            if (e.mRemoved) {
                boolean bl = false;
                return bl;
            }
            if (this.mSize.get() == 0) {
                boolean bl = false;
                return bl;
            }
            if (e == this.mTail) {
                this.removeTail();
                boolean bl = true;
                return bl;
            }
            if (e == this.mHead.mNext) {
                this.removeHead();
                boolean bl = true;
                return bl;
            }
            if (this.mSize.get() < 3) {
                boolean bl = false;
                return bl;
            }
            if (e.mPrev == null || e.mNext == null) {
                boolean bl = false;
                return bl;
            }
            e.mPrev.mNext = e.mNext;
            e.mNext.mPrev = e.mPrev;
            e.mRemoved = true;
            this.mSize.decrementAndGet();
            this.mNodePool.returnNode(e);
            boolean bl = true;
            return bl;
        }
        finally {
            this.mPollLock.unlock();
            this.mPutLock.unlock();
        }
    }

    private void removeTail() {
        Node e = this.mTail;
        if (this.mTail.mPrev == null) {
            this.mTail = new Node<Object>(null);
            this.mHead.mNext = this.mTail;
            this.mSize.set(0);
        } else {
            this.mTail = this.mTail.mPrev;
            this.mSize.decrementAndGet();
            this.mTail.mNext = null;
            e.mRemoved = true;
            this.mNodePool.returnNode(e);
        }
    }

    private E removeHead() {
        E value = null;
        if (this.mHead.mNext != null) {
            Node e = this.mHead.mNext;
            this.mHead.mNext = e.mNext;
            if (this.mHead.mNext != null) {
                this.mHead.mNext.mPrev = null;
            }
            e.mRemoved = true;
            value = e.mEntry;
            this.mNodePool.returnNode(e);
        } else {
            this.mHead.mNext = this.mTail;
        }
        this.mSize.decrementAndGet();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E poll() {
        if (this.mSize.get() == 0) {
            return null;
        }
        this.mPollLock.lock();
        try {
            E e = this.removeHead();
            return e;
        }
        finally {
            this.mPollLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void integrityCheck() {
        this.mPutLock.lock();
        this.mPollLock.lock();
        try {
            if (this.mSize.get() == 0 && this.mHead.mNext != this.mTail) {
                return;
            }
            Node a = this.mHead.mNext;
            int i = 0;
            for (i = 0; i < this.mSize.get() - 1; ++i) {
                if (a == null) {
                    throw new IllegalArgumentException("Null found during forward traversal");
                }
                a = a.mNext;
            }
            if (a != this.mTail) {
                throw new IllegalArgumentException("Last item in the list should be the tail, scount = " + i + ", item = " + a + ", tail = " + this.mTail);
            }
            a = this.mTail;
            for (i = 0; i < this.mSize.get() - 1; ++i) {
                if (a == null) {
                    throw new IllegalArgumentException("Null found during forward traversal");
                }
                a = a.mPrev;
            }
            if (a != this.mHead.mNext) {
                throw new IllegalArgumentException("First item in the list should be the head, count = " + i + ", item = " + a + ", head = " + this.mHead.mNext);
            }
        }
        finally {
            this.mPollLock.unlock();
            this.mPutLock.unlock();
        }
    }

    private static class SimpleObjectPool<E> {
        private static final int POOL_MAX_SIZE = 100;
        private LinkedBlockingQueue<Node<E>> mPool = new LinkedBlockingQueue(100);

        private SimpleObjectPool() {
        }

        public Node<E> borrowNode(E e) {
            Node<E> o = this.mPool.poll();
            if (o == null) {
                return new Node<E>(e);
            }
            o.mEntry = e;
            return o;
        }

        public void returnNode(Node<E> e) {
            e.mNext = null;
            e.mPrev = null;
            e.mRemoved = false;
            e.mEntry = null;
            this.mPool.offer(e);
        }
    }

    public static class Node<E> {
        E mEntry;
        Node mNext = null;
        Node mPrev = null;
        volatile boolean mRemoved = false;

        Node(E e) {
            this.mEntry = e;
        }

        public E getValue() {
            return this.mEntry;
        }

        public String toString() {
            return "This = " + (this.mEntry != null ? this.mEntry.toString() : "null") + ", next = " + (this.mNext != null && this.mNext.mEntry != null ? this.mNext.mEntry.toString() : "null") + ", prev = " + (this.mPrev != null && this.mPrev.mEntry != null ? this.mPrev.mEntry.toString() : "null");
        }
    }
}

