/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.Stack;
import org.teatrove.trove.net.CheckedSocket;
import org.teatrove.trove.net.InetAddressAndPort;
import org.teatrove.trove.net.SocketFace;
import org.teatrove.trove.net.SocketFactory;

public class PooledSocketFactory
implements SocketFactory {
    private final SocketFactory mFactory;
    private final long mTimeout;
    private final Stack mPool = new Stack();
    private CheckedSocket.ExceptionListener mListener;

    public PooledSocketFactory(SocketFactory factory) {
        this(factory, factory.getDefaultTimeout());
    }

    public PooledSocketFactory(SocketFactory factory, int maxPoolSize) {
        this(factory);
    }

    public PooledSocketFactory(SocketFactory factory, long timeout) {
        this.mFactory = factory;
        this.mTimeout = timeout;
        this.mListener = new CheckedSocket.ExceptionListener(){

            @Override
            public void exceptionOccurred(CheckedSocket s, Exception e, int count) {
                if (count == 1) {
                    PooledSocketFactory.this.clear();
                }
            }
        };
    }

    @Override
    public InetAddressAndPort getInetAddressAndPort() {
        return this.mFactory.getInetAddressAndPort();
    }

    @Override
    public InetAddressAndPort getInetAddressAndPort(Object session) {
        return this.mFactory.getInetAddressAndPort();
    }

    @Override
    public long getDefaultTimeout() {
        return this.mTimeout;
    }

    @Override
    public CheckedSocket createSocket() throws ConnectException, SocketException {
        return this.createSocket(null, this.mTimeout);
    }

    @Override
    public CheckedSocket createSocket(Object session) throws ConnectException, SocketException {
        return this.createSocket(this.mTimeout);
    }

    @Override
    public CheckedSocket createSocket(long timeout) throws ConnectException, SocketException {
        return new PooledSocket(this.mFactory.createSocket(timeout));
    }

    @Override
    public CheckedSocket createSocket(Object session, long timeout) throws ConnectException, SocketException {
        return this.createSocket(timeout);
    }

    @Override
    public CheckedSocket getSocket() throws ConnectException, SocketException {
        return this.getSocket(this.mTimeout);
    }

    @Override
    public CheckedSocket getSocket(Object session) throws ConnectException, SocketException {
        return this.getSocket(this.mTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckedSocket getSocket(long timeout) throws ConnectException, SocketException {
        Stack stack = this.mPool;
        synchronized (stack) {
            if (this.mPool.size() > 0) {
                return new PooledSocket((SocketFace)this.mPool.pop());
            }
        }
        return new PooledSocket(this.mFactory.createSocket(timeout));
    }

    @Override
    public CheckedSocket getSocket(Object session, long timeout) throws ConnectException, SocketException {
        return this.getSocket(timeout);
    }

    @Override
    public void recycleSocket(CheckedSocket socket) throws SocketException, IllegalArgumentException {
        if (socket != null) {
            PooledSocket psock;
            if (socket instanceof PooledSocket && (psock = (PooledSocket)socket).getOwner() == this) {
                psock.removeExceptionListener(this.mListener);
                SocketFace s = psock.recycle();
                if (s != null) {
                    this.mPool.push(s);
                }
                return;
            }
            throw new IllegalArgumentException("Socket did not originate from this pool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Stack stack = this.mPool;
        synchronized (stack) {
            while (this.mPool.size() > 0) {
                try {
                    ((SocketFace)this.mPool.pop()).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public int getAvailableCount() {
        return this.mPool.size();
    }

    private class PooledSocket
    extends CheckedSocket {
        private InputStream mIn;
        private OutputStream mOut;
        private boolean mClosed;

        public PooledSocket(SocketFace s) throws SocketException {
            super(s);
            this.addExceptionListener(PooledSocketFactory.this.mListener);
        }

        @Override
        public synchronized InputStream getInputStream() throws IOException {
            if (this.mIn != null) {
                return this.mIn;
            }
            final InputStream mStream = super.getInputStream();
            this.mIn = new InputStream(){

                @Override
                public int read() throws IOException {
                    PooledSocket.this.check();
                    return mStream.read();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    PooledSocket.this.check();
                    return mStream.read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    PooledSocket.this.check();
                    return mStream.read(b, off, len);
                }

                @Override
                public long skip(long n) throws IOException {
                    PooledSocket.this.check();
                    return mStream.skip(n);
                }

                @Override
                public int available() throws IOException {
                    PooledSocket.this.check();
                    return mStream.available();
                }

                @Override
                public void close() throws IOException {
                    if (PooledSocket.this.doClose()) {
                        mStream.close();
                    }
                }

                @Override
                public void mark(int readlimit) {
                    mStream.mark(readlimit);
                }

                @Override
                public void reset() throws IOException {
                    PooledSocket.this.check();
                    mStream.reset();
                }

                @Override
                public boolean markSupported() {
                    return mStream.markSupported();
                }
            };
            return this.mIn;
        }

        @Override
        public synchronized OutputStream getOutputStream() throws IOException {
            if (this.mOut != null) {
                return this.mOut;
            }
            final OutputStream mStream = super.getOutputStream();
            this.mOut = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    PooledSocket.this.check();
                    mStream.write(b);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    PooledSocket.this.check();
                    mStream.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    PooledSocket.this.check();
                    mStream.write(b, off, len);
                }

                @Override
                public void flush() throws IOException {
                    PooledSocket.this.check();
                    mStream.flush();
                }

                @Override
                public void close() throws IOException {
                    if (PooledSocket.this.doClose()) {
                        mStream.close();
                    }
                }
            };
            return this.mOut;
        }

        @Override
        public void setTcpNoDelay(boolean on) throws SocketException {
            this.check();
            super.setTcpNoDelay(on);
        }

        @Override
        public boolean getTcpNoDelay() throws SocketException {
            this.check();
            return super.getTcpNoDelay();
        }

        @Override
        public void setSoLinger(boolean on, int linger) throws SocketException {
            this.check();
            super.setSoLinger(on, linger);
        }

        @Override
        public int getSoLinger() throws SocketException {
            this.check();
            return super.getSoLinger();
        }

        @Override
        public void setSoTimeout(int timeout) throws SocketException {
            this.check();
            super.setSoTimeout(timeout);
        }

        @Override
        public int getSoTimeout() throws SocketException {
            this.check();
            return super.getSoTimeout();
        }

        @Override
        public void setSendBufferSize(int size) throws SocketException {
            this.check();
            super.setSendBufferSize(size);
        }

        @Override
        public int getSendBufferSize() throws SocketException {
            this.check();
            return super.getSendBufferSize();
        }

        @Override
        public void setReceiveBufferSize(int size) throws SocketException {
            this.check();
            super.setReceiveBufferSize(size);
        }

        @Override
        public int getReceiveBufferSize() throws SocketException {
            this.check();
            return super.getReceiveBufferSize();
        }

        @Override
        public void close() throws IOException {
            if (this.doClose()) {
                super.close();
            }
        }

        SocketFactory getOwner() {
            return PooledSocketFactory.this;
        }

        SocketFace recycle() throws SocketException {
            if (this.mClosed) {
                return null;
            }
            if (this.getExceptionCount() != 0) {
                try {
                    this.close();
                }
                catch (IOException e) {
                    throw new SocketException(e.getMessage());
                }
                return null;
            }
            this.mClosed = true;
            return this.mSocket;
        }

        boolean doClose() {
            return this.mClosed ? false : (this.mClosed = true);
        }

        void check() throws SocketException {
            if (this.mClosed) {
                throw new SocketException("Socket closed");
            }
        }
    }
}

