/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.teatrove.trove.net.CheckedSocket;
import org.teatrove.trove.net.InetAddressAndPort;
import org.teatrove.trove.net.SocketConnector;
import org.teatrove.trove.net.SocketFactory;

public class PlainSocketFactory
implements SocketFactory {
    protected final InetAddress mAddr;
    protected final int mPort;
    protected final InetAddress mLocalAddr;
    protected final int mLocalPort;
    protected final long mTimeout;

    public PlainSocketFactory(InetAddress addr, int port, long timeout) {
        this.mAddr = addr;
        this.mPort = port;
        this.mLocalAddr = null;
        this.mLocalPort = 0;
        this.mTimeout = timeout;
    }

    public PlainSocketFactory(InetAddress addr, int port, InetAddress localAddr, int localPort, long timeout) {
        this.mAddr = addr;
        this.mPort = port;
        this.mLocalAddr = localAddr;
        this.mLocalPort = localPort;
        this.mTimeout = timeout;
    }

    @Override
    public InetAddressAndPort getInetAddressAndPort() {
        return new InetAddressAndPort(this.mAddr, this.mPort);
    }

    @Override
    public InetAddressAndPort getInetAddressAndPort(Object session) {
        return this.getInetAddressAndPort();
    }

    @Override
    public long getDefaultTimeout() {
        return this.mTimeout;
    }

    @Override
    public CheckedSocket createSocket() throws ConnectException, SocketException {
        return this.createSocket(this.mTimeout);
    }

    @Override
    public CheckedSocket createSocket(Object session) throws ConnectException, SocketException {
        return this.createSocket(this.mTimeout);
    }

    @Override
    public CheckedSocket createSocket(long timeout) throws ConnectException, SocketException {
        Socket socket = SocketConnector.connect(this.mAddr, this.mPort, this.mLocalAddr, this.mLocalPort, timeout);
        if (socket == null) {
            throw new ConnectException("Connect timeout expired: " + timeout);
        }
        return CheckedSocket.check(socket);
    }

    @Override
    public CheckedSocket createSocket(Object session, long timeout) throws ConnectException, SocketException {
        return this.createSocket(timeout);
    }

    @Override
    public CheckedSocket getSocket() throws ConnectException, SocketException {
        return this.createSocket(this.mTimeout);
    }

    @Override
    public CheckedSocket getSocket(Object session) throws ConnectException, SocketException {
        return this.createSocket(this.mTimeout);
    }

    @Override
    public CheckedSocket getSocket(long timeout) throws ConnectException, SocketException {
        return this.createSocket(timeout);
    }

    @Override
    public CheckedSocket getSocket(Object session, long timeout) throws ConnectException, SocketException {
        return this.createSocket(timeout);
    }

    @Override
    public void recycleSocket(CheckedSocket socket) throws SocketException, IllegalArgumentException {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                throw new SocketException(e.getMessage());
            }
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public int getAvailableCount() {
        return 0;
    }
}

