/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.teatrove.trove.net.CheckedInterruptedIOException;
import org.teatrove.trove.net.CheckedSocketException;
import org.teatrove.trove.net.SocketFace;
import org.teatrove.trove.net.SocketFaceWrapper;

public class CheckedSocket
extends SocketFaceWrapper {
    private int mExceptionCount;
    private InputStream mIn;
    private OutputStream mOut;
    private Set mExceptionListeners;

    public static CheckedSocket check(SocketFace socket) throws SocketException {
        if (socket instanceof CheckedSocket) {
            return (CheckedSocket)socket;
        }
        return new CheckedSocket(socket);
    }

    public static CheckedSocket check(Socket socket) throws SocketException {
        return new CheckedSocket(socket);
    }

    protected CheckedSocket(SocketFace socket) throws SocketException {
        super(socket);
    }

    protected CheckedSocket(Socket socket) throws SocketException {
        super(socket);
    }

    public int getExceptionCount() {
        return this.mExceptionCount;
    }

    public synchronized void addExceptionListener(ExceptionListener listener) {
        if (this.mExceptionListeners == null) {
            this.mExceptionListeners = new HashSet();
        }
        this.mExceptionListeners.add(listener);
    }

    public synchronized void removeExceptionListener(ExceptionListener listener) {
        if (this.mExceptionListeners != null) {
            this.mExceptionListeners.remove(listener);
        }
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.mIn != null) {
            return this.mIn;
        }
        try {
            this.mIn = new Input(super.getInputStream());
            return this.mIn;
        }
        catch (Exception e) {
            throw this.handleIOException(e);
        }
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.mOut != null) {
            return this.mOut;
        }
        try {
            this.mOut = new Output(super.getOutputStream());
            return this.mOut;
        }
        catch (Exception e) {
            throw this.handleIOException(e);
        }
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        try {
            super.setTcpNoDelay(on);
        }
        catch (Exception e) {
            throw this.handleSocketException(e);
        }
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        try {
            return super.getTcpNoDelay();
        }
        catch (Exception e) {
            throw this.handleSocketException(e);
        }
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        try {
            super.setSoLinger(on, linger);
        }
        catch (Exception e) {
            throw this.handleSocketException(e);
        }
    }

    @Override
    public int getSoLinger() throws SocketException {
        try {
            return super.getSoLinger();
        }
        catch (Exception e) {
            throw this.handleSocketException(e);
        }
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        try {
            super.setSoTimeout(timeout);
        }
        catch (Exception e) {
            throw this.handleSocketException(e);
        }
    }

    @Override
    public int getSoTimeout() throws SocketException {
        try {
            return super.getSoTimeout();
        }
        catch (Exception e) {
            throw this.handleSocketException(e);
        }
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        try {
            super.setSendBufferSize(size);
        }
        catch (Exception e) {
            throw this.handleSocketException(e);
        }
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        try {
            return super.getSendBufferSize();
        }
        catch (Exception e) {
            throw this.handleSocketException(e);
        }
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        try {
            super.setReceiveBufferSize(size);
        }
        catch (Exception e) {
            throw this.handleSocketException(e);
        }
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        try {
            return super.getReceiveBufferSize();
        }
        catch (Exception e) {
            throw this.handleSocketException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (Exception e) {
            throw this.handleIOException(e);
        }
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        try {
            super.setKeepAlive(on);
        }
        catch (Exception e) {
            throw this.handleSocketException(e);
        }
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        try {
            return super.getKeepAlive();
        }
        catch (Exception e) {
            throw this.handleSocketException(e);
        }
    }

    @Override
    public void shutdownInput() throws IOException {
        try {
            super.shutdownInput();
        }
        catch (Exception e) {
            throw this.handleIOException(e);
        }
    }

    @Override
    public void shutdownOutput() throws IOException {
        try {
            super.shutdownOutput();
        }
        catch (Exception e) {
            throw this.handleIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IOException handleIOException(Exception e) {
        int count;
        if (e instanceof InterruptedIOException) {
            return CheckedInterruptedIOException.create((InterruptedIOException)e, this.mSocket);
        }
        CheckedSocket checkedSocket = this;
        synchronized (checkedSocket) {
            count = ++this.mExceptionCount;
        }
        this.exceptionOccurred(e, count);
        if (e instanceof CheckedSocketException) {
            return (CheckedSocketException)e;
        }
        if (e instanceof NullPointerException) {
            return CheckedSocketException.create(e, this.mSocket, "Socket closed");
        }
        return CheckedSocketException.create(e, this.mSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SocketException handleSocketException(Exception e) {
        int count;
        CheckedSocket checkedSocket = this;
        synchronized (checkedSocket) {
            count = ++this.mExceptionCount;
        }
        this.exceptionOccurred(e, count);
        if (e instanceof CheckedSocketException) {
            return (CheckedSocketException)e;
        }
        if (e instanceof NullPointerException) {
            return CheckedSocketException.create(e, this.mSocket, "Socket closed");
        }
        return CheckedSocketException.create(e, this.mSocket);
    }

    private synchronized void exceptionOccurred(Exception e, int count) {
        if (this.mExceptionListeners != null) {
            Iterator it = this.mExceptionListeners.iterator();
            while (it.hasNext()) {
                ((ExceptionListener)it.next()).exceptionOccurred(this, e, count);
            }
        }
    }

    private class Output
    extends OutputStream {
        private final OutputStream mStream;

        public Output(OutputStream out) {
            this.mStream = out;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.mStream.write(b);
            }
            catch (IOException e) {
                throw CheckedSocket.this.handleIOException(e);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            try {
                this.mStream.write(b);
            }
            catch (IOException e) {
                throw CheckedSocket.this.handleIOException(e);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.mStream.write(b, off, len);
            }
            catch (IOException e) {
                throw CheckedSocket.this.handleIOException(e);
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                this.mStream.flush();
            }
            catch (IOException e) {
                throw CheckedSocket.this.handleIOException(e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.mStream.close();
            }
            catch (IOException e) {
                throw CheckedSocket.this.handleIOException(e);
            }
        }
    }

    private class Input
    extends InputStream {
        private final InputStream mStream;

        public Input(InputStream in) {
            this.mStream = in;
        }

        @Override
        public int read() throws IOException {
            try {
                return this.mStream.read();
            }
            catch (IOException e) {
                throw CheckedSocket.this.handleIOException(e);
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            try {
                return this.mStream.read(b);
            }
            catch (IOException e) {
                throw CheckedSocket.this.handleIOException(e);
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                return this.mStream.read(b, off, len);
            }
            catch (IOException e) {
                throw CheckedSocket.this.handleIOException(e);
            }
        }

        @Override
        public long skip(long n) throws IOException {
            try {
                return this.mStream.skip(n);
            }
            catch (IOException e) {
                throw CheckedSocket.this.handleIOException(e);
            }
        }

        @Override
        public int available() throws IOException {
            try {
                return this.mStream.available();
            }
            catch (IOException e) {
                throw CheckedSocket.this.handleIOException(e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.mStream.close();
            }
            catch (IOException e) {
                throw CheckedSocket.this.handleIOException(e);
            }
        }

        @Override
        public void mark(int readlimit) {
            this.mStream.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            try {
                this.mStream.reset();
            }
            catch (IOException e) {
                throw CheckedSocket.this.handleIOException(e);
            }
        }

        @Override
        public boolean markSupported() {
            return this.mStream.markSupported();
        }
    }

    public static interface ExceptionListener {
        public void exceptionOccurred(CheckedSocket var1, Exception var2, int var3);
    }
}

