/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.teatrove.trove.io.FastBufferedInputStream;
import org.teatrove.trove.io.FastBufferedOutputStream;
import org.teatrove.trove.net.SocketFace;
import org.teatrove.trove.net.SocketFaceWrapper;

public class BufferedSocket
extends SocketFaceWrapper {
    private final int mInBufSize;
    private final int mOutBufSize;
    private InputStream mIn;
    private OutputStream mOut;

    public BufferedSocket(Socket s) throws IOException {
        this(s, -1, -1);
    }

    public BufferedSocket(SocketFace s) throws IOException {
        this(s, -1, -1);
    }

    public BufferedSocket(Socket s, int inputBufferSize, int outputBufferSize) throws IOException {
        super(s);
        this.mInBufSize = inputBufferSize;
        this.mOutBufSize = outputBufferSize;
    }

    public BufferedSocket(SocketFace s, int inputBufferSize, int outputBufferSize) throws IOException {
        super(s);
        this.mInBufSize = inputBufferSize;
        this.mOutBufSize = outputBufferSize;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.mIn == null) {
            InputStream in = super.getInputStream();
            this.mIn = this.mInBufSize < 0 ? new FastBufferedInputStream(in) : (this.mInBufSize > 0 ? new FastBufferedInputStream(in, this.mInBufSize) : in);
        }
        return this.mIn;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.mOut == null) {
            OutputStream out = super.getOutputStream();
            this.mOut = this.mOutBufSize < 0 ? new FastBufferedOutputStream(out) : (this.mOutBufSize > 0 ? new FastBufferedOutputStream(out, this.mOutBufSize) : out);
        }
        return this.mOut;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.mOutBufSize != 0 && this.mOut != null) {
            this.mOut.close();
        }
        super.close();
    }
}

