/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.log;

import java.io.IOException;
import java.io.ObjectOutput;
import org.teatrove.trove.log.LogEvent;
import org.teatrove.trove.log.LogListener;

public class LogSerializer
implements LogListener {
    private ObjectOutput mOut;
    private LogEvent mCurrentEvent;

    public LogSerializer(ObjectOutput out) {
        this.mOut = out;
    }

    @Override
    public void logMessage(LogEvent event) {
        if (event == this.mCurrentEvent) {
            this.mCurrentEvent = null;
            return;
        }
        try {
            this.mCurrentEvent = event;
            this.mOut.writeObject(event);
            this.mOut.flush();
            this.mCurrentEvent = null;
        }
        catch (IOException e) {
            Thread t = Thread.currentThread();
            t.getThreadGroup().uncaughtException(t, e);
        }
    }

    @Override
    public void logException(LogEvent event) {
        this.logMessage(event);
    }
}

