/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.log;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.teatrove.trove.log.Log;
import org.teatrove.trove.log.LogEvent;
import org.teatrove.trove.log.LogListener;

public class LogEventParsingOutputStream
extends OutputStream {
    private Vector mListeners;
    private Log mSource;
    private int mType;
    private byte[] mOneByte = new byte[1];
    private ByteArrayOutputStream mMessageBuffer;
    private String mEncoding;
    private Thread mMessageThread;
    private Date mTimestamp;
    private boolean mTrackLF;

    public LogEventParsingOutputStream(Log source, int type) {
        this.mListeners = new Vector(2);
        this.mSource = source;
        this.mType = type;
        this.mMessageBuffer = new ByteArrayOutputStream();
    }

    public LogEventParsingOutputStream(Log source, int type, String encoding) {
        this.mListeners = new Vector(2);
        this.mSource = source;
        this.mType = type;
        this.mMessageBuffer = new ByteArrayOutputStream();
        this.mEncoding = encoding;
    }

    public void addLogListener(LogListener listener) {
        this.mListeners.addElement(listener);
    }

    public void removeLogListener(LogListener listener) {
        this.mListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flushLogEvent() throws UnsupportedEncodingException {
        LogEvent e;
        if (this.mMessageThread == null) {
            return;
        }
        String message = this.mEncoding == null ? this.mMessageBuffer.toString() : this.mMessageBuffer.toString(this.mEncoding);
        if (this.mMessageBuffer.size() > 10000) {
            this.mMessageBuffer = new ByteArrayOutputStream();
        } else {
            this.mMessageBuffer.reset();
        }
        if (this.mTimestamp == null) {
            e = new LogEvent(this.mSource, this.mType, message, this.mMessageThread);
        } else {
            e = new LogEvent(this.mSource, this.mType, message, this.mMessageThread, this.mTimestamp);
            this.mTimestamp = null;
        }
        Vector vector = this.mListeners;
        synchronized (vector) {
            Enumeration en = this.mListeners.elements();
            while (en.hasMoreElements()) {
                ((LogListener)en.nextElement()).logMessage(e);
            }
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.mOneByte[0] = (byte)b;
        this.write(this.mOneByte, 0, 1);
    }

    @Override
    public synchronized void write(byte[] array, int off, int len) throws IOException {
        if (!this.isEnabled()) {
            if (this.mMessageBuffer.size() > 0) {
                this.flushLogEvent();
            }
            return;
        }
        Thread current = Thread.currentThread();
        if (current != this.mMessageThread) {
            if (this.mMessageBuffer.size() > 0) {
                this.flushLogEvent();
            }
            this.mMessageThread = current;
        }
        int writtenLength = 0;
        int i = 0;
        for (i = 0; i < len; ++i) {
            byte b = array[i + off];
            if (b == 13) {
                this.mTrackLF = true;
                this.writeToBuffer(array, writtenLength + off, i - writtenLength);
                writtenLength = i + 1;
                this.flushLogEvent();
                continue;
            }
            if (b == 10) {
                if (this.mTrackLF) {
                    this.mTrackLF = false;
                    ++writtenLength;
                    continue;
                }
                this.writeToBuffer(array, writtenLength + off, i - writtenLength);
                writtenLength = i + 1;
                this.flushLogEvent();
                continue;
            }
            this.mTrackLF = false;
        }
        this.writeToBuffer(array, writtenLength + off, i - writtenLength);
    }

    @Override
    public synchronized void close() throws IOException {
        this.mMessageBuffer.close();
    }

    public boolean isEnabled() {
        return true;
    }

    private void writeToBuffer(byte[] array, int off, int len) {
        if (this.mMessageBuffer.size() == 0) {
            this.mTimestamp = new Date();
        }
        this.mMessageBuffer.write(array, off, len);
    }
}

