/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.teatrove.trove.io.ByteBuffer;
import org.teatrove.trove.io.ByteBufferOutputStream;
import org.teatrove.trove.io.ByteData;
import org.teatrove.trove.io.DefaultByteBuffer;
import org.teatrove.trove.io.FileByteBuffer;

public class SpilloverByteBuffer
implements ByteBuffer {
    private Group mGroup;
    private ByteBuffer mLocalBuffer;
    private ByteBuffer mSpillover;
    private List mCaptureBuffers;

    public SpilloverByteBuffer(Group group) {
        this.mGroup = group;
        this.mLocalBuffer = new DefaultByteBuffer();
    }

    @Override
    public long getBaseByteCount() throws IOException {
        if (this.mSpillover == null) {
            return this.mLocalBuffer.getBaseByteCount();
        }
        return this.mSpillover.getBaseByteCount();
    }

    @Override
    public long getByteCount() throws IOException {
        if (this.mSpillover == null) {
            return this.mLocalBuffer.getByteCount();
        }
        return this.mSpillover.getByteCount();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (this.mSpillover == null) {
            this.mLocalBuffer.writeTo(out);
        } else {
            this.mSpillover.writeTo(out);
        }
    }

    @Override
    public void append(byte b) throws IOException {
        List captureBuffers = this.mCaptureBuffers;
        if (captureBuffers != null) {
            int size = captureBuffers.size();
            for (int i = 0; i < size; ++i) {
                ((ByteBuffer)captureBuffers.get(i)).append(b);
            }
        }
        if (this.mSpillover == null) {
            if (this.mGroup.adjustLevel(1L)) {
                this.mLocalBuffer.append(b);
                return;
            }
            this.spillover();
        }
        this.mSpillover.append(b);
    }

    @Override
    public void append(byte[] bytes) throws IOException {
        this.append(bytes, 0, bytes.length);
    }

    @Override
    public void append(byte[] bytes, int offset, int length) throws IOException {
        List captureBuffers = this.mCaptureBuffers;
        if (captureBuffers != null) {
            int size = captureBuffers.size();
            for (int i = 0; i < size; ++i) {
                ((ByteBuffer)captureBuffers.get(i)).append(bytes, offset, length);
            }
        }
        if (this.mSpillover == null) {
            if (this.mGroup.adjustLevel(length)) {
                this.mLocalBuffer.append(bytes, offset, length);
                return;
            }
            this.spillover();
        }
        this.mSpillover.append(bytes, offset, length);
    }

    @Override
    public void appendSurrogate(ByteData s) throws IOException {
        if (s == null) {
            return;
        }
        List captureBuffers = this.mCaptureBuffers;
        if (captureBuffers != null) {
            int size = captureBuffers.size();
            for (int i = 0; i < size; ++i) {
                ((ByteBuffer)captureBuffers.get(i)).appendSurrogate(s);
            }
        }
        if (this.mSpillover == null) {
            this.mLocalBuffer.appendSurrogate(s);
        } else {
            this.mSpillover.appendSurrogate(s);
        }
    }

    @Override
    public void addCaptureBuffer(ByteBuffer buffer) {
        ArrayList<ByteBuffer> captureBuffers = this.mCaptureBuffers;
        if (captureBuffers == null) {
            captureBuffers = this.mCaptureBuffers = new ArrayList<ByteBuffer>();
        }
        captureBuffers.add(buffer);
    }

    @Override
    public void removeCaptureBuffer(ByteBuffer buffer) {
        List captureBuffers = this.mCaptureBuffers;
        if (captureBuffers != null) {
            captureBuffers.remove(buffer);
        }
    }

    @Override
    public void reset() throws IOException {
        List captureBuffers;
        this.mLocalBuffer.reset();
        if (this.mSpillover != null) {
            this.mSpillover.reset();
        }
        if ((captureBuffers = this.mCaptureBuffers) != null) {
            int size = captureBuffers.size();
            for (int i = 0; i < size; ++i) {
                ((ByteData)captureBuffers.get(i)).reset();
            }
        }
    }

    protected void finalize() throws IOException {
        if (this.mLocalBuffer != null) {
            long count = this.mLocalBuffer.getBaseByteCount();
            this.mLocalBuffer = null;
            this.mGroup.adjustLevel(-count);
        }
    }

    private void spillover() throws IOException {
        this.mSpillover = this.mGroup.createFileByteBuffer();
        this.mLocalBuffer.writeTo(new ByteBufferOutputStream(this.mSpillover));
        long count = this.mLocalBuffer.getBaseByteCount();
        this.mLocalBuffer = null;
        this.mGroup.adjustLevel(-count);
    }

    public static abstract class Group {
        private final long mThreshold;
        private long mLevel;

        public Group(long threshold) {
            this.mThreshold = threshold;
        }

        public final long getThreshold() {
            return this.mThreshold;
        }

        public final synchronized long getCurrentLevel() {
            return this.mLevel;
        }

        public abstract FileByteBuffer createFileByteBuffer() throws IOException;

        synchronized boolean adjustLevel(long delta) {
            long newLevel = this.mLevel + delta;
            if (newLevel > this.mThreshold) {
                return false;
            }
            if (newLevel < 0L) {
                newLevel = 0L;
            }
            this.mLevel = newLevel;
            return true;
        }
    }
}

