/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.teatrove.trove.io.ByteData;

public class FileByteData
implements ByteData {
    private static final Object NULL = new Object();
    private File mFile;
    private ThreadLocal mRAF = new ThreadLocal();

    public FileByteData(File file) {
        this.mFile = file;
        this.open();
    }

    @Override
    public long getByteCount() throws IOException {
        RandomAccessFile raf = this.open();
        if (raf == null) {
            return 0L;
        }
        return raf.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream out) throws IOException {
        RandomAccessFile raf = this.open();
        if (raf == null) {
            return;
        }
        try {
            int readAmount;
            long length = raf.length();
            int bufSize = length > 4000L ? 4000 : (int)length;
            byte[] inputBuffer = new byte[bufSize];
            raf.seek(0L);
            while ((readAmount = raf.read(inputBuffer, 0, bufSize)) > 0) {
                out.write(inputBuffer, 0, readAmount);
            }
        }
        finally {
            try {
                this.finalize();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object obj = this.mRAF.get();
        try {
            if (obj instanceof RandomAccessFile) {
                ((RandomAccessFile)obj).close();
            }
        }
        finally {
            this.mRAF.set(null);
        }
    }

    protected final void finalize() throws IOException {
        this.reset();
    }

    private RandomAccessFile open() {
        Object obj = this.mRAF.get();
        if (obj instanceof RandomAccessFile) {
            return (RandomAccessFile)obj;
        }
        if (obj == NULL) {
            return null;
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.mFile, "r");
            this.mRAF.set(raf);
        }
        catch (IOException e) {
            this.mRAF.set(NULL);
            Thread t = Thread.currentThread();
            t.getThreadGroup().uncaughtException(t, e);
        }
        return raf;
    }
}

